/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.parse.traversal;

import sk.antons.json.literal.impl.JsonLiteralImpl;
import sk.antons.json.parse.traversal.JsonContentHandler;
import sk.antons.json.parse.traversal.StopTraverse;
import sk.antons.json.source.JsonSource;

public class TraversalParser {
    private JsonSource source;
    private JsonContentHandler handler;
    private boolean started = false;

    public TraversalParser(JsonSource source, JsonContentHandler handler) {
        this.source = source;
        this.handler = handler;
    }

    public static TraversalParser instance(JsonSource source, JsonContentHandler handler) {
        return new TraversalParser(source, handler);
    }

    public void parse() {
        if (this.started) {
            throw new IllegalStateException("parser can be started only once");
        }
        try {
            this.started = true;
            this.handler.startDocument();
            int c = this.source.current();
            while (c != -1) {
                switch (c) {
                    case 123: {
                        this.handler.startObject();
                        this.source.move();
                        break;
                    }
                    case 125: {
                        this.handler.endObject();
                        this.source.move();
                        break;
                    }
                    case 91: {
                        this.handler.startArray();
                        this.source.move();
                        break;
                    }
                    case 93: {
                        this.handler.endArray();
                        this.source.move();
                        break;
                    }
                    case 58: {
                        this.handler.nameSeparator();
                        this.source.move();
                        break;
                    }
                    case 44: {
                        this.handler.valueSeparator();
                        this.source.move();
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.skipWhiteSpace(c);
                        break;
                    }
                    case 34: {
                        this.skipLiteralEscaped(c);
                        break;
                    }
                    default: {
                        this.skipLiteralSimple(c);
                    }
                }
                c = this.source.current();
            }
            this.handler.endDocument();
        }
        catch (StopTraverse c) {
        }
        catch (Exception e) {
            String contextInfo = null;
            try {
                contextInfo = this.handler.contextInfo();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String message = "Unable to parse input because of " + e.getMessage();
            if (contextInfo != null) {
                message = message + " [" + contextInfo + "]";
            }
            throw new IllegalArgumentException(message, e);
        }
    }

    private boolean isWhiteSpace(int c) {
        switch (c) {
            case 32: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 13: {
                return true;
            }
        }
        return false;
    }

    private boolean isNonLiteral(int c) {
        switch (c) {
            case 58: {
                return true;
            }
            case 44: {
                return true;
            }
            case 123: {
                return true;
            }
            case 125: {
                return true;
            }
            case 91: {
                return true;
            }
            case 93: {
                return true;
            }
            case 32: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 13: {
                return true;
            }
        }
        return false;
    }

    private void skipWhiteSpace2(int c) {
        while (c != -1 && this.isWhiteSpace(c)) {
            this.source.move();
            c = this.source.current();
        }
    }

    private void skipWhiteSpace(int c) {
        int startpos = this.source.startRecording();
        boolean cont = true;
        block4: while (cont) {
            switch (c) {
                case -1: {
                    cont = false;
                    break block4;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    cont = false;
                    break block4;
                }
            }
            this.source.move();
            c = this.source.current();
        }
        int endpos = this.source.stopRecording();
        String str = this.source.recordedContent();
        this.handler.whiteSpace(str, startpos, endpos - startpos);
    }

    private void skipLiteral(int c) {
        if (c == 34) {
            this.skipLiteralEscaped(c);
        } else {
            this.skipLiteralSimple(c);
        }
    }

    private void skipLiteralSimple2(int c) {
        int startpos = this.source.startRecording();
        while (c != -1 && !this.isNonLiteral(c)) {
            this.source.move();
            c = this.source.current();
        }
        int endpos = this.source.stopRecording();
        String str = this.source.recordedContent();
        this.handler.literal(JsonLiteralImpl.instance(str, startpos, endpos - startpos));
    }

    private void skipLiteralSimple(int c) {
        int startpos = this.source.startRecording();
        boolean cont = true;
        block4: while (cont) {
            switch (c) {
                case -1: {
                    cont = false;
                    break block4;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 44: 
                case 58: 
                case 91: 
                case 93: 
                case 123: 
                case 125: {
                    cont = false;
                    break block4;
                }
                default: {
                    this.source.move();
                    c = this.source.current();
                    continue block4;
                }
            }
        }
        int endpos = this.source.stopRecording();
        String str = this.source.recordedContent();
        this.handler.literal(JsonLiteralImpl.instance(str, startpos, endpos - startpos));
    }

    /*
     * Unable to fully structure code
     */
    private void skipLiteralEscaped(int c) {
        startpos = this.source.startRecording();
        escape = false;
        this.source.move();
        c = this.source.current();
        block4: while (c != -1) {
            block5: {
                if (!escape) break block5;
                escape = false;
                ** GOTO lbl-1000
            }
            switch (c) {
                case 92: {
                    escape = true;
                }
                case 34: {
                    this.source.move();
                    break block4;
                }
                default: lbl-1000:
                // 2 sources

                {
                    this.source.move();
                    c = this.source.current();
                    continue block4;
                }
            }
        }
        endpos = this.source.stopRecording();
        str = this.source.recordedContent();
        this.handler.literal(JsonLiteralImpl.instance(str, startpos, endpos - startpos));
    }
}

