/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.List;

public class JsonFormat {
    private Reader reader = null;
    private Writer writer = null;
    private boolean noindent = false;
    private boolean indent = false;
    private boolean cut = false;
    private char indentChar = (char)32;
    private int indentNum = 2;
    private int cutLength = 1;
    private List<String> indents = new ArrayList<String>();

    private JsonFormat(Reader reader) {
        this.reader = reader;
    }

    public static JsonFormat from(String json) {
        return new JsonFormat(new StringReader(json));
    }

    public static JsonFormat from(java.io.Reader json) {
        return new JsonFormat(new ReaderReader(json));
    }

    public JsonFormat noindent() {
        if (this.indent) {
            throw new IllegalStateException("Indendation was setup already.");
        }
        this.noindent = true;
        return this;
    }

    public JsonFormat indent(int num, char c) {
        if (this.noindent) {
            throw new IllegalStateException("No indendation was setup already.");
        }
        this.indent = true;
        this.indentNum = num;
        this.indentChar = c;
        return this;
    }

    public JsonFormat cutStringLiterals(int num) {
        this.cut = true;
        this.cutLength = num;
        return this;
    }

    public String toText() {
        int len = this.reader.length();
        if (len <= 0) {
            len = 100;
        }
        if (this.indent) {
            len *= 2;
        }
        this.writer = new StringWriter(len);
        this.process();
        this.writer.flush();
        return this.writer.result();
    }

    public void toWriter(java.io.Writer w) {
        this.writer = new WriterWriter(w);
        this.process();
        this.writer.flush();
    }

    private void process() {
        int ind = 0;
        int strlen = 0;
        int prev = 0;
        int prevNoSpace = 0;
        int prevprevNoSpace = 0;
        boolean notInJson = true;
        boolean inStringLiteral = false;
        while (this.reader.something()) {
            char c = this.reader.next();
            if (inStringLiteral) {
                if (c == '\"' && prev != 92) {
                    inStringLiteral = false;
                    strlen = 0;
                    this.writer.write(c);
                } else if (this.cut) {
                    if (this.cutLength > strlen) {
                        this.writer.write(c);
                    } else if (this.cutLength >= strlen && this.cutLength == strlen) {
                        if (prev == 92) {
                            this.writer.write("t...");
                        } else {
                            this.writer.write(" ...");
                        }
                    }
                    ++strlen;
                } else {
                    this.writer.write(c);
                }
            } else {
                switch (c) {
                    case '\"': {
                        if (prevNoSpace == 44 && prevprevNoSpace == 125 && this.indent) {
                            this.indent(ind);
                        }
                        inStringLiteral = true;
                        this.writer.write(c);
                        break;
                    }
                    case ':': {
                        if (this.indent) {
                            this.writer.write(" : ");
                            break;
                        }
                        this.writer.write(c);
                        break;
                    }
                    case ',': {
                        this.writer.write(c);
                        if (!this.indent || prevNoSpace == 125) break;
                        this.indent(ind);
                        break;
                    }
                    case '[': 
                    case '{': {
                        this.writer.write(c);
                        if (!this.indent) break;
                        this.indent(++ind);
                        break;
                    }
                    case ']': 
                    case '}': {
                        if (this.indent) {
                            this.indent(--ind);
                        }
                        this.writer.write(c);
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (this.noindent || this.indent) break;
                        this.writer.write(c);
                        break;
                    }
                    default: {
                        this.writer.write(c);
                    }
                }
            }
            prev = c;
            if (JsonFormat.isSpace(c)) continue;
            prevprevNoSpace = prevNoSpace;
            prevNoSpace = c;
        }
    }

    private void indent(int ind) {
        if (this.indents.size() <= ind) {
            StringBuilder sb = new StringBuilder();
            sb.append('\n');
            for (int i = 0; i <= ind; ++i) {
                if (i >= this.indents.size()) {
                    this.indents.add(sb.toString());
                }
                for (int j = 0; j < this.indentNum; ++j) {
                    sb.append(this.indentChar);
                }
            }
        }
        this.writer.write(this.indents.get(ind));
    }

    private static boolean isSpace(char c) {
        switch (c) {
            case ' ': {
                return true;
            }
            case '\r': {
                return true;
            }
            case '\n': {
                return true;
            }
            case '\t': {
                return true;
            }
        }
        return false;
    }

    private static class WriterWriter
    implements Writer {
        private java.io.Writer w = null;

        public WriterWriter(java.io.Writer w) {
            if (!(w instanceof BufferedWriter)) {
                w = new BufferedWriter(w);
            }
            this.w = w;
        }

        @Override
        public void write(char c) {
            try {
                this.w.write(c);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Unable to write", e);
            }
        }

        @Override
        public void write(String str) {
            try {
                this.w.write(str);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to write", e);
            }
        }

        @Override
        public void flush() {
            try {
                this.w.flush();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to flush", e);
            }
        }

        @Override
        public String result() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class StringWriter
    implements Writer {
        private StringBuilder sb = null;

        public StringWriter(int size) {
            this.sb = new StringBuilder(size);
        }

        @Override
        public void write(char c) {
            this.sb.append(c);
        }

        @Override
        public void write(String str) {
            this.sb.append(str);
        }

        @Override
        public String result() {
            return this.sb.toString();
        }

        @Override
        public void flush() {
        }
    }

    private static interface Writer {
        public void write(char var1);

        public void write(String var1);

        public String result();

        public void flush();
    }

    private static class ReaderReader
    implements Reader {
        private java.io.Reader reader = null;
        private boolean something = true;
        private char next = '\u0000';

        public ReaderReader(java.io.Reader r) {
            if (!(r instanceof BufferedReader)) {
                r = new BufferedReader(r);
            }
            this.reader = r;
            this.read();
        }

        @Override
        public boolean something() {
            return this.something;
        }

        @Override
        public char next() {
            if (this.something) {
                char c = this.next;
                this.read();
                return c;
            }
            throw new IllegalStateException("Unable to read next char");
        }

        private void read() {
            try {
                int c = this.reader.read();
                if (c < 0) {
                    this.something = false;
                } else {
                    this.next = (char)c;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to read next character", e);
            }
        }

        @Override
        public int length() {
            return -1;
        }
    }

    private static class StringReader
    implements Reader {
        private char[] chars = null;
        private int index = 0;
        private int length = 0;

        public StringReader(String s) {
            if (s != null) {
                this.chars = s.toCharArray();
                this.length = this.chars.length;
                this.index = 0;
            }
        }

        @Override
        public boolean something() {
            return this.index < this.length;
        }

        @Override
        public char next() {
            return this.chars[this.index++];
        }

        @Override
        public int length() {
            return this.length;
        }
    }

    private static interface Reader {
        public boolean something();

        public char next();

        public int length();
    }
}

