/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.impl;

import java.util.ArrayList;
import java.util.List;
import sk.antons.json.JsonArray;
import sk.antons.json.JsonValue;
import sk.antons.json.impl.JsonGroup;
import sk.antons.json.impl.JsonMember;
import sk.antons.json.impl.JsonValueImpl;
import sk.antons.json.match.Match;
import sk.antons.json.match.PathMatcher;
import sk.antons.json.template.JsonArrayListWrapper;

public class JsonArrayImpl
extends JsonValueImpl
implements JsonArray,
JsonGroup,
JsonMember {
    private List<JsonValue> values = new ArrayList<JsonValue>();

    public List<JsonValue> values() {
        return this.values;
    }

    @Override
    public void toCompactString(StringBuilder sb) {
        sb.append('[');
        boolean first = true;
        for (JsonValue value : this.values) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            ((JsonValueImpl)value).toCompactString(sb);
        }
        sb.append(']');
    }

    @Override
    public void toPrettyString(StringBuilder sb, String prefix, String indent) {
        sb.append("[\n").append(prefix).append(indent);
        boolean first = true;
        for (JsonValue value : this.values) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            ((JsonValueImpl)value).toPrettyString(sb, prefix + indent, indent);
        }
        sb.append("\n");
        sb.append(prefix).append(']');
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public JsonValue get(int index) {
        return this.values.get(index);
    }

    @Override
    public JsonValue remove(int index) {
        return this.values.remove(index);
    }

    @Override
    public JsonValue first() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    @Override
    public JsonValue last() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(this.values.size() - 1);
    }

    @Override
    public JsonArray add(JsonValue value) {
        if (value == null) {
            throw new IllegalArgumentException("JsonArray member can't be null");
        }
        this.values.add(value);
        if (value instanceof JsonMember) {
            ((JsonMember)((Object)value)).setGroup(this);
        }
        return this;
    }

    @Override
    public JsonArray add(JsonValue value, int index) {
        if (value == null) {
            throw new IllegalArgumentException("JsonArray member can't be null");
        }
        this.values.add(index, value);
        if (value instanceof JsonMember) {
            ((JsonMember)((Object)value)).setGroup(this);
        }
        return this;
    }

    @Override
    public List<JsonValue> toList() {
        ArrayList<JsonValue> list = new ArrayList<JsonValue>();
        list.addAll(this.values);
        return list;
    }

    @Override
    public int memberIndex(JsonMember m) {
        if (m == null) {
            return -1;
        }
        if (!(m instanceof JsonValue)) {
            return -1;
        }
        return this.values.indexOf(m);
    }

    @Override
    public JsonValue findFirst(PathMatcher matcher, List<String> path) {
        Match result = matcher.match(path, this);
        if (result == Match.NOPE) {
            return null;
        }
        if (result == Match.FULLY) {
            return this;
        }
        int index = 0;
        for (JsonValue item : this.values) {
            String name = "" + index++;
            path.add(name);
            JsonValue rv = ((JsonValueImpl)item).findFirst(matcher, path);
            if (rv != null) {
                return rv;
            }
            path.remove(path.size() - 1);
        }
        return null;
    }

    @Override
    public void findAll(PathMatcher matcher, List<JsonValue> values, List<String> path) {
        Match result = matcher.match(path, this);
        if (result == Match.NOPE) {
            return;
        }
        if (result == Match.FULLY) {
            values.add(this);
            return;
        }
        int index = 0;
        for (JsonValue item : this.values) {
            String name = "" + index++;
            path.add(name);
            ((JsonValueImpl)item).findAll(matcher, values, path);
            path.remove(path.size() - 1);
        }
    }

    public void remove(JsonValue value) {
        if (value == null) {
            return;
        }
        this.values.remove(value);
    }

    public void replaceBy(JsonValue oldValue, JsonValue newValue) {
        int index = this.memberIndex((JsonMember)((Object)oldValue));
        if (index < 0) {
            this.add(newValue);
        } else {
            this.remove(oldValue);
            this.add(newValue, index);
        }
    }

    @Override
    public JsonValue copy() {
        JsonArrayImpl rv = new JsonArrayImpl();
        for (JsonValue value : this.values) {
            rv.add(value.copy());
        }
        return rv;
    }

    @Override
    public Object asTemplateParam() {
        return JsonArrayListWrapper.instance(this);
    }
}

