/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.json.impl;

import java.util.ArrayList;
import java.util.List;
import sk.antons.json.JsonArray;
import sk.antons.json.JsonObject;
import sk.antons.json.JsonValue;
import sk.antons.json.impl.JsonArrayImpl;
import sk.antons.json.impl.JsonAttributeImpl;
import sk.antons.json.impl.JsonGroup;
import sk.antons.json.impl.JsonMember;
import sk.antons.json.literal.JsonBoolLiteral;
import sk.antons.json.literal.JsonExpLiteral;
import sk.antons.json.literal.JsonFracLiteral;
import sk.antons.json.literal.JsonIntLiteral;
import sk.antons.json.literal.JsonLiteral;
import sk.antons.json.literal.JsonNullLiteral;
import sk.antons.json.literal.JsonStringLiteral;
import sk.antons.json.match.PathMatcher;

public abstract class JsonValueImpl
implements JsonValue,
JsonMember {
    protected JsonGroup group = null;

    @Override
    public JsonGroup group() {
        return this.group;
    }

    @Override
    public void setGroup(JsonGroup group) {
        this.group = group;
    }

    @Override
    public JsonObject asObject() {
        return (JsonObject)((Object)this);
    }

    @Override
    public JsonArray asArray() {
        return (JsonArray)((Object)this);
    }

    @Override
    public JsonNullLiteral asNullLiteral() {
        return (JsonNullLiteral)((Object)this);
    }

    @Override
    public JsonBoolLiteral asBoolLiteral() {
        return (JsonBoolLiteral)((Object)this);
    }

    @Override
    public JsonExpLiteral asExpLiteral() {
        return (JsonExpLiteral)((Object)this);
    }

    @Override
    public JsonFracLiteral asFracLiteral() {
        return (JsonFracLiteral)((Object)this);
    }

    @Override
    public JsonIntLiteral asIntLiteral() {
        return (JsonIntLiteral)((Object)this);
    }

    @Override
    public JsonStringLiteral asStringLiteral() {
        return (JsonStringLiteral)((Object)this);
    }

    @Override
    public JsonLiteral asLiteral() {
        return (JsonLiteral)((Object)this);
    }

    @Override
    public boolean isObject() {
        return this instanceof JsonObject;
    }

    @Override
    public boolean isArray() {
        return this instanceof JsonArray;
    }

    @Override
    public boolean isNullLiteral() {
        return this instanceof JsonNullLiteral;
    }

    @Override
    public boolean isBoolLiteral() {
        return this instanceof JsonBoolLiteral;
    }

    @Override
    public boolean isExpLiteral() {
        return this instanceof JsonExpLiteral;
    }

    @Override
    public boolean isFracLiteral() {
        return this instanceof JsonFracLiteral;
    }

    @Override
    public boolean isIntLiteral() {
        return this instanceof JsonIntLiteral;
    }

    @Override
    public boolean isStringLiteral() {
        return this instanceof JsonStringLiteral;
    }

    @Override
    public boolean isLiteral() {
        return this instanceof JsonLiteral;
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        this.toCompactString(sb);
        return sb.toString();
    }

    @Override
    public String toPrettyString(String indent) {
        StringBuilder sb = new StringBuilder();
        this.toPrettyString(sb, "", indent);
        return sb.toString();
    }

    public abstract void toCompactString(StringBuilder var1);

    public abstract void toPrettyString(StringBuilder var1, String var2, String var3);

    @Override
    public List<JsonValue> findAll(PathMatcher matcher) {
        ArrayList<JsonValue> list = new ArrayList<JsonValue>();
        ArrayList<String> path = new ArrayList<String>();
        this.findAll(matcher, list, path);
        return list;
    }

    @Override
    public JsonValue findFirst(PathMatcher matcher) {
        ArrayList<String> path = new ArrayList<String>();
        return this.findFirst(matcher, path);
    }

    @Override
    public List<String> findAllLiterals(PathMatcher matcher) {
        ArrayList<String> rv = new ArrayList<String>();
        List<JsonValue> values = this.findAll(matcher);
        if (values.isEmpty()) {
            return rv;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (JsonValue value : values) {
            if (value instanceof JsonLiteral) {
                list.add(value.asLiteral().stringValue());
                continue;
            }
            return rv;
        }
        return list;
    }

    @Override
    public String findFirstLiteral(PathMatcher matcher) {
        JsonValue value = this.findFirst(matcher);
        if (value == null) {
            return null;
        }
        if (value instanceof JsonLiteral) {
            return value.asLiteral().stringValue();
        }
        return null;
    }

    public abstract JsonValue findFirst(PathMatcher var1, List<String> var2);

    public abstract void findAll(PathMatcher var1, List<JsonValue> var2, List<String> var3);

    @Override
    public JsonValue parent() {
        if (this instanceof JsonMember) {
            JsonGroup g = this.group();
            while (g != null && !(g instanceof JsonValue)) {
                if (g instanceof JsonMember) {
                    g = ((JsonMember)((Object)g)).group();
                    continue;
                }
                g = null;
            }
            if (g instanceof JsonValue) {
                return (JsonValue)((Object)g);
            }
            return null;
        }
        return null;
    }

    @Override
    public int parentIndex() {
        if (this instanceof JsonMember) {
            JsonMember m = this;
            JsonGroup g = m.group();
            while (g != null && !(g instanceof JsonValue)) {
                if (g instanceof JsonMember) {
                    m = (JsonMember)((Object)g);
                    g = m.group();
                    continue;
                }
                g = null;
            }
            if (g == null) {
                return -1;
            }
            return g.memberIndex(m);
        }
        return -1;
    }

    @Override
    public String[] path() {
        ArrayList<String> list = new ArrayList<String>();
        JsonMember m = null;
        JsonGroup g = null;
        if (this instanceof JsonMember) {
            m = this;
            while (m != null) {
                g = m.group();
                if (g != null) {
                    if (g instanceof JsonArrayImpl) {
                        int i = g.memberIndex(m);
                        list.add(String.valueOf(i));
                    } else if (g instanceof JsonAttributeImpl) {
                        JsonAttributeImpl a = (JsonAttributeImpl)g;
                        list.add(a.name().stringValue());
                    }
                    if (g instanceof JsonMember) {
                        m = (JsonMember)((Object)g);
                        continue;
                    }
                    m = null;
                    continue;
                }
                m = null;
            }
        }
        String[] rv = new String[list.size()];
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = (String)list.get(rv.length - 1 - i);
        }
        return rv;
    }

    @Override
    public String pathAsString() {
        StringBuilder sb = new StringBuilder();
        String[] path = this.path();
        if (path != null) {
            for (String string : path) {
                sb.append("/").append(string);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isDescendantOf(JsonValue parent) {
        if (parent == null) {
            return false;
        }
        if (parent == this) {
            return true;
        }
        JsonValueImpl m = null;
        JsonGroup g = null;
        if (this instanceof JsonMember) {
            m = this;
            g = m.group();
            if (g == null) {
                return false;
            }
            return g.isDescendantOf(parent);
        }
        return false;
    }

    @Override
    public void remove() {
        if (this.group == null) {
            return;
        }
        if (this.group instanceof JsonAttributeImpl) {
            ((JsonAttributeImpl)this.group).remove();
        } else if (this.group instanceof JsonArrayImpl) {
            ((JsonArrayImpl)this.group).remove(this);
        }
        this.setGroup(null);
    }

    @Override
    public void replaceBy(JsonValue newValue) {
        if (this.group == null) {
            return;
        }
        if (this.group instanceof JsonAttributeImpl) {
            ((JsonAttributeImpl)this.group).setValue(newValue);
        } else if (this.group instanceof JsonArrayImpl) {
            ((JsonArrayImpl)this.group).replaceBy(this, newValue);
        }
        this.setGroup(null);
    }

    @Override
    public String name() {
        JsonValueImpl m = null;
        JsonGroup g = null;
        if (this instanceof JsonMember && (m = this) != null && (g = m.group()) != null) {
            if (g instanceof JsonArrayImpl) {
                int i = g.memberIndex(m);
                return String.valueOf(i);
            }
            if (g instanceof JsonAttributeImpl) {
                JsonAttributeImpl a = (JsonAttributeImpl)g;
                return a.name().stringValue();
            }
        }
        return null;
    }
}

