/*
 * Decompiled with CFR 0.152.
 */
package a2u.tn.utils.computer.calculator;

import a2u.tn.utils.computer.StringUtil;
import a2u.tn.utils.computer.calculator.CalculatingException;
import a2u.tn.utils.computer.calculator.Converter;
import a2u.tn.utils.computer.calculator.Function;
import a2u.tn.utils.computer.calculator.Type;
import a2u.tn.utils.computer.formula.FPBlock;
import a2u.tn.utils.computer.formula.FPFunction;
import a2u.tn.utils.computer.formula.FPLiteralNumber;
import a2u.tn.utils.computer.formula.FPLiteralString;
import a2u.tn.utils.computer.formula.FPOperation;
import a2u.tn.utils.computer.formula.FPValue;
import a2u.tn.utils.computer.formula.Formula;
import a2u.tn.utils.computer.formula.FormulaPart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class Calculator {
    private Map<String, Function> functions;
    private Map<Class<?>, Type> knownTypes;
    private Converter converters = new Converter();

    public Calculator() {
        this.functions = new LinkedHashMap<String, Function>();
        this.knownTypes = new LinkedHashMap();
    }

    public Object calc(Formula formula, Object startObj) {
        try {
            FormulaPart root = formula.getRootPart();
            Object result = this.calcArgument(root, startObj, 0, null);
            return result;
        }
        catch (CalculatingException cex) {
            StringBuilder b = new StringBuilder();
            for (Throwable tr = cex; tr != null; tr = tr.getCause()) {
                b.append("ERROR: ");
                b.append(tr).append("\n");
            }
            throw new CalculatingException("Error calculate formula:\n" + formula.toString() + "\nby object " + String.valueOf(startObj) + "\n" + b.toString(), cex);
        }
    }

    public Object calc(String query, Object startObj) {
        Formula formula = new Formula(query);
        return this.calc(formula, startObj);
    }

    public Object calcArgument(FormulaPart part, Object value, int rowIndex, Collection<Object> allRows) {
        if (part instanceof FPOperation) {
            return this.calcOperation((FPOperation)part, value, rowIndex, allRows);
        }
        if (part instanceof FPFunction) {
            return this.calcFunction((FPFunction)part, value, rowIndex, allRows);
        }
        if (part instanceof FPValue) {
            return this.calcValue((FPValue)part, value);
        }
        if (part instanceof FPLiteralNumber) {
            FPLiteralNumber exn = (FPLiteralNumber)part;
            Number v = exn.getValue();
            return v;
        }
        if (part instanceof FPLiteralString) {
            FPLiteralString exs = (FPLiteralString)part;
            String v = exs.getValue();
            return v;
        }
        if (part instanceof FPBlock) {
            FPBlock exb = (FPBlock)part;
            Object v = this.calcArgument(exb.getOperation(), value, rowIndex, allRows);
            return v;
        }
        throw new CalculatingException("Illegal operation '" + part + "'.");
    }

    private Object calcOperation(FPOperation operation, Object startval, int rowIndex, Collection<Object> allRows) {
        Object value1 = this.calcArgument(operation.getArg1(), startval, rowIndex, allRows);
        if (value1 == null) {
            return null;
        }
        if (operation.getArg2() == null) {
            return value1;
        }
        Object value2 = this.calcArgument(operation.getArg2(), startval, rowIndex, allRows);
        Type type = this.getType(value1.getClass());
        switch (operation.getCommand()) {
            case mul: {
                return type.mul(value1, value2);
            }
            case div: {
                return type.div(value1, value2);
            }
            case plus: {
                return type.plus(value1, value2);
            }
            case minus: {
                return type.minus(value1, value2);
            }
            case equal: {
                return type.equal(value1, value2);
            }
            case notequal: {
                return type.notequal(value1, value2);
            }
            case great: {
                return type.great(value1, value2);
            }
            case greatEqual: {
                return type.greatEqual(value1, value2);
            }
            case less: {
                return type.less(value1, value2);
            }
            case lessEqual: {
                return type.lessEqual(value1, value2);
            }
            case and: {
                return type.and(value1, value2);
            }
            case or: {
                return type.or(value1, value2);
            }
            case xor: {
                return type.xor(value1, value2);
            }
            case in: {
                return this.calcOperationIn(value1, value2);
            }
            case notin: {
                return this.calcOperationNotIn(value1, value2);
            }
            case addToDim: {
                return this.calcOperationAddToDim(value1, value2);
            }
        }
        throw new CalculatingException("Unknown operation '" + (Object)((Object)operation.getCommand()) + "'.");
    }

    private Object calcOperationIn(Object value, Object valueList) {
        List list = (List)this.toType(List.class, valueList);
        Type type = this.getType(value.getClass());
        for (Object valInList : list) {
            boolean isPresent = type.equal(value, valInList);
            if (!isPresent) continue;
            return true;
        }
        return false;
    }

    private Object calcOperationNotIn(Object value, Object valueList) {
        List list = (List)this.toType(List.class, valueList);
        Type type = this.getType(value.getClass());
        for (Object valInList : list) {
            boolean isPresent = type.equal(value, valInList);
            if (!isPresent) continue;
            return false;
        }
        return true;
    }

    private Object calcOperationAddToDim(Object value1, Object value2) {
        List val1 = (List)this.toType(List.class, value1);
        List val2 = (List)this.toType(List.class, value2);
        ArrayList result = new ArrayList();
        result.addAll(val1);
        result.addAll(val2);
        return result;
    }

    private Object calcFunction(FPFunction function, Object value, int rowIndex, Collection<Object> allRows) {
        Function fn = this.getFunction(function.getName().toLowerCase());
        if (fn == null) {
            throw new CalculatingException("Function '" + function.getName() + "' is not defined.");
        }
        LinkedHashMap<String, Object> paramValues = new LinkedHashMap<String, Object>();
        if (!fn.getParameters().isEmpty()) {
            if (function.getParams().isEmpty()) {
                String par2 = StringUtil.collectionToString(", ", fn.getParameters(), Function.Parameter::getTypeName);
                throw new CalculatingException("For function '" + function.getName() + "' parameter is not specified. You need specify (" + par2 + ").");
            }
            if (fn.getParameters().size() != function.getParams().size()) {
                String par1 = StringUtil.collectionToString(", ", function.getParams(), obj -> obj.getClass().getName());
                String par2 = StringUtil.collectionToString(", ", fn.getParameters(), Function.Parameter::getTypeName);
                throw new CalculatingException("Function " + function.getName() + "(" + par1 + ") is not defined. You have function " + function.getName() + "(" + par2 + ").");
            }
            for (int ix = 0; ix < fn.getParameters().size(); ++ix) {
                Function.Parameter parameter = fn.getParameters().get(ix);
                FormulaPart def = function.getParams().get(ix);
                if (FormulaPart.class.isAssignableFrom(parameter.getType())) {
                    paramValues.put(parameter.getName(), def);
                    continue;
                }
                Object paramListValue = this.calcArgument(def, value, rowIndex, allRows);
                paramValues.put(parameter.getName(), paramListValue);
            }
        } else if (!function.getParams().isEmpty()) {
            throw new CalculatingException("Function '" + function.getName() + "' no need in parameters.");
        }
        Object result = fn.run(paramValues, value, rowIndex, allRows);
        return result;
    }

    private Object calcValue(FPValue fpValue, Object arg1) {
        Collection<Object> resultList = this.calcValueProcess(fpValue, arg1);
        if (resultList.isEmpty()) {
            return null;
        }
        if (resultList.size() == 1) {
            return resultList.iterator().next();
        }
        return resultList;
    }

    private Collection<Object> calcValueProcess(FPValue fpValue, Object fromObj) {
        FPValue current = fpValue;
        StringBuilder path = new StringBuilder();
        Collection<Object> resultRows = new ArrayList<Object>();
        resultRows.add(fromObj);
        do {
            Collection<Object> filteredValues;
            Collection<Object> valueList;
            path.append(".").append(current.getFieldName());
            try {
                valueList = this.extractValues(current.getFieldName(), resultRows);
            }
            catch (Exception ex) {
                throw new CalculatingException("Error on getting values from '" + String.valueOf(fromObj) + "' by code '" + current.getFieldName() + "' in path " + path + ".", ex);
            }
            if (current.getFilter() != null) {
                filteredValues = new ArrayList<Object>();
                int ix = 0;
                for (Object value : valueList) {
                    Object isPassObj = this.calcArgument(current.getFilter(), value, ix, valueList);
                    boolean isPass = (Boolean)this.toType(Boolean.class, isPassObj);
                    if (isPass) {
                        filteredValues.add(value);
                    }
                    ++ix;
                }
            } else {
                filteredValues = valueList;
            }
            resultRows = filteredValues;
        } while ((current = current.getNext()) != null);
        return resultRows;
    }

    protected abstract Collection<Object> extractValues(String var1, Collection<Object> var2);

    public void addFunction(Function function) {
        this.functions.put(function.getName().toLowerCase(), function);
    }

    public Function getFunction(String name) {
        return this.functions.get(name.toLowerCase());
    }

    public void addType(Type descriptor) {
        this.knownTypes.put(descriptor.forClass(), descriptor);
        descriptor.fillConverter(this.converters);
    }

    public Type getType(Class<?> forClass) {
        Type type = null;
        for (Map.Entry<Class<?>, Type> entry : this.knownTypes.entrySet()) {
            if (!entry.getKey().isAssignableFrom(forClass)) continue;
            type = entry.getValue();
            break;
        }
        if (type == null) {
            throw new CalculatingException("Datatype '" + forClass.getName() + "' has no descriptor.");
        }
        return type;
    }

    public <T> T toType(Class<?> toCls, Object value) {
        return this.converters.toType(toCls, value);
    }

    public boolean equalValues(Object v1, Object v2) {
        Type type = this.getType(v1.getClass());
        return type.equal(v1, v2);
    }
}

