/*
 * Decompiled with CFR 0.152.
 */
package a2u.tn.utils.computer.calculator;

import a2u.tn.utils.computer.calculator.UnknownDataTypeException;
import java.util.LinkedHashMap;
import java.util.Map;

public class Converter {
    public Map<Class<?>, Map<Class<?>, ConvertHandler<?>>> converters = new LinkedHashMap();

    public void addConverter(Class<?> toCls, Class<?> fromCls, ConvertHandler<?> handler) {
        Map<Class<?>, ConvertHandler<?>> to = this.converters.get(toCls);
        if (to == null) {
            to = new LinkedHashMap();
            this.converters.put(toCls, to);
        }
        if (fromCls == null) {
            to.put(NullClass.class, handler);
        } else {
            to.put(fromCls, handler);
        }
    }

    public <T> T toType(Class<?> toCls, Object value) {
        Object result;
        if (toCls == null) {
            throw new NullPointerException("Parameter 'toCls' is not defined.");
        }
        Map<Class<?>, ConvertHandler<?>> to = this.find(this.converters, toCls);
        if (to == null) {
            throw new UnknownDataTypeException("Not found converters to class " + toCls.getClass().getName() + ".");
        }
        Class key = value == null ? NullClass.class : value.getClass();
        ConvertHandler<?> handler = this.find(to, key);
        if (handler == null) {
            handler = to.get(AnyClass.class);
        }
        if (handler == null) {
            throw new UnknownDataTypeException("Not found converters to class " + toCls.getClass().getName() + " from " + (value == null ? "null" : value.getClass()) + ".");
        }
        Object resultT = result = handler.convert(value);
        return (T)resultT;
    }

    private <T> T find(Map<Class<?>, T> map, Class<?> clazz) {
        for (Map.Entry<Class<?>, T> entry : map.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static interface ConvertHandler<H> {
        public H convert(Object var1);
    }

    public static interface NullClass {
    }

    public static interface AnyClass {
    }
}

