/*
 * Decompiled with CFR 0.152.
 */
package a2u.tn.utils.computer.formula;

import a2u.tn.utils.computer.StringUtil;
import a2u.tn.utils.computer.formula.FormulaPart;
import java.util.Collections;
import java.util.List;

public class FPFunction
implements FormulaPart {
    private String name;
    private List<FormulaPart> params;

    public FPFunction(String name, List<FormulaPart> params) {
        this.name = name;
        this.params = params == null ? Collections.emptyList() : params;
    }

    public String getName() {
        return this.name;
    }

    public List<FormulaPart> getParams() {
        return this.params;
    }

    public String toString() {
        return this.name + (this.params != null ? "(" + String.valueOf(this.params) + ")" : "");
    }

    @Override
    public void toFormated(StringBuilder b, int indent) {
        b.append(".fn[").append(this.name);
        if (this.params != null && !this.params.isEmpty()) {
            b.append('(');
            for (int ix = 0; ix < this.params.size(); ++ix) {
                if (ix > 0) {
                    b.append(",");
                }
                b.append("\n");
                StringUtil.repeat(b, " ", indent + 2);
                FormulaPart pp = this.params.get(ix);
                pp.toFormated(b, indent + 2);
            }
            b.append('\n');
            StringUtil.repeat(b, " ", indent);
            b.append(')');
        }
        b.append(']');
    }

    @Override
    public String toJson() {
        StringBuilder b = new StringBuilder();
        b.append("{type: 'function', name:'").append(this.name).append("'");
        if (this.params != null && !this.params.isEmpty()) {
            b.append(", params: [");
            for (int ix = 0; ix < this.params.size(); ++ix) {
                if (ix > 0) {
                    b.append(',');
                }
                FormulaPart pp = this.params.get(ix);
                b.append(pp.toJson());
            }
            b.append(']');
        }
        b.append('}');
        return b.toString();
    }
}

