/*
 * Decompiled with CFR 0.152.
 */
package a2u.tn.utils.computer.formula;

import a2u.tn.utils.computer.StringUtil;
import a2u.tn.utils.computer.formula.FormulaPart;

public class FPOperation
implements FormulaPart {
    Command command;
    FormulaPart arg1;
    FormulaPart arg2;
    private FPOperation parent;

    FPOperation() {
    }

    public static FPOperation make(FormulaPart arg1, Command command, FormulaPart arg2) {
        if (arg2 instanceof FPOperation) {
            FPOperation root = (FPOperation)arg2;
            if (command.isPriorThen(root.getCommand())) {
                FPOperation top = FPOperation.findtop(command, root);
                FPOperation op1 = new FPOperation();
                op1.arg1 = arg1;
                op1.command = command;
                op1.arg2 = top.getArg1();
                top.arg1 = op1;
                return root;
            }
            FPOperation op1 = new FPOperation();
            op1.arg1 = arg1;
            op1.command = command;
            op1.arg2 = root;
            return op1;
        }
        FPOperation op = new FPOperation();
        op.arg1 = arg1;
        op.command = command;
        op.arg2 = arg2;
        return op;
    }

    private static FPOperation findtop(Command command, FPOperation top) {
        if (top.arg1 instanceof FPOperation) {
            FPOperation next = (FPOperation)top.arg1;
            if (command.isPriorThen(next.getCommand())) {
                return FPOperation.findtop(command, next);
            }
            return top;
        }
        return top;
    }

    private FPOperation(FPOperation parent) {
        this.parent = parent;
    }

    public FPOperation(Command command, FormulaPart arg1) {
        this.command = command;
        this.arg1 = arg1;
    }

    public Command getCommand() {
        return this.command;
    }

    public FormulaPart getArg1() {
        return this.arg1;
    }

    public FormulaPart getArg2() {
        return this.arg2;
    }

    public FPOperation addOperation(Command command, FormulaPart arg) {
        if (this.arg1 == null) {
            this.arg1 = arg;
            this.command = command;
            return this;
        }
        if (command == null) {
            this.arg2 = arg;
            FPOperation topNop = this;
            while (topNop.parent != null) {
                topNop = topNop.parent;
            }
            return topNop;
        }
        if (this.command.prior == command.prior) {
            FPOperation nop = new FPOperation(this);
            nop.command = command;
            nop.arg1 = arg;
            this.arg2 = nop;
            return nop;
        }
        if (this.command.prior < command.prior) {
            FPOperation nop;
            this.arg2 = arg;
            if (this.parent == null) {
                nop = new FPOperation(null);
                nop.command = command;
                nop.arg1 = this;
                this.parent = nop;
            } else {
                FPOperation parentOP = this.findEqualParentOrTop(command.prior);
                nop = new FPOperation(parentOP.parent);
                nop.command = command;
                nop.arg1 = parentOP;
                parentOP.parent = nop;
            }
            return nop;
        }
        FPOperation nop = new FPOperation(this);
        nop.command = command;
        nop.arg1 = arg;
        nop.parent = this;
        this.arg2 = nop;
        return nop;
    }

    private FPOperation findEqualParentOrTop(int prior) {
        FPOperation op = this;
        while (op.command.prior < prior && op.parent != null) {
            op = op.parent;
        }
        return op;
    }

    public String toString() {
        return this.arg1 + (this.command != null ? " " + (Object)((Object)this.command) + " " + this.arg2 : "");
    }

    @Override
    public void toFormated(StringBuilder b, int indent) {
        int indent2 = indent + 2;
        b.append(".operation[ ").append((Object)this.command).append(": ");
        b.append("\n");
        StringUtil.repeat(b, " ", indent2);
        if (this.arg1 != null) {
            this.arg1.toFormated(b, indent2);
        } else {
            b.append("null");
        }
        b.append(",");
        b.append("\n");
        StringUtil.repeat(b, " ", indent2);
        if (this.arg2 != null) {
            this.arg2.toFormated(b, indent2);
        } else {
            b.append("null");
        }
        b.append("\n");
        StringUtil.repeat(b, " ", indent);
        b.append("]");
    }

    @Override
    public String toJson() {
        return "{type: 'operation', command: '" + (Object)((Object)this.command) + "', arg1: " + (this.arg1 == null ? "null" : this.arg1.toJson()) + ", arg2: " + (this.arg2 == null ? "null" : this.arg2.toJson()) + "}";
    }

    public static enum Command {
        mul(1),
        div(1),
        plus(2),
        minus(2),
        equal(3),
        notequal(3),
        great(3),
        greatEqual(3),
        less(3),
        lessEqual(3),
        in(3),
        notin(3),
        and(4),
        or(4),
        xor(4),
        addToDim(5);

        public int prior;

        private Command(int prior) {
            this.prior = prior;
        }

        public boolean isPriorThen(Command oper) {
            return this.prior <= oper.prior;
        }

        public static Command fromString(String string) {
            switch (string) {
                case "*": {
                    return mul;
                }
                case "/": {
                    return div;
                }
                case "+": {
                    return plus;
                }
                case "-": {
                    return minus;
                }
                case "=": {
                    return equal;
                }
                case "!=": {
                    return notequal;
                }
                case ">": {
                    return great;
                }
                case ">=": {
                    return greatEqual;
                }
                case "<": {
                    return less;
                }
                case "<=": {
                    return lessEqual;
                }
                case "in": {
                    return in;
                }
                case "notin": {
                    return notin;
                }
                case "and": {
                    return and;
                }
                case "or": {
                    return or;
                }
                case "xor": {
                    return xor;
                }
                case ",": {
                    return addToDim;
                }
            }
            throw new IllegalArgumentException("invalid operation '" + string + "'.");
        }

        public static boolean isOperation(String string) {
            switch (string) {
                case "*": 
                case "/": 
                case "+": 
                case "-": 
                case "=": 
                case "!=": 
                case ">": 
                case ">=": 
                case "<": 
                case "<=": 
                case "in": 
                case "notin": 
                case "and": 
                case "or": 
                case "xor": 
                case ",": {
                    return true;
                }
            }
            return false;
        }
    }
}

