/*
 * Decompiled with CFR 0.152.
 */
package a2u.tn.utils.computer.formula;

import a2u.tn.utils.computer.StringUtil;
import a2u.tn.utils.computer.formula.FormulaPart;

public class FPValue
implements FormulaPart {
    private String fldName;
    private FormulaPart filter;
    private FPValue next = null;

    public FPValue(String fieldName) {
        this.fldName = fieldName;
    }

    public String getFieldName() {
        return this.fldName;
    }

    public FormulaPart getFilter() {
        return this.filter;
    }

    public void setFilter(FormulaPart filter) {
        this.filter = filter;
    }

    public FPValue getNext() {
        return this.next;
    }

    public void setNext(FPValue next) {
        this.next = next;
    }

    public FPValue getWithoutEnd() {
        FPValue start;
        if (this.next == null) {
            return null;
        }
        FPValue last = start = this.clone();
        while (last.next != null && last.next.next != null) {
            FPValue part;
            last.next = part = last.next.clone();
            last = part;
        }
        last.next = null;
        return start;
    }

    public FPValue getTargetPart() {
        FPValue part = this;
        while (part.next != null) {
            part = part.next;
        }
        return part;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(".");
        b.append(this.fldName);
        if (this.filter != null) {
            b.append("(").append(this.filter).append(")");
        }
        if (this.next != null) {
            b.append(this.next);
        }
        return b.toString();
    }

    @Override
    public void toFormated(StringBuilder b, int indent) {
        int indent2 = indent + 2;
        b.append(".value[");
        b.append(this.fldName);
        if (this.filter != null) {
            b.append("(");
            b.append("\n");
            StringUtil.repeat(b, " ", indent2);
            this.filter.toFormated(b, indent2);
            b.append("\n");
            StringUtil.repeat(b, " ", indent);
            b.append(")");
        }
        b.append("]");
        if (this.filter != null) {
            b.append("\n");
            StringUtil.repeat(b, " ", indent);
        }
        if (this.next != null) {
            if (this.filter == null) {
                b.append("\n");
                StringUtil.repeat(b, " ", indent);
            }
            this.next.toFormated(b, indent);
        }
    }

    @Override
    public String toJson() {
        return "{type= 'value', fieldName: '" + this.fldName + "', filter: " + (this.filter == null ? "null" : this.filter.toJson()) + ", next: " + (this.next == null ? "null" : this.next.toJson()) + "}";
    }

    public FPValue clone() {
        FPValue newvalue = new FPValue(this.fldName);
        newvalue.filter = this.filter;
        newvalue.next = this.next;
        return newvalue;
    }
}

