/*
 * Decompiled with CFR 0.152.
 */
package a2u.tn.utils.computer.formula;

import a2u.tn.utils.computer.StringUtil;
import a2u.tn.utils.computer.formula.FPBlock;
import a2u.tn.utils.computer.formula.FPFunction;
import a2u.tn.utils.computer.formula.FPLiteralNumber;
import a2u.tn.utils.computer.formula.FPLiteralString;
import a2u.tn.utils.computer.formula.FPOperation;
import a2u.tn.utils.computer.formula.FPValue;
import a2u.tn.utils.computer.formula.FormulaException;
import a2u.tn.utils.computer.formula.FormulaPart;
import a2u.tn.utils.computer.formula.Parser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Formula {
    private FormulaPart rootPart;

    public Formula(String query) {
        if (query == null || query.isEmpty()) {
            throw new FormulaException("Query can not be null or empty.");
        }
        this.rootPart = this.parseArg(query, new AtomicInteger(0));
    }

    public Formula(FormulaPart rootPart) {
        this.rootPart = rootPart;
    }

    public FormulaPart getRootPart() {
        return this.rootPart;
    }

    private FormulaPart parseArg(String text, AtomicInteger ix) {
        FPOperation.Command command;
        FormulaPart arg;
        Parser.Element part = Parser.extractElement(text, ix);
        if (part == null) {
            throw new FormulaException("Unexpected end of expression at position " + ix.get() + ", in text '" + text + "'.");
        }
        switch (part.type) {
            case FIELD: {
                arg = this.makeValue(part, text, ix);
                break;
            }
            case STRING: {
                arg = new FPLiteralString(part.value);
                break;
            }
            case NUMBER: {
                arg = new FPLiteralNumber(part.value);
                break;
            }
            case BLOCK: {
                arg = this.makeBlock(part.value);
                break;
            }
            case IDENTY: {
                arg = this.makeFunction(part, text, ix);
                break;
            }
            case OPERATOR: {
                if (part.value.equals("-") || part.value.equals("+")) {
                    AtomicInteger ix2 = new AtomicInteger(ix.intValue());
                    Parser.Element part2 = Parser.extractElement(text, ix2);
                    if (part2 != null && part2.type == Parser.ElementType.NUMBER) {
                        arg = new FPLiteralNumber(part.value + part2.value);
                        ix.set(ix2.intValue());
                        break;
                    }
                    throw new FormulaException("Illegal part " + part + "' at position " + (ix.get() - part.value.length()) + " in text '" + text + "'.");
                }
                throw new FormulaException("Illegal part " + part + "' at position " + (ix.get() - part.value.length()) + " in text '" + text + "'.");
            }
            default: {
                throw new FormulaException("Illegal part " + part + "' at position " + (ix.get() - part.value.length()) + " in text '" + text + "'.");
            }
        }
        Parser.Element part2 = Parser.extractElement(text, ix);
        if (part2 == null) {
            return arg;
        }
        switch (part2.type) {
            case OPERATOR: {
                command = FPOperation.Command.fromString(part2.value);
                break;
            }
            case IDENTY: {
                if (FPOperation.Command.isOperation(part2.value)) {
                    command = FPOperation.Command.fromString(part2.value);
                    break;
                }
                throw new FormulaException("Illegal part " + part2 + " at position " + (ix.get() - part2.value.length()) + ", expected operator. Source text '" + text + "'.");
            }
            default: {
                throw new FormulaException("Illegal part " + part2 + " at position " + (ix.get() - part2.value.length()) + ", expected operator. Source text '" + text + "'.");
            }
        }
        return this.makeOperation(arg, command, text, ix);
    }

    private FPOperation makeOperation(FormulaPart arg1, FPOperation.Command command, String text, AtomicInteger ix) {
        FormulaPart arg2 = this.parseArg(text, ix);
        if (arg2 == null) {
            throw new FormulaException("Operation '" + arg1 + " " + (Object)((Object)command) + "' is unfinished at position " + ix.get() + ", in text '" + text + "'.");
        }
        FPOperation op = FPOperation.make(arg1, command, arg2);
        return op;
    }

    private FPValue makeValue(Parser.Element part, String text, AtomicInteger ix) {
        FPValue val = new FPValue(part.value);
        char next = Parser.getNextSymbol(text, ix.get());
        if (next == '(') {
            part = Parser.extractElement(text, ix);
            if (part == null) {
                throw new FormulaException("Unexpected end of expression '" + StringUtil.substr(text, -15) + "'.");
            }
            if (part.value.length() > 0) {
                FormulaPart filter = this.parseArg(part.value, new AtomicInteger(0));
                val.setFilter(filter);
            }
            next = Parser.getNextSymbol(text, ix.get());
        }
        if (next == '.') {
            part = Parser.extractElement(text, ix);
            FPValue nextValue = this.makeValue(part, text, ix);
            val.setNext(nextValue);
        }
        return val;
    }

    private FPBlock makeBlock(String text) {
        FormulaPart arg = this.parseArg(text, new AtomicInteger(0));
        FPBlock blk = new FPBlock(arg);
        return blk;
    }

    private FPFunction makeFunction(Parser.Element part, String text, AtomicInteger ix) {
        String fnName = part.value;
        List<FormulaPart> fnParams = Collections.emptyList();
        char next = Parser.getNextSymbol(text, ix.get());
        if (next == '(') {
            part = Parser.extractElement(text, ix);
            if (part == null) {
                throw new InternalError("Unexpected end of expression '" + StringUtil.substr(text, -15) + "'.");
            }
            FormulaPart params = this.parseArg(part.value, new AtomicInteger(0));
            if (params != null) {
                fnParams = new ArrayList<FormulaPart>();
                this.convertPartToList(params, fnParams);
            }
        }
        FPFunction fn = new FPFunction(fnName, fnParams);
        return fn;
    }

    private void convertPartToList(FormulaPart part, List<FormulaPart> list) {
        if (part instanceof FPOperation) {
            FPOperation op = (FPOperation)part;
            if (op.getCommand() == FPOperation.Command.addToDim) {
                list.add(op.getArg1());
                this.convertPartToList(op.getArg2(), list);
            } else {
                list.add(op);
            }
        } else {
            list.add(part);
        }
    }

    public String toString() {
        return this.rootPart.toString();
    }

    public String toFormated() {
        StringBuilder b = new StringBuilder();
        this.rootPart.toFormated(b, 0);
        return b.toString();
    }

    public String toJson() {
        return this.rootPart.toJson();
    }
}

