/*
 * Decompiled with CFR 0.152.
 */
package a2u.tn.utils.computer.formula;

import a2u.tn.utils.computer.formula.FormulaException;
import java.util.concurrent.atomic.AtomicInteger;

class Parser {
    Parser() {
    }

    public static Element extractElement(String text, AtomicInteger ix) {
        int len = text.length();
        if (len <= ix.get()) {
            return null;
        }
        Element elt = new Element();
        StringBuilder b = new StringBuilder();
        while (ix.get() < len) {
            char c = text.charAt(ix.get());
            if (c == '.') {
                elt.type = ElementType.FIELD;
                ix.addAndGet(1);
                Parser.getIdentify(b, text, ix);
                elt.value = b.toString();
                return elt;
            }
            if (c == '\'') {
                elt.type = ElementType.STRING;
                Parser.getString(b, text, ix);
                elt.value = b.toString();
                return elt;
            }
            if (c == '(') {
                elt.type = ElementType.BLOCK;
                Parser.getEntry(b, text, ix);
                elt.value = b.toString();
                return elt;
            }
            if (Character.isDigit(c)) {
                elt.type = ElementType.NUMBER;
                Parser.getNumber(b, text, ix);
                elt.value = b.toString();
                return elt;
            }
            if (Character.isLetter(c)) {
                elt.type = ElementType.IDENTY;
                Parser.getIdentify(b, text, ix);
                elt.value = b.toString();
                return elt;
            }
            if (c == '=' || c == '+' || c == '-' || c == '/' || c == '*' || c == ',') {
                elt.type = ElementType.OPERATOR;
                elt.value = String.valueOf(c);
                ix.addAndGet(1);
                return elt;
            }
            if (c == '!' || c == '<' || c == '>') {
                elt.type = ElementType.OPERATOR;
                Parser.getOperator(b, text, ix);
                elt.value = b.toString();
                return elt;
            }
            if (Parser.isWhiteSpace(c)) {
                ix.addAndGet(1);
                continue;
            }
            throw new FormulaException("Invalid character '" + c + "' at position " + ix.get() + " in text '" + text + "'.");
        }
        return null;
    }

    protected static void getEntry(StringBuilder b, String text, AtomicInteger ix) {
        int len = text.length();
        char c = text.charAt(ix.get());
        if (c != '(') {
            throw new InternalError("Invalid character '" + c + "' at position " + ix.get() + " in text '" + text + "'.");
        }
        ix.addAndGet(1);
        int entreNum = 1;
        while (ix.get() < len) {
            c = text.charAt(ix.get());
            if (c == '(') {
                ++entreNum;
                b.append(c);
                ix.addAndGet(1);
                continue;
            }
            if (c == ')') {
                if (entreNum == 1) {
                    ix.addAndGet(1);
                    return;
                }
                --entreNum;
                b.append(c);
                ix.addAndGet(1);
                continue;
            }
            if (c == '\'') {
                b.append(c);
                Parser.getString(b, text, ix);
                b.append(c);
                continue;
            }
            b.append(c);
            ix.addAndGet(1);
        }
        throw new FormulaException("Unexpected end of block in text '" + text + "', no " + entreNum + " parentheses.");
    }

    protected static void getString(StringBuilder b, String text, AtomicInteger ix) {
        int index = ix.get();
        char quoteSymbol = text.charAt(index);
        if (quoteSymbol != '\'' && quoteSymbol != '\"') {
            throw new FormulaException("Invalid symbol (" + quoteSymbol + ") at position " + ix.get() + " in text '" + text + "'. Require (') or (\").");
        }
        index = ix.addAndGet(1);
        int len = text.length();
        while (index < len) {
            char c = text.charAt(index);
            if (c == '\\') {
                b.append(c);
                index = ix.addAndGet(1);
                if (index >= len) {
                    throw new FormulaException("Unexpected end of string in text '" + text + "', obtained value '" + b.toString() + "'.");
                }
                char next = text.charAt(index);
                b.append(next);
            } else {
                if (c == quoteSymbol) {
                    ix.addAndGet(1);
                    return;
                }
                b.append(c);
            }
            index = ix.addAndGet(1);
        }
        throw new FormulaException("Unexpected end of block in text '" + text + "', no closing quotation marks.");
    }

    protected static void getIdentify(StringBuilder b, String text, AtomicInteger ix) {
        int len = text.length();
        int index = ix.get();
        if (index >= len) {
            return;
        }
        char c = text.charAt(ix.get());
        if (!Character.isLetter(c) && !Parser.isWhiteSpace(c) && c != '*' && c != '/' && c != '+' && c != '-' && c != '=' && c != '<' && c != '>' && c != ',') {
            throw new InternalError("Invalid character '" + c + "' at position " + ix.get() + " in text '" + text + "'.");
        }
        while (index < len && (Character.isLetterOrDigit(c = text.charAt(index)) || c == '_')) {
            b.append(c);
            index = ix.addAndGet(1);
        }
    }

    protected static void getNumber(StringBuilder b, String text, AtomicInteger ix) {
        char c = text.charAt(ix.get());
        if (!Character.isDigit(c)) {
            throw new InternalError("Invalid character '" + c + "' at position " + ix.get() + " in text '" + text + "'.");
        }
        int len = text.length();
        boolean oneDot = false;
        int index = ix.get();
        while (index < len) {
            c = text.charAt(index);
            if (Character.isDigit(c)) {
                b.append(c);
            } else {
                if (c != '.') break;
                if (!oneDot) {
                    oneDot = true;
                    b.append(c);
                } else {
                    throw new FormulaException("Invalid number at position " + ix.get() + " in text '" + text + "'.");
                }
            }
            index = ix.addAndGet(1);
        }
    }

    protected static void getOperator(StringBuilder b, String text, AtomicInteger ix) {
        char c = text.charAt(ix.getAndAdd(1));
        b.append(c);
        if (ix.get() >= text.length()) {
            return;
        }
        char nextC = text.charAt(ix.get());
        if (nextC == '=') {
            b.append(nextC);
            ix.addAndGet(1);
        }
    }

    public static char getNextSymbol(String text, int index) {
        int len = text.length();
        if (len <= index) {
            return '\u0000';
        }
        while (index < len) {
            char c = text.charAt(index);
            if (Parser.isWhiteSpace(c)) {
                ++index;
                continue;
            }
            return c;
        }
        return '\u0000';
    }

    private static boolean isWhiteSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\u0085': 
            case '\u00a0': 
            case '\u1680': 
            case '\u2000': 
            case '\u2001': 
            case '\u2002': 
            case '\u2003': 
            case '\u2004': 
            case '\u2005': 
            case '\u2006': 
            case '\u2007': 
            case '\u2008': 
            case '\u2009': 
            case '\u200a': 
            case '\u2028': 
            case '\u2029': 
            case '\u202f': 
            case '\u205f': 
            case '\u3000': {
                return true;
            }
        }
        return false;
    }

    static class Element {
        ElementType type;
        String value;

        Element() {
        }

        public String toString() {
            return this.type.name() + ": " + this.value;
        }
    }

    public static enum ElementType {
        FIELD,
        IDENTY,
        BLOCK,
        STRING,
        NUMBER,
        OPERATOR;

    }
}

