/*
 * Decompiled with CFR 0.152.
 */
package a2u.tn.utils.computer.maplist;

import a2u.tn.utils.computer.calculator.Calculator;
import a2u.tn.utils.computer.maplist.functions.Count;
import a2u.tn.utils.computer.maplist.functions.DateToStr;
import a2u.tn.utils.computer.maplist.functions.Distinct;
import a2u.tn.utils.computer.maplist.functions.False;
import a2u.tn.utils.computer.maplist.functions.First;
import a2u.tn.utils.computer.maplist.functions.Last;
import a2u.tn.utils.computer.maplist.functions.Like;
import a2u.tn.utils.computer.maplist.functions.Max;
import a2u.tn.utils.computer.maplist.functions.MaxInRows;
import a2u.tn.utils.computer.maplist.functions.Min;
import a2u.tn.utils.computer.maplist.functions.Null;
import a2u.tn.utils.computer.maplist.functions.Nvl;
import a2u.tn.utils.computer.maplist.functions.RowNum;
import a2u.tn.utils.computer.maplist.functions.RowsCount;
import a2u.tn.utils.computer.maplist.functions.ToDate;
import a2u.tn.utils.computer.maplist.functions.True;
import a2u.tn.utils.computer.maplist.types.TBool;
import a2u.tn.utils.computer.maplist.types.TDate;
import a2u.tn.utils.computer.maplist.types.TDouble;
import a2u.tn.utils.computer.maplist.types.TFloat;
import a2u.tn.utils.computer.maplist.types.TInt;
import a2u.tn.utils.computer.maplist.types.TList;
import a2u.tn.utils.computer.maplist.types.TLong;
import a2u.tn.utils.computer.maplist.types.TMap;
import a2u.tn.utils.computer.maplist.types.TString;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

public class MapListEngine
extends Calculator {
    public MapListEngine() {
        this.fillFunctions();
        this.fillTypes();
    }

    private void fillFunctions() {
        this.addFunction(new Null(this));
        this.addFunction(new Nvl(this));
        this.addFunction(new True(this));
        this.addFunction(new False(this));
        this.addFunction(new Distinct(this));
        this.addFunction(new First(this));
        this.addFunction(new Last(this));
        this.addFunction(new RowNum(this));
        this.addFunction(new RowsCount(this));
        this.addFunction(new MaxInRows(this));
        this.addFunction(new Count(this));
        this.addFunction(new Max(this));
        this.addFunction(new Min(this));
        this.addFunction(new ToDate(this));
        this.addFunction(new DateToStr(this));
        this.addFunction(new Like(this));
    }

    private void fillTypes() {
        this.addType(new TInt(this));
        this.addType(new TLong(this));
        this.addType(new TBool(this));
        this.addType(new TString(this));
        this.addType(new TDouble(this));
        this.addType(new TDate(this));
        this.addType(new TFloat(this));
        this.addType(new TList(this));
        this.addType(new TMap(this));
    }

    @Override
    protected Collection<Object> extractValues(String byCode, Collection<Object> fromObjList) {
        if (fromObjList == null) {
            return null;
        }
        LinkedHashSet<Object> valueListSet = new LinkedHashSet<Object>();
        if (byCode.length() == 0) {
            valueListSet.addAll(fromObjList);
            return valueListSet;
        }
        for (Object fromObj : fromObjList) {
            if (fromObj == null) {
                valueListSet.add(null);
                continue;
            }
            if (fromObj instanceof Map) {
                Map map = (Map)fromObj;
                Object mapval = map.get(byCode);
                if (mapval instanceof Collection) {
                    valueListSet.addAll((Collection)mapval);
                    continue;
                }
                valueListSet.add(mapval);
                continue;
            }
            throw new IllegalArgumentException("Illegal value fromObj " + fromObj.getClass().getName() + ": '" + String.valueOf(fromObj) + "'.");
        }
        return valueListSet;
    }
}

