/*
 * Decompiled with CFR 0.152.
 */
package a2u.tn.utils.computer.maplist.types;

import a2u.tn.utils.computer.calculator.Calculator;
import a2u.tn.utils.computer.calculator.Converter;
import a2u.tn.utils.computer.calculator.Type;

public class TBool
extends Type {
    public TBool(Calculator calculator) {
        super(calculator);
    }

    @Override
    public void fillConverter(Converter converter) {
        converter.addConverter(Boolean.class, null, value -> false);
        converter.addConverter(Boolean.class, Integer.class, value -> (Integer)value > 0);
        converter.addConverter(Boolean.class, Long.class, value -> (Long)value > 0L);
        converter.addConverter(Boolean.class, Float.class, value -> ((Float)value).floatValue() > 0.0f);
        converter.addConverter(Boolean.class, Double.class, value -> (Double)value > 0.0);
        converter.addConverter(Boolean.class, Character.class, value -> ((Character)value).charValue() > '\u0000');
        converter.addConverter(Boolean.class, Boolean.class, value -> (boolean)((Boolean)value));
        converter.addConverter(Boolean.class, String.class, value -> {
            String bval;
            switch (bval = String.valueOf(value).trim().toLowerCase()) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
                case "\u0434\u0430": {
                    return true;
                }
                case "\u043d\u0435\u0442": {
                    return false;
                }
                case "yes": {
                    return true;
                }
                case "no": {
                    return false;
                }
                case "on": {
                    return true;
                }
                case "off": {
                    return false;
                }
                case "null": {
                    return false;
                }
            }
            return true;
        });
        converter.addConverter(Boolean.class, Converter.AnyClass.class, value -> value != null);
    }

    @Override
    public Class<?> forClass() {
        return Boolean.class;
    }

    @Override
    public boolean equal(Object v1, Object v2) {
        Boolean bool1 = (Boolean)this.calculator.toType(Boolean.class, v1);
        Boolean bool2 = (Boolean)this.calculator.toType(Boolean.class, v2);
        return bool1.booleanValue() == bool2.booleanValue();
    }

    @Override
    public boolean notequal(Object v1, Object v2) {
        Boolean bool1 = (Boolean)this.calculator.toType(Boolean.class, v1);
        Boolean bool2 = (Boolean)this.calculator.toType(Boolean.class, v2);
        return bool1.booleanValue() != bool2.booleanValue();
    }
}

