/*
 * Decompiled with CFR 0.152.
 */
package a2u.tn.utils.computer.maplist.types;

import a2u.tn.utils.computer.calculator.Calculator;
import a2u.tn.utils.computer.calculator.Converter;
import a2u.tn.utils.computer.calculator.Type;
import a2u.tn.utils.computer.maplist.ValueOverflowException;
import java.util.Date;

public class TLong
extends Type {
    public TLong(Calculator calculator) {
        super(calculator);
    }

    @Override
    public void fillConverter(Converter converter) {
        converter.addConverter(Long.class, null, value -> 0L);
        converter.addConverter(Long.class, Integer.class, value -> (long)((Integer)value).intValue());
        converter.addConverter(Long.class, Long.class, value -> value);
        converter.addConverter(Long.class, Float.class, value -> (long)((Float)value).floatValue());
        converter.addConverter(Long.class, Double.class, value -> (long)((Double)value).doubleValue());
        converter.addConverter(Long.class, Character.class, value -> (long)((Character)value).charValue());
        converter.addConverter(Long.class, Boolean.class, value -> (Boolean)value != false ? 1L : 0L);
        converter.addConverter(Long.class, Date.class, value -> ((Date)value).getTime());
        converter.addConverter(Long.class, String.class, value -> Long.parseLong((String)value));
    }

    @Override
    public Class<?> forClass() {
        return Long.class;
    }

    @Override
    public Long mul(Object v1, Object v2) {
        Long value1 = (Long)this.calculator.toType(Long.class, v1);
        Long value2 = (Long)this.calculator.toType(Long.class, v2);
        try {
            return Math.multiplyExact((long)value1, value2);
        }
        catch (ArithmeticException ex) {
            throw new ValueOverflowException("Result is very big or small for long. Value1='" + value1 + "'. Value2='" + value2 + "'.");
        }
    }

    @Override
    public Long div(Object v1, Object v2) {
        Long value1 = (Long)this.calculator.toType(Long.class, v1);
        Long value2 = (Long)this.calculator.toType(Long.class, v2);
        return value1 / value2;
    }

    @Override
    public Long plus(Object v1, Object v2) {
        Long value1 = (Long)this.calculator.toType(Long.class, v1);
        Long value2 = (Long)this.calculator.toType(Long.class, v2);
        try {
            return Math.addExact(value1, value2);
        }
        catch (ArithmeticException ex) {
            throw new ValueOverflowException("Result is very big or small for long. Value1='" + value1 + "'. Value2='" + value2 + "'.");
        }
    }

    @Override
    public Long minus(Object v1, Object v2) {
        Long value1 = (Long)this.calculator.toType(Long.class, v1);
        Long value2 = (Long)this.calculator.toType(Long.class, v2);
        try {
            return Math.subtractExact(value1, value2);
        }
        catch (ArithmeticException ex) {
            throw new ValueOverflowException("Result is very big or small for long. Value1='" + value1 + "'. Value2='" + value2 + "'.");
        }
    }

    @Override
    public boolean equal(Object v1, Object v2) {
        Long value1 = (Long)this.calculator.toType(Long.class, v1);
        Long value2 = (Long)this.calculator.toType(Long.class, v2);
        return value1.longValue() == value2.longValue();
    }

    @Override
    public boolean notequal(Object v1, Object v2) {
        Long value1 = (Long)this.calculator.toType(Long.class, v1);
        Long value2 = (Long)this.calculator.toType(Long.class, v2);
        return value1.longValue() != value2.longValue();
    }

    @Override
    public boolean great(Object v1, Object v2) {
        Long value1 = (Long)this.calculator.toType(Long.class, v1);
        Long value2 = (Long)this.calculator.toType(Long.class, v2);
        return value1 > value2;
    }

    @Override
    public boolean greatEqual(Object v1, Object v2) {
        Long value1 = (Long)this.calculator.toType(Long.class, v1);
        Long value2 = (Long)this.calculator.toType(Long.class, v2);
        return value1 >= value2;
    }

    @Override
    public boolean less(Object v1, Object v2) {
        Long value1 = (Long)this.calculator.toType(Long.class, v1);
        Long value2 = (Long)this.calculator.toType(Long.class, v2);
        return value1 < value2;
    }

    @Override
    public boolean lessEqual(Object v1, Object v2) {
        Long value1 = (Long)this.calculator.toType(Long.class, v1);
        Long value2 = (Long)this.calculator.toType(Long.class, v2);
        return value1 <= value2;
    }
}

