/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.interface_it.api;

import com.github.aro_tech.interface_it.api.MixinCodeGenerator;
import com.github.aro_tech.interface_it.api.MultiFileOutputOptions;
import com.github.aro_tech.interface_it.api.options.SimpleSingleFileOutputOptions;
import com.github.aro_tech.interface_it.format.CodeFormatter;
import com.github.aro_tech.interface_it.meta.arguments.ArgumentNameSource;
import com.github.aro_tech.interface_it.policy.DeprecationPolicy;
import com.github.aro_tech.interface_it.ui.meta.error.UnableToCreateOutputDirectory;
import com.github.aro_tech.interface_it.util.ClassNameUtils;
import com.github.aro_tech.interface_it.util.FileSystem;
import com.github.aro_tech.interface_it.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CoreMixinGenerator
implements MixinCodeGenerator {
    private final FileSystem fileSystem;
    private final DeprecationPolicy deprecationPolicy;
    private final CodeFormatter formatter;
    final Predicate<? super Method> STATIC_METHODS_ONLY = m -> Modifier.isStatic(m.getModifiers());

    public CoreMixinGenerator() {
        this.fileSystem = FileUtils.getDefaultFileSystem();
        this.deprecationPolicy = DeprecationPolicy.PROPAGATE_DEPRECATION;
        this.formatter = CodeFormatter.getDefault();
    }

    public CoreMixinGenerator(FileSystem fileSystem, DeprecationPolicy deprecationPolicy, CodeFormatter formatter) {
        this.fileSystem = fileSystem;
        this.deprecationPolicy = deprecationPolicy;
        this.formatter = formatter;
    }

    protected List<Method> listStaticMethodsForClass(Class<?> clazz) {
        return this.listFilteredSortedMethodsForClass(clazz, this.STATIC_METHODS_ONLY);
    }

    private List<Method> listFilteredSortedMethodsForClass(Class<?> clazz, Predicate<? super Method> methodFilter) {
        return Arrays.stream(clazz.getMethods()).filter(methodFilter).sorted(this.makeMethodSorter()).collect(Collectors.toList());
    }

    private Comparator<? super Method> makeMethodSorter() {
        return (m1, m2) -> {
            int val = m1.getName().compareTo(m2.getName());
            int parameterCountM1 = m1.getParameterCount();
            if (val == 0) {
                val = Integer.compare(parameterCountM1, m2.getParameterCount());
            }
            if (val == 0) {
                val = this.compareSimpleTypeNamesOfParameters((Method)m1, (Method)m2, val, parameterCountM1);
            }
            if (val == 0) {
                val = m1.toGenericString().compareTo(m2.toGenericString());
            }
            return val;
        };
    }

    private int compareSimpleTypeNamesOfParameters(Method m1, Method m2, int val, int parameterCountM1) {
        for (int i = 0; val == 0 && i < parameterCountM1; ++i) {
            val = ClassNameUtils.extractSimpleName(m1.getParameters()[i].getParameterizedType().getTypeName()).toLowerCase().compareTo(ClassNameUtils.extractSimpleName(m2.getParameters()[i].getParameterizedType().getTypeName()).toLowerCase());
        }
        return val;
    }

    public String makeDelegateMethod(String targetInterfaceName, Method method, Set<String> importsOut, ArgumentNameSource argumentNameSource) {
        StringBuilder buf = new StringBuilder();
        String genericStringForMethod = method.toGenericString();
        String declaringClassTypeName = method.getDeclaringClass().getTypeName();
        String methodName = method.getName();
        this.formatter.appendMethodComment(buf, methodName, genericStringForMethod, declaringClassTypeName, this.generateParamsForJavadocLink(method)).append(this.lineBreak(0)).append(this.makeMethodSignature(method, importsOut, argumentNameSource, targetInterfaceName)).append(" {").append(this.lineBreak(2)).append(this.makeDelegateCall(method, targetInterfaceName, importsOut, argumentNameSource)).append(this.lineBreak(1)).append("}").append(this.lineBreak(0));
        return buf.toString();
    }

    private String lineBreak(int indentations) {
        return this.formatter.newlineWithIndentations(indentations);
    }

    private String generateParamsForJavadocLink(Method method) {
        StringBuilder paramsForJavadocLink = new StringBuilder();
        for (Class<?> cur : method.getParameterTypes()) {
            if (paramsForJavadocLink.length() > 0) {
                paramsForJavadocLink.append(',');
            }
            paramsForJavadocLink.append(cur.getTypeName());
        }
        return paramsForJavadocLink.toString();
    }

    @Deprecated
    protected String makeMethodSignature(Method method, Set<String> importNamesOut, ArgumentNameSource argumentNameSource) {
        return this.makeMethodSignature(method, importNamesOut, argumentNameSource, "");
    }

    protected String makeMethodSignature(Method method, Set<String> importNamesOut, ArgumentNameSource argumentNameSource, String targetInterfaceName) {
        String indentationUnit = this.formatter.getIndentationUnit();
        StringBuilder buf = new StringBuilder();
        if (this.shouldDeprecate(method)) {
            buf.append(indentationUnit).append("@Deprecated").append(this.lineBreak(0));
        }
        buf.append(indentationUnit).append("default ").append(this.makeGenericMarkerAndUpdateImports(method, importNamesOut)).append(this.getAdjustedReturnTypeName(method, importNamesOut, targetInterfaceName)).append(' ').append(method.getName()).append('(');
        this.appendMethodArgumentsInSignature(method, importNamesOut, buf, argumentNameSource, targetInterfaceName);
        buf.append(')');
        this.addThrowsClauseToSignatureUpdatingImports(method, importNamesOut, buf);
        return buf.toString();
    }

    private String getAdjustedReturnTypeName(Method method, Set<String> importNamesOut, String targetInterfaceName) {
        String extractedReturnTypeName = this.adjustTypeNameAndUpdateImportsIfAppropriate(importNamesOut, targetInterfaceName, this.adjustTypeNameForUntypedParameterization(this.getReturnTypeNameFromMethod(method), method.getReturnType().getTypeParameters()));
        return extractedReturnTypeName;
    }

    private String getReturnTypeNameFromMethod(Method method) {
        String typeName = method.getGenericReturnType().getTypeName();
        String declaringClassName = method.getDeclaringClass().getCanonicalName();
        return this.adjustTypeNameToCorrectDoublingOfOuterClass(typeName, declaringClassName);
    }

    private String adjustTypeNameToCorrectDoublingOfOuterClass(String typeName, String declaringClassName) {
        String doubleDeclaringClass = declaringClassName + '.' + declaringClassName;
        if (typeName.indexOf(doubleDeclaringClass) >= 0) {
            return typeName.replace(doubleDeclaringClass, declaringClassName);
        }
        return typeName;
    }

    private String adjustTypeNameAndUpdateImportsIfAppropriate(Set<String> importNamesOut, String targetInterfaceName, String rawTypeName) {
        String extractedTypeName = rawTypeName;
        if (this.doNotNeedToQualifyTypeName(targetInterfaceName, rawTypeName)) {
            extractedTypeName = CoreMixinGenerator.extractShortNameAndUpdateImports(importNamesOut, rawTypeName);
        }
        return extractedTypeName.replace('$', '.');
    }

    private boolean doNotNeedToQualifyTypeName(String targetInterfaceName, String rawTypeName) {
        return !this.hasTypeConflict(ClassNameUtils.extractSimpleName(rawTypeName), "" + targetInterfaceName);
    }

    private boolean hasTypeConflict(String simpleTypeName, String conflictingName) {
        if (simpleTypeName.startsWith(conflictingName)) {
            return this.isSameTypeOrNestedType(simpleTypeName, conflictingName);
        }
        return false;
    }

    private boolean isSameTypeOrNestedType(String simpleTypeName, String conflictingName) {
        return simpleTypeName.length() == conflictingName.length() || simpleTypeName.charAt(conflictingName.length()) == '.';
    }

    private boolean shouldDeprecate(Method method) {
        return this.isDeprecated(method) && this.deprecationPolicy == DeprecationPolicy.PROPAGATE_DEPRECATION;
    }

    protected boolean isDeprecated(Method method) {
        return ((Deprecated[])method.getDeclaredAnnotationsByType(Deprecated.class)).length > 0;
    }

    private void addThrowsClauseToSignatureUpdatingImports(Method method, Set<String> importNamesOut, StringBuilder buf) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes.length > 0) {
            buf.append(" throws ").append(this.makeCommaDelimitedExceptionTypesListUpdatingImports(importNamesOut, exceptionTypes));
        }
    }

    private String makeCommaDelimitedExceptionTypesListUpdatingImports(Set<String> importNamesOut, Class<?>[] exceptionTypes) {
        return String.join((CharSequence)", ", Arrays.stream(exceptionTypes).map(type -> CoreMixinGenerator.extractShortNameAndUpdateImports(importNamesOut, type.getTypeName())).collect(Collectors.toList()));
    }

    private String makeGenericMarkerAndUpdateImports(Method method, Set<String> importNamesOut) {
        TypeVariable<Method>[] typeParameters;
        StringBuilder buf = new StringBuilder();
        for (TypeVariable<Method> cur : typeParameters = method.getTypeParameters()) {
            this.appendOpeningOrDelimiter(buf);
            buf.append(cur.getName());
            Type[] bounds = cur.getBounds();
            if (!this.hasSuperclassBound(bounds)) continue;
            this.appendAndImportExtendedType(importNamesOut, buf, bounds);
        }
        this.appendClosingIfOpened(buf);
        return buf.toString();
    }

    private void appendClosingIfOpened(StringBuilder buf) {
        if (buf.length() > 0) {
            buf.append('>').append(' ');
        }
    }

    private void appendOpeningOrDelimiter(StringBuilder buf) {
        if (buf.length() > 0) {
            buf.append(",");
        } else {
            buf.append('<');
        }
    }

    private boolean hasSuperclassBound(Type[] bounds) {
        return bounds.length > 0 && Arrays.stream(bounds).noneMatch(t -> t.getTypeName().endsWith("java.lang.Object"));
    }

    private void appendAndImportExtendedType(Set<String> importNamesOut, StringBuilder buf, Type[] bounds) {
        buf.append(" extends ");
        for (int i = 0; i < bounds.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            String typeName = bounds[i].getTypeName();
            buf.append(ClassNameUtils.extractSimpleName(typeName));
            importNamesOut.addAll(ClassNameUtils.makeImports(typeName));
        }
    }

    private void appendMethodArgumentsInSignature(Method method, Set<String> importNamesOut, StringBuilder buf, ArgumentNameSource argumentNameSource, String targetInterfaceName) {
        Type[] types = method.getGenericParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            this.appendOneArgument(method, importNamesOut, buf, argumentNameSource, types, i, targetInterfaceName);
        }
    }

    private void appendOneArgument(Method method, Set<String> importNamesOut, StringBuilder buf, ArgumentNameSource argumentNameSource, Type[] types, int i, String targetInterfaceName) {
        String fullTypeName = types[i].getTypeName();
        buf.append(this.extractAndProcessShortTypeName(method, importNamesOut, types, i, fullTypeName, targetInterfaceName)).append(' ').append(argumentNameSource.getArgumentNameFor(method, i));
    }

    private String extractAndProcessShortTypeName(Method method, Set<String> importNamesOut, Type[] types, int i, String fullTypeName, String targetInterfaceName) {
        String shortTypeName = this.adjustTypeNameAndUpdateImportsIfAppropriate(importNamesOut, targetInterfaceName, fullTypeName);
        if (this.isVarargsParameter(method, types, i)) {
            shortTypeName = ClassNameUtils.convertToVarArgs(shortTypeName);
        }
        return shortTypeName;
    }

    private boolean isVarargsParameter(Method method, Type[] types, int i) {
        return i == types.length - 1 && method.isVarArgs();
    }

    private static String extractShortNameAndUpdateImports(Set<String> importNamesOut, String fullTypeName) {
        String shortTypeName = ClassNameUtils.extractSimpleName(fullTypeName);
        if (shortTypeName.length() < fullTypeName.length()) {
            importNamesOut.addAll(ClassNameUtils.makeImports(fullTypeName));
        }
        return shortTypeName;
    }

    public String makeDelegateCall(Method method, String targetInterfaceName, Set<String> importsOut, ArgumentNameSource argumentNameSource) {
        StringBuilder buf = new StringBuilder();
        this.appendReturnIfNotVoid(method, buf);
        Class<?> declaringClass = method.getDeclaringClass();
        String delegateClassName = ClassNameUtils.getDelegateClassNameWithoutPackageIfNoConflict(declaringClass, targetInterfaceName);
        this.addImportIfNeeded(importsOut, declaringClass, delegateClassName);
        this.appendStaticCall(method, argumentNameSource, buf, delegateClassName);
        return buf.toString();
    }

    private void addImportIfNeeded(Set<String> importsOut, Class<?> declaringClass, String delegateClassName) {
        if (this.needToImport(delegateClassName)) {
            importsOut.add(declaringClass.getCanonicalName());
        }
    }

    private void appendStaticCall(Method method, ArgumentNameSource argumentNameSource, StringBuilder buf, String delegateClassName) {
        buf.append(delegateClassName).append(".").append(method.getName()).append("(");
        this.appendArgumentsInDelegateCall(method, argumentNameSource, buf);
        buf.append(");");
    }

    private void appendReturnIfNotVoid(Method method, StringBuilder buf) {
        if (!"void".equals(method.getReturnType().getTypeName())) {
            buf.append("return ");
        }
    }

    private void appendArgumentsInDelegateCall(Method method, ArgumentNameSource argumentNameSource, StringBuilder buf) {
        int parameterCount = method.getParameterCount();
        for (int i = 0; i < parameterCount; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(argumentNameSource.getArgumentNameFor(method, i));
        }
    }

    private boolean needToImport(String delegateClassName) {
        return delegateClassName.indexOf(46) < 0;
    }

    protected List<Field> listConstantsForClass(Class<?> clazz) {
        return this.listConstantsForClass(clazz, fld -> true);
    }

    protected List<Field> listConstantsForClass(Class<?> clazz, Predicate<? super Field> extraFilter) {
        Predicate<Field> isPublicStatic = f -> {
            int modifiers = f.getModifiers();
            return Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers);
        };
        return Arrays.stream(clazz.getFields()).filter(isPublicStatic.and(fld -> extraFilter.test((Field)fld))).sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
    }

    protected void generateConstant(Field field, Class<?> fieldClass, Set<String> imports, StringBuilder buf, String targetInterfaceName, String indentationUnit) {
        String type = CoreMixinGenerator.extractShortNameAndUpdateImports(imports, this.getAdjustedTypeNameFromField(field));
        buf.append(this.lineBreak(0));
        this.appendCommentForConstant(field, fieldClass, buf, indentationUnit);
        this.appendConstantDeclaration(field, fieldClass, buf, targetInterfaceName, indentationUnit, type);
    }

    private void appendConstantDeclaration(Field field, Class<?> fieldClass, StringBuilder buf, String targetInterfaceName, String indentationUnit, String type) {
        buf.append(indentationUnit).append("static final ").append(type).append(' ').append(field.getName()).append(" = ").append(ClassNameUtils.getDelegateClassNameWithoutPackageIfNoConflict(fieldClass, targetInterfaceName)).append('.').append(field.getName()).append(";").append(this.lineBreak(0));
    }

    protected void appendCommentForConstant(Field field, Class<?> fieldClass, StringBuilder buf, String indentationUnit) {
        buf.append(indentationUnit).append("/** ").append("{@link ").append(fieldClass.getTypeName()).append('#').append(field.getName()).append("} */").append(this.lineBreak(0));
    }

    private String getAdjustedTypeNameFromField(Field field) {
        String typeName = field.getType().getTypeName();
        TypeVariable<Class<?>>[] typeParameters = field.getType().getTypeParameters();
        typeName = this.adjustTypeNameForUntypedParameterization(typeName, typeParameters);
        return typeName;
    }

    private String adjustTypeNameForUntypedParameterization(String typeName, TypeVariable<?>[] typeParameters) {
        if (null != typeParameters && typeParameters.length > 0 && typeName.indexOf(60) < 0) {
            typeName = typeName + Arrays.asList(typeParameters).stream().map(t -> "Object").collect(Collectors.joining(", ", "<", ">"));
        }
        return typeName;
    }

    protected String generateConstantsForClassUpdatingImports(Class<?> delegateClass, Set<String> importsUpdated, String targetInterfaceName) {
        return this.generateConstantsForClassUpdatingImports(delegateClass, importsUpdated, targetInterfaceName, fld -> true);
    }

    protected String generateConstantsForClassUpdatingImports(Class<?> delegateClass, Set<String> importsUpdated, String targetInterfaceName, Predicate<? super Field> extraFilter) {
        String indentationUnit = this.formatter.getIndentationUnit();
        StringBuilder buf = new StringBuilder();
        this.listConstantsForClass(delegateClass, extraFilter).stream().forEach(field -> this.generateConstant((Field)field, delegateClass, importsUpdated, buf, targetInterfaceName, indentationUnit));
        importsUpdated.addAll(ClassNameUtils.makeImports(delegateClass.getTypeName()));
        return buf.toString();
    }

    public String generateDelegateClassCode(String targetPackageName, String targetInterfaceName, Class<?> delegateClass, ArgumentNameSource argumentNameSource) {
        return this.generateDelegateClassCode(targetPackageName, targetInterfaceName, delegateClass, argumentNameSource, new SimpleSingleFileOutputOptions(targetInterfaceName, targetPackageName, null));
    }

    public String generateDelegateClassCode(String targetPackageName, String targetInterfaceName, Class<?> delegateClass, ArgumentNameSource argumentNameSource, MultiFileOutputOptions options) {
        HashSet<String> imports = new HashSet<String>();
        StringBuilder result = new StringBuilder();
        String constants = this.generateConstantsForClassUpdatingImports(delegateClass, imports, targetInterfaceName, options.getConstantsFilterForDelegate(delegateClass));
        String methods = this.generateMethodsForClassUpdatingImports(delegateClass, imports, argumentNameSource, options);
        this.appendPackage(targetPackageName, result);
        this.appendSortedImports(result, imports, targetInterfaceName);
        this.appendInterfaceBody(targetInterfaceName, delegateClass, result, constants, methods, options.getSuperTypes(delegateClass));
        return result.toString();
    }

    public String generateDelegateClassCode(Class<?> delegateClass, ArgumentNameSource argumentNameSource, MultiFileOutputOptions options) {
        String targetInterfaceName = options.getTargetInterfaceNameForDelegate(delegateClass);
        HashSet<String> imports = new HashSet<String>();
        StringBuilder result = new StringBuilder();
        String constants = this.generateConstantsForClassUpdatingImports(delegateClass, imports, targetInterfaceName, options.getConstantsFilterForDelegate(delegateClass));
        String methods = this.generateMethodsForClassUpdatingImports(delegateClass, imports, argumentNameSource, options);
        this.appendPackage(options.getTargetPackageNameForDelegate(delegateClass), result);
        this.appendSortedImports(result, imports, targetInterfaceName);
        this.appendInterfaceBody(targetInterfaceName, delegateClass, result, constants, methods, options.getSuperTypes(delegateClass));
        return result.toString();
    }

    private void appendInterfaceBody(String targetInterfaceName, Class<?> delegateClass, StringBuilder buf, String constants, String methods, Set<String> superTypes) {
        this.formatter.appendClassComment(delegateClass, buf);
        this.appendInterfaceDeclaration(targetInterfaceName, buf, superTypes);
        buf.append(" {");
        for (int i = 0; i < 3; ++i) {
            buf.append(this.lineBreak(0));
        }
        this.formatter.appendCommentBeforeConstants(buf).append(constants).append(this.lineBreak(0)).append(this.lineBreak(0));
        this.formatter.appendCommentBeforeMethods(buf).append(methods).append(this.lineBreak(0)).append("}");
    }

    private void appendInterfaceDeclaration(String targetInterfaceName, StringBuilder buf, Set<String> superTypes) {
        buf.append("public interface ").append(targetInterfaceName);
        this.appendAnySupertypeDeclarations(buf, superTypes);
    }

    private void appendAnySupertypeDeclarations(StringBuilder buf, Set<String> superTypes) {
        if (null != superTypes && superTypes.size() > 0) {
            buf.append(" extends ").append(this.makeCommaDelimitedSuperTypeList(superTypes));
        }
    }

    private String makeCommaDelimitedSuperTypeList(Set<String> superTypes) {
        StringJoiner joiner = new StringJoiner(", ");
        superTypes.stream().sorted().forEachOrdered(str -> joiner.add((CharSequence)str));
        String superTypeList = joiner.toString();
        return superTypeList;
    }

    private void appendPackage(String targetPackageName, StringBuilder buf) {
        if (null != targetPackageName && !targetPackageName.isEmpty()) {
            buf.append("package ").append(targetPackageName).append(";").append(this.lineBreak(0)).append(this.lineBreak(0));
        }
    }

    private void appendSortedImports(StringBuilder buf, Set<String> importsUpdated, String targetInterfaceName) {
        Object[] sortedImports = importsUpdated.toArray(new String[importsUpdated.size()]);
        Arrays.sort(sortedImports);
        for (Object cur : sortedImports) {
            if (!this.hasNoConflict(targetInterfaceName, (String)cur) || !this.doesNotCreatePMDWarning((String)cur)) continue;
            buf.append("import ").append((String)cur).append("; ").append(this.lineBreak(0));
        }
    }

    private boolean doesNotCreatePMDWarning(String cur) {
        return !cur.startsWith("java.lang.");
    }

    private boolean hasNoConflict(String targetInterfaceName, String cur) {
        return !cur.endsWith("." + targetInterfaceName);
    }

    protected String generateMethodsForClassUpdatingImports(Class<?> delegateClass, Set<String> importsUpdated, ArgumentNameSource argumentNameSource, MultiFileOutputOptions options) {
        return this.generateMethodsForClassUpdatingImports(delegateClass, importsUpdated, options.getTargetInterfaceNameForDelegate(delegateClass), argumentNameSource, options.getMethodFilterForDelegate(delegateClass));
    }

    protected String generateMethodsForClassUpdatingImports(Class<?> delegateClass, Set<String> importsUpdated, String targetInterfaceName, ArgumentNameSource argumentNameSource) {
        return this.generateMethodsForClassUpdatingImports(delegateClass, importsUpdated, targetInterfaceName, argumentNameSource, m -> true);
    }

    protected String generateMethodsForClassUpdatingImports(Class<?> delegateClass, Set<String> importsUpdated, String targetInterfaceName, ArgumentNameSource argumentNameSource, Predicate<? super Method> extraMethodFilter) {
        StringBuilder buf = new StringBuilder();
        Predicate<Object> methodFilter = this.STATIC_METHODS_ONLY.and(m -> this.deprecationPolicyDoesNotForbid((Method)m)).and(m2 -> extraMethodFilter.test((Method)m2));
        for (Method cur : this.listFilteredSortedMethodsForClass(delegateClass, methodFilter)) {
            buf.append(this.lineBreak(0)).append(this.makeDelegateMethod(targetInterfaceName, cur, importsUpdated, argumentNameSource)).append(this.lineBreak(0)).append(this.lineBreak(0));
        }
        return buf.toString();
    }

    protected boolean deprecationPolicyDoesNotForbid(Method method) {
        return !this.isDeprecated(method) || this.deprecationPolicy != DeprecationPolicy.IGNORE_DEPRECATED_METHODS;
    }

    @Override
    public File generateMixinJavaFile(File saveDirectory, String targetInterfaceName, Class<?> delegateClass, String targetPackageName, ArgumentNameSource argumentNameSource) throws IOException {
        return this.writeClassFile(saveDirectory, this.generateDelegateClassCode(targetPackageName, targetInterfaceName, delegateClass, argumentNameSource), this.interfaceNameToFileName(targetInterfaceName));
    }

    @Override
    public List<File> generateMixinJavaFiles(MultiFileOutputOptions options, ArgumentNameSource argumentNameSource, Class<?> ... delegateClasses) throws IOException {
        ArrayList<File> results = new ArrayList<File>();
        for (Class<?> delegate : delegateClasses) {
            String targetInterfaceName = options.getTargetInterfaceNameForDelegate(delegate);
            File current = this.writeClassFile(options.getMixinSaveDirectoryForDelegate(delegate), this.generateDelegateClassCode(options.getTargetPackageNameForDelegate(delegate), targetInterfaceName, delegate, argumentNameSource, options), this.interfaceNameToFileName(targetInterfaceName));
            results.add(current);
        }
        return results;
    }

    private String interfaceNameToFileName(String targetInterfaceName) {
        return targetInterfaceName + ".java";
    }

    private File writeClassFile(File dir, String content, String fileName) throws IOException, UnableToCreateOutputDirectory {
        this.fileSystem.makeOutputDirectoryIfAbsent(dir);
        return this.fileSystem.writeFile(dir, fileName, content);
    }
}

