/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.interface_it.api;

import com.github.aro_tech.interface_it.api.CoreMixinGenerator;
import com.github.aro_tech.interface_it.api.MixinCodeGenerator;
import com.github.aro_tech.interface_it.api.MultiFileOutputOptions;
import com.github.aro_tech.interface_it.api.StatisticsProvider;
import com.github.aro_tech.interface_it.format.CodeFormatter;
import com.github.aro_tech.interface_it.meta.arguments.ArgumentNameSource;
import com.github.aro_tech.interface_it.policy.DeprecationPolicy;
import com.github.aro_tech.interface_it.statistics.GenerationStatistics;
import com.github.aro_tech.interface_it.util.FileSystem;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class StatisticProvidingMixinGenerator
extends CoreMixinGenerator
implements MixinCodeGenerator,
StatisticsProvider {
    private GenerationStatistics globalStatistics = new GenerationStatistics();
    private String currentTag = null;
    private Map<String, GenerationStatistics> tagMap = new HashMap<String, GenerationStatistics>();

    public StatisticProvidingMixinGenerator() {
    }

    @Override
    public String generateDelegateClassCode(Class<?> delegateClass, ArgumentNameSource argumentNameSource, MultiFileOutputOptions options) {
        this.setCurrentTag(this.interfaceNameToTag(options.getTargetInterfaceNameForDelegate(delegateClass)));
        return super.generateDelegateClassCode(delegateClass, argumentNameSource, options);
    }

    @Override
    public String generateDelegateClassCode(String targetPackageName, String targetInterfaceName, Class<?> delegateClass, ArgumentNameSource argumentNameSource) {
        this.setCurrentTag(this.interfaceNameToTag(targetInterfaceName));
        return super.generateDelegateClassCode(targetPackageName, targetInterfaceName, delegateClass, argumentNameSource);
    }

    private String interfaceNameToTag(String targetInterfaceName) {
        return targetInterfaceName + ".java";
    }

    @Override
    public String generateDelegateClassCode(String targetPackageName, String targetInterfaceName, Class<?> delegateClass, ArgumentNameSource argumentNameSource, MultiFileOutputOptions options) {
        this.setCurrentTag(this.interfaceNameToTag(options.getTargetInterfaceNameForDelegate(delegateClass)));
        return super.generateDelegateClassCode(targetPackageName, targetInterfaceName, delegateClass, argumentNameSource, options);
    }

    public StatisticProvidingMixinGenerator(FileSystem fileSystem, DeprecationPolicy deprecationPolicy, CodeFormatter formatter) {
        super(fileSystem, deprecationPolicy, formatter);
    }

    @Override
    public GenerationStatistics getStatistics() {
        return this.globalStatistics;
    }

    @Override
    public String makeDelegateMethod(String targetInterfaceName, Method method, Set<String> importsOut, ArgumentNameSource argumentNameSource) {
        this.incrementMethodCount();
        if (this.isDeprecated(method)) {
            this.incrementDeprecationCount();
        }
        return super.makeDelegateMethod(targetInterfaceName, method, importsOut, argumentNameSource);
    }

    private void incrementDeprecationCount() {
        this.globalStatistics.incrementDeprecationCount();
        if (this.getCurrentStats().isPresent()) {
            this.getCurrentStats().get().incrementDeprecationCount();
        }
    }

    private void incrementMethodCount() {
        this.globalStatistics.incrementMethodCount();
        if (this.getCurrentStats().isPresent()) {
            this.getCurrentStats().get().incrementMethodCount();
        }
    }

    private void incrementConstantCount() {
        this.globalStatistics.incrementConstantCount();
        if (this.getCurrentStats().isPresent()) {
            this.getCurrentStats().get().incrementConstantCount();
        }
    }

    private Optional<GenerationStatistics> getCurrentStats() {
        return Optional.ofNullable(this.tagMap.get("" + this.currentTag));
    }

    @Override
    protected boolean deprecationPolicyDoesNotForbid(Method method) {
        boolean notBlocked = super.deprecationPolicyDoesNotForbid(method);
        this.incrementSkippedCountIfBlocked(notBlocked);
        return notBlocked;
    }

    private void incrementSkippedCountIfBlocked(boolean notBlocked) {
        if (!notBlocked) {
            this.globalStatistics.incrementSkippedCount();
        }
    }

    @Override
    protected void generateConstant(Field field, Class<?> fieldClass, Set<String> imports, StringBuilder buf, String targetInterfaceName, String indentationUnit) {
        this.incrementConstantCount();
        super.generateConstant(field, fieldClass, imports, buf, targetInterfaceName, indentationUnit);
    }

    @Override
    public void resetStatistics() {
        this.globalStatistics = new GenerationStatistics();
        this.tagMap = new HashMap<String, GenerationStatistics>();
    }

    @Override
    public Optional<GenerationStatistics> getStatisticsFor(String tag) {
        return Optional.ofNullable(this.tagMap.get(tag));
    }

    @Override
    public void setCurrentTag(String tag) {
        this.currentTag = tag;
        this.tagMap.put(tag, new GenerationStatistics());
    }
}

