/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.interface_it.api.options;

import com.github.aro_tech.interface_it.api.MultiFileOutputOptions;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class OptionsForSplittingChildAndParent
implements MultiFileOutputOptions {
    private final String targetPackage;
    private final File saveDirectory;
    private final String childMixinName;
    private final String parentMixinName;
    private final Class<?> childClass;

    public OptionsForSplittingChildAndParent(String targetPackage, File saveDirectory, String childMixinName, String parentMixinName, Class<?> childClass) {
        this.targetPackage = targetPackage;
        this.saveDirectory = saveDirectory;
        this.childMixinName = childMixinName;
        this.parentMixinName = parentMixinName;
        this.childClass = childClass;
    }

    @Override
    public String getTargetPackageNameForDelegate(Class<?> delegateClass) {
        return this.targetPackage;
    }

    @Override
    public File getMixinSaveDirectoryForDelegate(Class<?> delegate) {
        return this.saveDirectory;
    }

    @Override
    public String getTargetInterfaceNameForDelegate(Class<?> delegateClass) {
        return delegateClass.equals(this.childClass) ? this.childMixinName : this.parentMixinName;
    }

    @Override
    public Predicate<? super Method> getMethodFilterForDelegate(Class<?> delegate) {
        if (this.childClass.equals(delegate)) {
            return m -> m.getDeclaringClass().equals(delegate);
        }
        return m -> true;
    }

    @Override
    public Set<String> getSuperTypes(Class<?> delegateClass) {
        if (delegateClass.equals(this.childClass)) {
            return new HashSet<String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.add(OptionsForSplittingChildAndParent.this.parentMixinName);
                }
            };
        }
        return Collections.emptySet();
    }

    public String toString() {
        return "OptionsForSplittingChildAndParent [targetPackage=" + this.targetPackage + ", saveDirectory=" + this.saveDirectory + ", childMixinName=" + this.childMixinName + ", parentMixinName=" + this.parentMixinName + ", childClass=" + this.childClass + ", getMethodFilter(" + this.childClass + ")=" + this.getMethodFilterForDelegate(this.childClass) + "]";
    }

    @Override
    public Predicate<? super Field> getConstantsFilterForDelegate(Class<?> delegateClass) {
        if (this.childClass.equals(delegateClass)) {
            return fld -> fld.getDeclaringClass().equals(delegateClass);
        }
        return m -> true;
    }
}

