/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.interface_it.format;

public class CodeFormatter {
    public static final int DEFAULT_INDENTATION_SPACES = 4;
    private static final String NEWLINE = System.lineSeparator();
    private int indentationSpaces;
    private final String indentationUnit;

    public CodeFormatter(int indentationSpaces) {
        this.indentationSpaces = indentationSpaces;
        this.indentationUnit = this.makeIndentationUnit();
    }

    public static CodeFormatter getDefault() {
        return new CodeFormatter(4);
    }

    public StringBuilder appendCommentBeforeMethods(StringBuilder buf) {
        return buf.append(this.indentationUnit).append("// DELEGATE METHODS: ").append(NEWLINE);
    }

    public StringBuilder appendCommentBeforeConstants(StringBuilder buf) {
        return buf.append(this.indentationUnit).append("// CONSTANTS: ").append(NEWLINE);
    }

    public StringBuilder appendClassComment(Class<?> delegateClass, StringBuilder buf) {
        return buf.append(NEWLINE).append("/** ").append(NEWLINE).append(" * Wrapper of static elements in ").append(delegateClass.getTypeName()).append(NEWLINE).append(" * Generated by Interface-It: https://github.com/aro-tech/interface-it").append(NEWLINE).append(" * {@link ").append(delegateClass.getTypeName()).append("}").append(NEWLINE).append(" */").append(NEWLINE);
    }

    public String getIndentationUnit() {
        return this.indentationUnit;
    }

    private String makeIndentationUnit() {
        StringBuilder indentation = new StringBuilder();
        for (int i = 0; i < this.indentationSpaces; ++i) {
            indentation.append(' ');
        }
        String indentationUnit = indentation.toString();
        return indentationUnit;
    }

    public StringBuilder appendMethodComment(StringBuilder buf, String methodName, String genericStringForMethod, String declaringClassTypeName, String paramsForJavadocLink) {
        return buf.append(this.indentationUnit).append("/**").append(NEWLINE).append(this.indentationUnit).append(" * Delegate call to ").append(genericStringForMethod).append(NEWLINE).append(this.indentationUnit).append(" * ").append("{@link ").append(declaringClassTypeName).append('#').append(methodName).append("(").append(paramsForJavadocLink).append(")}").append(NEWLINE).append(this.indentationUnit).append(" */");
    }

    public String newlineWithIndentations(int indentations) {
        StringBuilder buf = new StringBuilder();
        buf.append(NEWLINE);
        for (int i = 0; i < indentations; ++i) {
            buf.append(this.indentationUnit);
        }
        return buf.toString();
    }
}

