/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.interface_it.meta.arguments;

import com.github.aro_tech.interface_it.meta.arguments.LookupArgumentNameSource;
import com.github.aro_tech.interface_it.util.ClassNameUtils;
import java.util.ArrayList;
import java.util.List;

public class SourceLineReadingArgumentNameLoader {
    public void parseAndLoad(List<String> sourceLines, LookupArgumentNameSource target) {
        StringBuilder combinedLines = null;
        CommentStatus status = new CommentStatus();
        for (String line : sourceLines) {
            if (this.isStaticMethodSignatureEnd(line = this.adjustLineForComments(status, line))) {
                if (this.isStaticMethodSignatureStart(line)) {
                    this.parseAndLoadSignatureLine(target, line);
                    continue;
                }
                if (null == combinedLines) continue;
                combinedLines.append(" ").append(line);
                this.parseAndLoadSignatureLine(target, combinedLines.toString());
                combinedLines = null;
                continue;
            }
            if (this.isStaticMethodSignatureStart(line)) {
                combinedLines = new StringBuilder();
                combinedLines.append(line);
                continue;
            }
            if (null == combinedLines) continue;
            combinedLines.append(" ").append(line);
        }
    }

    private String adjustLineForComments(CommentStatus status, String line) {
        if (line.contains("/*")) {
            return this.adjustLineContainingCommentStart(status, line);
        }
        if (line.contains("*/") && status.inComment) {
            return this.adjustLineContainingCommentEnd(status, line);
        }
        if (line.contains("//")) {
            int ix = line.indexOf("//");
            return line.substring(0, ix);
        }
        if (status.inComment) {
            return "";
        }
        return line;
    }

    private String adjustLineContainingCommentEnd(CommentStatus status, String line) {
        int endIx = line.indexOf("*/");
        status.inComment = false;
        return line.substring(endIx + 1);
    }

    private String adjustLineContainingCommentStart(CommentStatus status, String line) {
        String lineOut = line;
        int startIx = line.indexOf("/*");
        int endIx = line.indexOf("*/");
        if (endIx < 0) {
            status.inComment = true;
            lineOut = this.wordContainsMethodName(startIx) ? lineOut.substring(0, startIx) : "";
        } else if (endIx < startIx) {
            lineOut = lineOut.substring(endIx + 2, startIx);
        } else {
            String lineStart = lineOut.substring(0, startIx);
            String lineEnd = lineOut.substring(endIx + 1);
            lineOut = lineStart + lineEnd;
        }
        return lineOut;
    }

    private List<Token> extractTokens(String[] words) {
        ArrayList<Token> result = new ArrayList<Token>();
        LoopContext ctx = new LoopContext(result);
        for (int i = 0; i < words.length && ctx.isNotDone(); ++i) {
            String word = words[i].trim();
            if (word.length() <= 0 || "final".equals(word)) continue;
            this.processCurrentNonemptyWord(word, words, ctx, i);
        }
        return result;
    }

    private void processCurrentNonemptyWord(String word, String[] words, LoopContext ctx, int loopCounter) {
        if (ctx.isInsideArgs()) {
            this.processWordInsideArguments(word, ctx);
        } else {
            this.processWordAtOrBeforeStartOfArguments(word, words, ctx, loopCounter);
        }
    }

    private void processWordInsideArguments(String word, LoopContext ctx) {
        if (word.indexOf(41) > 0) {
            if (ctx.getCurrentType() != null) {
                ctx.addOneArgument(word.substring(0, word.indexOf(41)));
            }
            ctx.endLoop();
        } else if (word.indexOf(41) == 0) {
            ctx.endLoop();
        } else if (word.indexOf(44) == 0) {
            if (word.length() > 1) {
                ctx.setCurrentType(word.substring(1));
            }
        } else if (this.isBoundaryBetween2Args(word)) {
            this.splitAndProcessArgBoundaryWord(word, ctx);
        } else {
            this.processTypeOrNameWord(word, ctx);
        }
    }

    private void splitAndProcessArgBoundaryWord(String word, LoopContext ctx) {
        String[] parts = word.split(",");
        if (parts.length > 0) {
            ctx.addOneArgument(parts[0]);
            ctx.setCurrentType(parts.length > 1 && !"final".equals(parts[1]) ? parts[1] : null);
        }
    }

    private boolean isBoundaryBetween2Args(String word) {
        return word.indexOf(44) > 0;
    }

    private void processTypeOrNameWord(String word, LoopContext ctx) {
        if (ctx.hasNoCurrentType()) {
            ctx.setCurrentType(word);
        } else if (word.equals("...")) {
            ctx.appendToCurrentType(word);
        } else if (ctx.isInTemplateType()) {
            ctx.appendToCurrentType(' ' + word);
        } else {
            ctx.addOneArgument(word);
            ctx.reset();
        }
    }

    private void processWordAtOrBeforeStartOfArguments(String word, String[] words, LoopContext ctx, int loopCounter) {
        int indexOfOpen = word.indexOf(40);
        if (this.wordContainsMethodName(indexOfOpen)) {
            this.atStartOfArgsExtractMethodNameAndPossiblyFirstArgType(word, ctx);
        } else if (this.wordContainsParenOpeningArgumentsButNotMethodName(indexOfOpen)) {
            this.atStartOfArgsSetPreviousWordAsMethodNameAndPossiblyExtractFirstArgType(word, words, ctx, loopCounter);
        }
    }

    private void atStartOfArgsSetPreviousWordAsMethodNameAndPossiblyExtractFirstArgType(String word, String[] words, LoopContext ctx, int loopCounter) {
        ctx.setInsideArgs(true);
        ctx.addMethodName(words[loopCounter - 1].trim());
        if (word.length() > 1) {
            ctx.setCurrentType(word.substring(1));
        }
    }

    private void atStartOfArgsExtractMethodNameAndPossiblyFirstArgType(String word, LoopContext ctx) {
        ctx.setInsideArgs(true);
        String[] parts = word.split("\\(");
        ctx.addMethodName(parts[0]);
        if (parts.length > 1 && this.isNotEndOfArgs(parts) && !"final".equals(parts[1])) {
            ctx.setCurrentType(parts[1]);
        }
    }

    private boolean isNotEndOfArgs(String[] parts) {
        return !parts[1].startsWith(")");
    }

    private boolean wordContainsParenOpeningArgumentsButNotMethodName(int indexOfOpen) {
        return indexOfOpen == 0;
    }

    private boolean wordContainsMethodName(int indexOfOpen) {
        return indexOfOpen > 0;
    }

    private void parseAndLoadSignatureLine(LookupArgumentNameSource target, String line) {
        String[] words = line.split(" ");
        String method = "";
        String argType = "";
        List<Token> tokens = this.extractTokens(words);
        int index = 0;
        for (Token tok : tokens) {
            switch (tok.getType()) {
                case METHOD_NAME: {
                    method = tok.getValue();
                    break;
                }
                case ARGUMENT_TYPE: {
                    argType = tok.getValue();
                    break;
                }
                case ARGUMENT_NAME: {
                    target.add(method, index++, this.simplify(argType), tok.getValue(), this.countArguments(tokens));
                }
            }
        }
    }

    private int countArguments(List<Token> tokens) {
        int count = 0;
        for (Token token : tokens) {
            if (token.getType() != TokenType.ARGUMENT_NAME) continue;
            ++count;
        }
        return count;
    }

    private boolean isStaticMethodSignatureStart(String line) {
        int openParenIx = line.indexOf(40);
        int staticIx = line.indexOf("static");
        int eqIx = line.indexOf(61);
        return staticIx >= 0 && openParenIx >= staticIx && eqIx < 0;
    }

    private boolean isStaticMethodSignatureEnd(String line) {
        return line.indexOf(123) >= 0;
    }

    private String simplify(String fullName) {
        return ClassNameUtils.extractSimpleName(fullName);
    }

    private static class LoopContext {
        private String currentType = null;
        private boolean insideArgs = false;
        private boolean isDone = false;
        private final List<Token> result;

        public LoopContext(List<Token> result) {
            this.result = result;
        }

        void addOneArgument(String word) {
            this.result.add(new Token(TokenType.ARGUMENT_TYPE, this.currentType));
            this.result.add(new Token(TokenType.ARGUMENT_NAME, word));
        }

        void addMethodName(String name) {
            this.result.add(new Token(TokenType.METHOD_NAME, name));
        }

        String getCurrentType() {
            return this.currentType;
        }

        void setCurrentType(String currentType) {
            this.currentType = currentType;
        }

        boolean isInsideArgs() {
            return this.insideArgs;
        }

        void setInsideArgs(boolean insideArgs) {
            this.insideArgs = insideArgs;
        }

        boolean isInTemplateType() {
            return null != this.currentType && this.currentType.indexOf(60) >= 0 && !this.currentType.endsWith(">");
        }

        public boolean hasNoCurrentType() {
            return null == this.currentType;
        }

        public void appendToCurrentType(String suffix) {
            this.currentType = this.currentType + suffix;
        }

        public String toString() {
            return "LoopContext [currentType=" + this.currentType + ", insideArgs=" + this.insideArgs + ", isDone=" + this.isDone + ", isInTemplateType()=" + this.isInTemplateType() + ", hasNoCurrentType()=" + this.hasNoCurrentType() + "]";
        }

        boolean isNotDone() {
            return !this.isDone;
        }

        void endLoop() {
            this.isDone = true;
        }

        public void reset() {
            this.currentType = null;
            this.insideArgs = false;
        }
    }

    private static class Token {
        private final TokenType type;
        private final String value;

        Token(TokenType type, String value) {
            this.type = type;
            this.value = value;
        }

        TokenType getType() {
            return this.type;
        }

        String getValue() {
            return this.value;
        }

        public String toString() {
            return "Token [type=" + (Object)((Object)this.type) + ", value=" + this.value + "]";
        }
    }

    private static enum TokenType {
        METHOD_NAME,
        ARGUMENT_TYPE,
        ARGUMENT_NAME;

    }

    private static class CommentStatus {
        boolean inComment = false;

        private CommentStatus() {
        }
    }
}

