/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.interface_it.statistics;

public class GenerationStatistics {
    private int constantCount = 0;
    private int methodCount = 0;
    private int deprecationCount = 0;
    private int skippedCount = 0;

    public int getConstantCount() {
        return this.constantCount;
    }

    public int getMethodCount() {
        return this.methodCount;
    }

    public void incrementMethodCount() {
        ++this.methodCount;
    }

    public void incrementConstantCount() {
        ++this.constantCount;
    }

    public int getDeprecationCount() {
        return this.deprecationCount;
    }

    public void incrementDeprecationCount() {
        ++this.deprecationCount;
    }

    public int getSkippedCount() {
        return this.skippedCount;
    }

    public void incrementSkippedCount() {
        ++this.skippedCount;
    }

    public String summarizeStatistics() {
        StringBuilder buf = new StringBuilder();
        buf.append("Generated ").append(this.getConstantCount()).append(" constant").append(this.makePluralText(this.getConstantCount())).append(" and " + this.getMethodCount()).append(" method").append(this.makePluralText(this.getMethodCount())).append(".");
        this.summarizeDeprecationPolicyResults(buf);
        return buf.toString();
    }

    private String makePluralText(int count) {
        if (count == 1) {
            return "";
        }
        return "s";
    }

    private void summarizeDeprecationPolicyResults(StringBuilder buf) {
        this.writeDeprecationCountIfNonZero(buf);
        this.writeSkippedCountIfNonZero(buf);
    }

    private void writeDeprecationCountIfNonZero(StringBuilder buf) {
        if (this.getDeprecationCount() > 0) {
            buf.append(System.lineSeparator());
            if (this.getDeprecationCount() > 1) {
                buf.append(this.getDeprecationCount()).append(" generated methods are deprecated.");
            } else {
                buf.append("1 generated method is deprecated.");
            }
        }
    }

    private void writeSkippedCountIfNonZero(StringBuilder buf) {
        if (this.getSkippedCount() == 1) {
            buf.append(System.lineSeparator());
            buf.append("Skipped 1 static method because of deprecation policy.");
        } else if (this.getSkippedCount() > 1) {
            buf.append(System.lineSeparator());
            buf.append("Skipped ").append(this.getSkippedCount()).append(" static methods because of deprecation policy.");
        }
    }

    public String toString() {
        return "GenerationStatistics [constantCount=" + this.constantCount + ", methodCount=" + this.methodCount + ", deprecationCount=" + this.deprecationCount + ", skippedCount=" + this.skippedCount + "]";
    }
}

