/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.interface_it.ui.commandline;

import com.github.aro_tech.interface_it.policy.DeprecationPolicy;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ArgumentParser {
    private final String[] args;
    private Map<String, String> flagMap = new HashMap<String, String>();
    private Set<Flag> allFlags = EnumSet.noneOf(Flag.class);

    public ArgumentParser(String[] args) {
        this.args = args;
        Flag currentFlag = null;
        for (String currentWord : args) {
            Optional<Flag> current = Flag.fromString(currentWord);
            if (current.isPresent()) {
                currentFlag = current.get();
                if (currentFlag.expectsValue()) continue;
                this.flagMap.put(currentFlag.getFlagText(), currentWord);
                this.allFlags.add(currentFlag);
                currentFlag = null;
                continue;
            }
            if (null == currentFlag) continue;
            this.flagMap.put(currentFlag.getFlagText(), currentWord);
            this.allFlags.add(currentFlag);
            currentFlag = null;
        }
    }

    public String getPackageName() {
        return this.findValueAfterFlag(Flag.TARGET_PACKAGE, "");
    }

    public String getTargetInterfaceName() {
        return this.findValueAfterFlag(Flag.TARGET_INTERFACE_NAME, "GeneratedMixIn");
    }

    private String findValueAfterFlag(Flag flag, String defaultValue) {
        String value = this.flagMap.get(flag.getFlagText());
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public Class<?> getDelegateClass() throws ClassNotFoundException {
        return Class.forName(this.findValueAfterFlag(Flag.DELEGATE_CLASS, "class.not.specified.UnknownClass"));
    }

    public File getWriteDirectoryPath() {
        return new File(this.findValueAfterFlag(Flag.WRITE_DIRECTORY, "."));
    }

    public boolean isVersionRequest() {
        return this.allFlags.size() == 1 && this.allFlags.contains((Object)Flag.VERSION);
    }

    public static String getHelpText() {
        StringBuilder buf = new StringBuilder();
        buf.append("Possible argument flags:").append(System.lineSeparator());
        for (Flag f : Flag.values()) {
            if (!f.includeInHelpMessage()) continue;
            buf.append(f.getFlagText()).append(" > ").append(f.getHelpMessage()).append(System.lineSeparator());
        }
        return buf.toString();
    }

    public boolean isHelpRequest() {
        return this.args.length == 0 || this.args[0].toLowerCase().contains("help");
    }

    public boolean hasInsufficientArguments() {
        return !this.isHelpRequest() && !this.isVersionRequest() && null == this.findValueAfterFlag(Flag.DELEGATE_CLASS, null);
    }

    public Optional<File> getSourceZipOrJarFileObjectOption() {
        return Optional.ofNullable(this.getSourceBundleFileFromArgs(".zip", ".jar"));
    }

    private File getSourceBundleFileFromArgs(String ... expectedExtensions) {
        String path = this.findValueAfterFlag(Flag.SOURCE_PATH, null);
        File file = null;
        if (null != path && (expectedExtensions.length < 1 || this.endsWithOneOf(path, expectedExtensions))) {
            file = new File(path);
        }
        return file;
    }

    private boolean endsWithOneOf(String path, String[] expectedExtensionsLowerCase) {
        String pathLowerCase = path.toLowerCase();
        for (String cur : expectedExtensionsLowerCase) {
            if (!pathLowerCase.endsWith(cur)) continue;
            return true;
        }
        return false;
    }

    public Optional<File> getSourceFileObjectOption() {
        return Optional.ofNullable(this.getSourceBundleFileFromArgs(".java", ".txt"));
    }

    public String getSourceFlagText() {
        return this.findValueAfterFlag(Flag.SOURCE_PATH, "");
    }

    public Map<String, String> getFlagMap() {
        return this.flagMap;
    }

    public DeprecationPolicy getDeprecationPolicy() {
        if (this.allFlags.contains((Object)Flag.IGNORE_DEPRECATED_METHODS)) {
            return DeprecationPolicy.IGNORE_DEPRECATED_METHODS;
        }
        return DeprecationPolicy.PROPAGATE_DEPRECATION;
    }

    public boolean hasMisplacedClassPathFlag() {
        return this.allFlags.contains((Object)Flag.MISPLACED_CLASSPATH_FLAG_SHORT) || this.allFlags.contains((Object)Flag.MISPLACED_CLASSPATH_FLAG_LONG);
    }

    public boolean hasParentMixinName() {
        return this.allFlags.contains((Object)Flag.PARENT_MIXIN_NAME);
    }

    public String getParentMixinName(String defaultValue) {
        return this.findValueAfterFlag(Flag.PARENT_MIXIN_NAME, defaultValue);
    }

    static enum Flag {
        VERSION("v", "Write version number.", false),
        TARGET_INTERFACE_NAME("n", "Name of the target interface (ex: \"MyMixin\")", true),
        WRITE_DIRECTORY("d", "Directory which will contain the generated file (default value is \".\")", true),
        DELEGATE_CLASS("c", "Fully qualified delegate class name (ex: \"java.lang.Math\")", true),
        TARGET_PACKAGE("p", "The package name for the target interface (ex: \"org.example\")", true),
        SOURCE_PATH("s", "File path of either a .jar or .zip file or a single source file ending in .java or .txt containing source code to be used to recover argument names lost during compilation", true),
        IGNORE_DEPRECATED_METHODS("i", "Ignore all deprecated methods. Default behavior is to wrap each deprecated method and deprecate the wrapping method.", false),
        PARENT_MIXIN_NAME("P", "Simple name of the mixin to generate for the superclass of the delegate class. If present, 2 mixins will be generated - one for the delegate class and one for its parent, and the mixin for the delegate will extend the mixin for the delegate's parent class.", true),
        MISPLACED_CLASSPATH_FLAG_SHORT("cp", null, true),
        MISPLACED_CLASSPATH_FLAG_LONG("classpath", null, true);

        private final String flag;
        private final String helpMessage;
        private boolean expectsValue;

        private Flag(String letter, String helpText, boolean expectsVal) {
            this.flag = "-" + letter;
            this.helpMessage = helpText;
            this.expectsValue = expectsVal;
        }

        public String getFlagText() {
            return this.flag;
        }

        public String getHelpMessage() {
            return this.helpMessage;
        }

        public boolean expectsValue() {
            return this.expectsValue;
        }

        public void setExpectsValue(boolean expectsValue) {
            this.expectsValue = expectsValue;
        }

        public boolean includeInHelpMessage() {
            return this.helpMessage != null;
        }

        static Optional<Flag> fromString(String flagText) {
            if (flagText.length() > 1 && flagText.startsWith("-")) {
                for (Flag cur : Flag.values()) {
                    if (!cur.getFlagText().equals(flagText)) continue;
                    return Optional.ofNullable(cur);
                }
            }
            return Optional.empty();
        }
    }
}

