/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.interface_it.util;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ClassNameUtils {
    public static Set<String> makeImports(String fullName) {
        TreeSet<String> result = new TreeSet<String>();
        String[] splitForParameterizedType = fullName.split("<");
        if (splitForParameterizedType[0].lastIndexOf(46) >= 0) {
            String extracted = splitForParameterizedType[0].trim();
            ClassNameUtils.cleanUpAndAddImport(result, extracted);
        }
        for (int i = 1; i < splitForParameterizedType.length; ++i) {
            String[] commaSeparated;
            int lastDotIx = splitForParameterizedType[i].lastIndexOf(46);
            if (lastDotIx < 0) continue;
            for (String cs : commaSeparated = splitForParameterizedType[i].split(",")) {
                String[] spaceSplit = cs.split(" ");
                ClassNameUtils.addOneImportIfPossible(result, spaceSplit);
            }
        }
        return result;
    }

    private static void cleanUpAndAddImport(Set<String> imports, String extracted) {
        char[] chars;
        StringBuilder buf = new StringBuilder();
        for (char c : chars = extracted.toCharArray()) {
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '.') {
                buf.append(c);
                continue;
            }
            if (c != '$') continue;
            imports.add(buf.toString());
            return;
        }
        if (buf.length() > 0) {
            imports.add(buf.toString());
        }
    }

    private static void addOneImportIfPossible(Set<String> result, String[] spaceSplit) {
        for (String cur : spaceSplit) {
            if (!ClassNameUtils.containsPackageInfo(cur)) continue;
            ClassNameUtils.cleanUpAndAddImport(result, cur);
        }
    }

    private static boolean containsPackageInfo(String cur) {
        return cur.lastIndexOf(46) >= 0;
    }

    public static String extractSimpleName(String fullName) {
        if (fullName.endsWith("...")) {
            return ClassNameUtils.doNameExtraction(fullName.substring(0, fullName.length() - 3)) + "...";
        }
        return ClassNameUtils.doNameExtraction(fullName).replace('$', '.');
    }

    private static String doNameExtraction(String fullName) {
        int ltIndex = fullName.indexOf(60);
        if (ltIndex < 0) {
            int lastDotIx = fullName.lastIndexOf(46);
            if (lastDotIx >= 0) {
                return fullName.substring(lastDotIx + 1);
            }
            return fullName;
        }
        return Arrays.stream(fullName.split("<")).map(s -> ClassNameUtils.extractSimpleNamesInGenerics(s)).collect(Collectors.joining("<"));
    }

    private static String extractSimpleNamesInGenerics(String genericsContentWithClosingCaret) {
        return Arrays.stream(genericsContentWithClosingCaret.split(" ")).map(s -> ClassNameUtils.extractSimpleName(s)).collect(Collectors.joining(" "));
    }

    public static String convertToVarArgs(String shortTypeName) {
        int braceIndex = shortTypeName.indexOf(91);
        if (braceIndex > 0) {
            return shortTypeName.substring(0, braceIndex) + "...";
        }
        return shortTypeName;
    }

    public static String getDelegateClassNameWithoutPackageIfNoConflict(Class<?> declaringClass, String targetInterfaceName) {
        String delegateClassName = declaringClass.getSimpleName();
        if (delegateClassName.equals(targetInterfaceName)) {
            delegateClassName = declaringClass.getCanonicalName();
        }
        return delegateClassName;
    }

    public static String getNormalizedArgTypeForLookupKey(Method method, int zeroBasedArgumentIndex) {
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (genericParameterTypes.length <= zeroBasedArgumentIndex) {
            return null;
        }
        return ClassNameUtils.getTypeNameForLookupKey(method, zeroBasedArgumentIndex, genericParameterTypes);
    }

    private static String getTypeNameForLookupKey(Method method, int argIndex, Type[] genericParameterTypes) {
        String rawTypeName = genericParameterTypes[argIndex].getTypeName();
        return ClassNameUtils.convertToVarArgsIfNeeded(ClassNameUtils.removeParentClass(ClassNameUtils.removePackageInfo(rawTypeName)), method, argIndex);
    }

    private static String removeParentClass(String typeName) {
        int lastDotIx = typeName.lastIndexOf(46);
        if (lastDotIx >= 0) {
            typeName = typeName.substring(lastDotIx + 1);
        }
        return typeName;
    }

    private static String convertToVarArgsIfNeeded(String typeName, Method method, int zeroBasedArgumentIndex) {
        if (method.isVarArgs() && method.getParameterCount() == zeroBasedArgumentIndex + 1) {
            typeName = ClassNameUtils.replaceEndingSquareBraces(typeName);
        }
        return typeName;
    }

    private static String removePackageInfo(String typeName) {
        int lastDotIx = typeName.lastIndexOf(46);
        if (lastDotIx >= 0) {
            typeName = ClassNameUtils.extractSimpleName(typeName);
        }
        return typeName;
    }

    private static String replaceEndingSquareBraces(String typeName) {
        return typeName.replace("[]", "...");
    }
}

