/*
 * Decompiled with CFR 0.152.
 */
package com.github.aro_tech.interface_it.util;

import com.github.aro_tech.interface_it.ui.meta.error.UnableToCreateOutputDirectory;
import com.github.aro_tech.interface_it.util.FileSystem;
import com.github.aro_tech.interface_it.util.SourceFileReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtils
implements SourceFileReader,
FileSystem {
    public static FileSystem getDefaultFileSystem() {
        return new FileUtils();
    }

    public static SourceFileReader getDefaultSourceFileReader() {
        return new FileUtils();
    }

    protected FileUtils() {
    }

    @Override
    public List<String> readFilesInZipArchive(File zipFile, String ... filePathsWithinZipStructure) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (ZipFile zf = new ZipFile(zipFile);){
            for (String filePathWithinZipStructure : filePathsWithinZipStructure) {
                this.readFileLinesIntoList(filePathWithinZipStructure, lines, zf);
            }
        }
        return lines;
    }

    @Override
    public List<String> readTrimmedLinesFromFilePath(Path path) {
        try {
            return Files.lines(path).filter(s -> s.trim().length() > 0).map(s -> s.trim()).collect(Collectors.toList());
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    private void readFileLinesIntoList(String filePathWithinZipStructure, List<String> lines, ZipFile zf) throws IOException {
        ZipEntry entry = zf.getEntry(filePathWithinZipStructure);
        if (null != entry) {
            this.readEntryLinesIntoList(lines, zf, entry);
        }
    }

    private void readEntryLinesIntoList(List<String> lines, ZipFile zf, ZipEntry entry) throws IOException {
        long size = entry.getSize();
        if (size > 0L) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(zf.getInputStream(entry)));){
                String line;
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
            }
        }
    }

    @Override
    public File writeFile(File dir, String fileName, String content) throws IOException {
        File fileToWrite = new File(dir, fileName);
        try (BufferedWriter w = new BufferedWriter(new FileWriter(fileToWrite));){
            w.write(content);
        }
        return fileToWrite;
    }

    @Override
    public void makeOutputDirectoryIfAbsent(File dir) throws UnableToCreateOutputDirectory {
        if (!dir.exists()) {
            this.makeAbsentDirectory(dir);
        }
    }

    private void makeAbsentDirectory(File dir) throws UnableToCreateOutputDirectory {
        if (!dir.mkdirs()) {
            throw new UnableToCreateOutputDirectory(dir);
        }
    }
}

