/**
 * 
 */
package com.github.aro_tech.interface_it.format;

/**
 * @author aro_tech
 *
 */
public class CodeFormatter {
	/**
	 * Default number of spaces in an indentation unit for the generated Java
	 * code
	 */
	public static final int DEFAULT_INDENTATION_SPACES = 4;
	
	private static final String NEWLINE = System.lineSeparator();
	
	private int indentationSpaces;
	private final String indentationUnit;
	
	
	/**
	 * 
	 * Constructor
	 * @param indentationSpaces
	 */
	public CodeFormatter(final int indentationSpaces) {
		this.indentationSpaces = indentationSpaces;
		this.indentationUnit = makeIndentationUnit();
	}
	
	public static CodeFormatter getDefault() {
		return new CodeFormatter(DEFAULT_INDENTATION_SPACES);
	}
	
	/**
	 * Append a comment to start the zone of methods
	 * 
	 * @param buf
	 *            target for append
	 * @return buf
	 */
	public StringBuilder appendCommentBeforeMethods(StringBuilder buf) {
		return buf.append(indentationUnit).append("// DELEGATE METHODS: ").append(NEWLINE);
	}

	/**
	 * Append a comment to start the zone of constants
	 * 
	 * @param buf
	 *            target for append
	 * @return buf
	 */
	public StringBuilder appendCommentBeforeConstants(StringBuilder buf) {
		return buf.append(indentationUnit).append("// CONSTANTS: ").append(NEWLINE);
	}

	/**
	 * Append a javadoc comment for the class
	 * 
	 * @param delegateClass
	 * @param buf
	 *            target for append
	 * @return buf
	 */
	public StringBuilder appendClassComment(Class<?> delegateClass, StringBuilder buf) {
		return buf.append(NEWLINE).append("/** ").append(NEWLINE).append(" * Wrapper of static elements in ")
				.append(delegateClass.getTypeName()).append(NEWLINE)
				.append(" * Generated by Interface-It: https://github.com/aro-tech/interface-it").append(NEWLINE)
				.append(" * {@link ").append(delegateClass.getTypeName()).append("}").append(NEWLINE).append(" */")
				.append(NEWLINE);
	}

	public String getIndentationUnit() {
		return indentationUnit;
	}

	private String makeIndentationUnit() {
		StringBuilder indentation = new StringBuilder();
		for (int i = 0; i < indentationSpaces; i++) {
			indentation.append(' ');
		}
		String indentationUnit = indentation.toString();
		return indentationUnit;
	}
	
	/**
	 * Add a javadoc comment for the generated method
	 * @param buf
	 * @param methodName
	 * @param genericStringForMethod
	 * @param declaringClassTypeName
	 * @param paramsForJavadocLink
	 * @return buf
	 */
	public StringBuilder appendMethodComment(StringBuilder buf, String methodName, String genericStringForMethod, String declaringClassTypeName,  String paramsForJavadocLink) {
		return buf.append(indentationUnit).append("/**").append(NEWLINE).append(indentationUnit)
				.append(" * Delegate call to ").append(genericStringForMethod).append(NEWLINE).append(indentationUnit)
				.append(" * ").append("{@link ").append(declaringClassTypeName).append('#')
				.append(methodName).append("(").append(paramsForJavadocLink).append(")}")
				.append(NEWLINE).append(indentationUnit).append(" */");
	}
	
	/**
	 * Generate a String containing a newline followed by the given number of indentations
	 * @param indentations
	 * @return String with line break and indentation
	 */
	public String newlineWithIndentations(int indentations) {
		StringBuilder buf = new StringBuilder();
		buf.append(NEWLINE);
		for(int i=0; i < indentations; i++) {
			buf.append(indentationUnit);
		}
	
		return buf.toString();
	}
	
	
}
