/*
 * Decompiled with CFR 0.152.
 */
package com.eru.dynamo.control;

import com.eru.dynamo.control.skin.DisplaySkin;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class Display
extends Control {
    public static final Color DEFAULT_TEXT_FILL = Color.LIGHTGRAY;
    public static final DisplayFont DEFAULT_DISPLAY_FONT = DisplayFont.XOLONIUM;
    public static final int DEFAULT_BLINKING_INTERVAL = 500;
    private ObjectProperty<Paint> textFill;
    private StringProperty currentText;
    private ObjectProperty<DisplayFont> valueFont;
    private BooleanProperty alarmed;
    private StringProperty title;
    private ObjectProperty<DisplayFont> titleFont;
    private StringProperty unit;
    private ObjectProperty<DisplayFont> unitFont;
    private BooleanProperty unitVisible;
    private BooleanProperty blinking;
    private IntegerProperty blinkingInterval;
    private volatile ScheduledFuture<?> periodicBlinkTask;
    private static ScheduledExecutorService periodicBlinkExecutorService;

    public Display() {
        this.getStyleClass().add((Object)"display");
        this.textFill = new SimpleObjectProperty((Object)this, "textFill", (Object)DEFAULT_TEXT_FILL);
        this.currentText = new SimpleStringProperty((Object)this, "currentTex", "VALUE");
        this.valueFont = new SimpleObjectProperty((Object)this, "valueFont", (Object)DEFAULT_DISPLAY_FONT);
        this.alarmed = new SimpleBooleanProperty((Object)this, "alarmed", false);
        this.title = new SimpleStringProperty((Object)this, "title", "TITLE");
        this.titleFont = new SimpleObjectProperty((Object)this, "titleFont", (Object)DEFAULT_DISPLAY_FONT);
        this.unit = new SimpleStringProperty((Object)this, "unit", "Unit");
        this.unitFont = new SimpleObjectProperty((Object)this, "unitFont", (Object)DEFAULT_DISPLAY_FONT);
        this.unitVisible = new SimpleBooleanProperty((Object)this, "unitVisible", true);
        this.blinking = new SimpleBooleanProperty((Object)this, "blinking", false);
        this.blinkingInterval = new SimpleIntegerProperty((Object)this, "blinkingInterval", 500);
    }

    public Paint getTextFill() {
        return (Paint)this.textFill.get();
    }

    public ObjectProperty<Paint> textFillProperty() {
        return this.textFill;
    }

    public void setTextFill(Paint textFill) {
        this.textFill.set((Object)textFill);
    }

    public String getCurrentText() {
        return (String)this.currentText.get();
    }

    public StringProperty currentTextProperty() {
        return this.currentText;
    }

    public void setCurrentText(String currentText) {
        this.currentText.set((Object)currentText);
    }

    public DisplayFont getValueFont() {
        return (DisplayFont)((Object)this.valueFont.get());
    }

    public ObjectProperty<DisplayFont> valueFontProperty() {
        return this.valueFont;
    }

    public void setValueFont(DisplayFont valueFont) {
        this.valueFont.set((Object)valueFont);
    }

    public boolean getAlarmed() {
        return this.alarmed.get();
    }

    public BooleanProperty alarmedProperty() {
        return this.alarmed;
    }

    public void setAlarmed(boolean alarmed) {
        this.alarmed.set(alarmed);
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public DisplayFont getTitleFont() {
        return (DisplayFont)((Object)this.titleFont.get());
    }

    public ObjectProperty<DisplayFont> titleFontProperty() {
        return this.titleFont;
    }

    public void setTitleFont(DisplayFont titleFont) {
        this.titleFont.set((Object)titleFont);
    }

    public String getUnit() {
        return (String)this.unit.get();
    }

    public StringProperty unitProperty() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit.set((Object)unit);
    }

    public DisplayFont getUnitFont() {
        return (DisplayFont)((Object)this.unitFont.get());
    }

    public ObjectProperty<DisplayFont> unitFontProperty() {
        return this.unitFont;
    }

    public void setUnitFont(DisplayFont unitFont) {
        this.unitFont.set((Object)unitFont);
    }

    public boolean getUnitVisible() {
        return this.unitVisible.get();
    }

    public BooleanProperty unitVisibleProperty() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean unitVisible) {
        this.unitVisible.set(unitVisible);
    }

    public boolean getBlinking() {
        return this.blinking.get();
    }

    public BooleanProperty blinkingProperty() {
        return this.blinking;
    }

    public void setBlinking(boolean blinking) {
        this.blinking.set(blinking);
    }

    public int getBlinkingInterval() {
        return this.blinkingInterval.get();
    }

    public IntegerProperty blinkingIntervalProperty() {
        return this.blinkingInterval;
    }

    public void setBlinkingInterval(int blinkingInterval) {
        this.blinkingInterval.set(blinkingInterval);
    }

    private static synchronized void enableBlinkExecutorService() {
        if (null == periodicBlinkExecutorService) {
            periodicBlinkExecutorService = new ScheduledThreadPoolExecutor(1, Display.getThreadFactory("BlinkDisplay", true));
        }
    }

    private synchronized void scheduleBlinkTask() {
        Display.enableBlinkExecutorService();
        this.stopTask(this.periodicBlinkTask);
        this.periodicBlinkTask = periodicBlinkExecutorService.scheduleAtFixedRate(() -> Platform.runLater(() -> this.setAlarmed(!this.getAlarmed())), 0L, this.getBlinkingInterval(), TimeUnit.MILLISECONDS);
    }

    private static ThreadFactory getThreadFactory(String THREAD_NAME, boolean IS_DAEMON) {
        return runnable -> {
            Thread thread = new Thread(runnable, THREAD_NAME);
            thread.setDaemon(IS_DAEMON);
            return thread;
        };
    }

    private void stopTask(ScheduledFuture<?> task) {
        if (null == task) {
            return;
        }
        task.cancel(true);
        task = null;
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("display.css").toExternalForm();
    }

    protected Skin<?> createDefaultSkin() {
        return new DisplaySkin(this);
    }

    public static enum DisplayFont {
        STANDARD("Open Sans"),
        LCD("Digital-7"),
        DIGITAL("Digital Readout Upright"),
        DIGITAL_BOLD("Digital Readout Thick Upright"),
        ELEKTRA("Elektra"),
        XOLONIUM("Xolonium");

        private final String name;

        private DisplayFont(String font) {
            this.name = font;
        }

        public String getFontname() {
            return this.name;
        }
    }
}

