/*
 * Decompiled with CFR 0.152.
 */
package com.eru.dynamo.control;

import com.eru.dynamo.control.skin.GaugeSkin;
import com.eru.dynamo.util.Section;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class Gauge
extends Control {
    public static final int DEFAULT_ANIMATION_DURATION = 300;
    private final DoubleProperty currentValue;
    private final ObjectProperty<DisplayFont> valueFont;
    private final DoubleProperty minValue;
    private final DoubleProperty maxValue;
    private final DoubleProperty threshold;
    private final DoubleProperty minMeasuredValue;
    private final DoubleProperty maxMeasuredValue;
    private final IntegerProperty decimals;
    private final StringProperty title;
    private final StringProperty unit;
    private final DoubleProperty startAngle;
    private final DoubleProperty angleRange;
    private final BooleanProperty clockwise;
    private final ObjectProperty<TickLabelOrientation> tickLabelOrientation;
    private final DoubleProperty majorTickSpace;
    private final DoubleProperty minorTickSpace;
    private final BooleanProperty ticksRoundedToInteger;
    private final BooleanProperty customTickLabelsEnabled;
    private final ObservableList<String> customTickLabels;
    private final BooleanProperty plainValue;
    private final BooleanProperty histogramEnabled;
    private final BooleanProperty dropShadowEnabled;
    private final BooleanProperty sectionsVisible;
    private final BooleanProperty thresholdVisible;
    private final BooleanProperty minMeasuredValueVisible;
    private final BooleanProperty maxMeasuredValueVisible;
    private final BooleanProperty animated;
    private final DoubleProperty animationDuration;
    private final ObservableList<Section> sections;

    public Gauge() {
        this.getStyleClass().add((Object)"gauge");
        this.valueFont = new SimpleObjectProperty((Object)this, "valueFont", (Object)DisplayFont.DIGITAL);
        this.currentValue = new DoublePropertyBase(-1.0){

            protected void invalidated() {
                this.set(Gauge.this.clamp(Gauge.this.getMinValue(), Gauge.this.getMaxValue(), this.get()));
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "currentValue";
            }
        };
        this.minValue = new DoublePropertyBase(0.0){

            protected void invalidated() {
                if (this.getValue() < this.get()) {
                    this.setValue(this.get());
                }
                if (Gauge.this.getThreshold() < this.get()) {
                    Gauge.this.setThreshold(this.get());
                }
                for (Section section : Gauge.this.sections) {
                    if (section.getStart() < this.get()) {
                        section.setStart(this.get());
                    }
                    if (!(section.getStop() < this.get())) continue;
                    section.setStop(this.get());
                }
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "minValue";
            }
        };
        this.maxValue = new DoublePropertyBase(100.0){

            protected void invalidated() {
                if (this.getValue() > this.get()) {
                    this.setValue(this.get());
                }
                if (Gauge.this.getThreshold() > this.get()) {
                    Gauge.this.setThreshold(this.get());
                }
                for (Section section : Gauge.this.sections) {
                    if (section.getStart() > this.get()) {
                        section.setStart(this.get());
                    }
                    if (!(section.getStop() > this.get())) continue;
                    section.setStop(this.get());
                }
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "maxValue";
            }
        };
        this.threshold = new DoublePropertyBase(50.0){

            protected void invalidated() {
                this.set(Gauge.this.clamp(Gauge.this.getMinValue(), Gauge.this.getMaxValue(), this.get()));
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "threshold";
            }
        };
        this.minMeasuredValue = new SimpleDoubleProperty((Object)this, "minMeasuredValue", 0.0);
        this.maxMeasuredValue = new SimpleDoubleProperty((Object)this, "maxMeasuredValue", 0.0);
        this.decimals = new IntegerPropertyBase(1){

            protected void invalidated() {
                this.set(Gauge.this.clamp(0, 3, this.get()));
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "decimals";
            }
        };
        this.title = new SimpleStringProperty((Object)this, "title", "");
        this.unit = new SimpleStringProperty((Object)this, "unit", "");
        this.startAngle = new DoublePropertyBase(0.0){

            protected void invalidated() {
                this.set(Gauge.this.clamp(0.0, 360.0, this.get()));
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "startAngle";
            }
        };
        this.angleRange = new DoublePropertyBase(360.0){

            protected void invalidated() {
                this.set(Gauge.this.clamp(0.0, 360.0, this.get()));
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "angleRange";
            }
        };
        this.clockwise = new SimpleBooleanProperty((Object)this, "clockwise", true);
        this.tickLabelOrientation = new SimpleObjectProperty((Object)this, "tickLabelOrientation", (Object)TickLabelOrientation.HORIZONTAL);
        this.sections = FXCollections.observableArrayList();
        this.majorTickSpace = new SimpleDoubleProperty((Object)this, "majorTickSpace", 10.0);
        this.minorTickSpace = new SimpleDoubleProperty((Object)this, "majorTickSpace", 1.0);
        this.ticksRoundedToInteger = new SimpleBooleanProperty((Object)this, "ticksRoundedToInteger", true);
        this.customTickLabelsEnabled = new SimpleBooleanProperty((Object)this, "customTickLabelsEnabled", false);
        this.customTickLabels = FXCollections.observableArrayList();
        this.plainValue = new SimpleBooleanProperty((Object)this, "plainValue", true);
        this.histogramEnabled = new SimpleBooleanProperty((Object)this, "historigramEnabled", true);
        this.dropShadowEnabled = new SimpleBooleanProperty((Object)this, "dropShadowEnabled", true);
        this.sectionsVisible = new SimpleBooleanProperty((Object)this, "sectionsVisible", true);
        this.thresholdVisible = new SimpleBooleanProperty((Object)this, "thresholdVisible", true);
        this.minMeasuredValueVisible = new SimpleBooleanProperty((Object)this, "minMeasuredValueVisible", true);
        this.maxMeasuredValueVisible = new SimpleBooleanProperty((Object)this, "maxMeasuredValueVisible", true);
        this.animated = new SimpleBooleanProperty((Object)this, "animated", true);
        this.animationDuration = new SimpleDoubleProperty((Object)this, "animationDuration", 300.0);
    }

    public double getCurrentValue() {
        return this.currentValue.get();
    }

    public DoubleProperty currentValueProperty() {
        return this.currentValue;
    }

    public void setCurrentValue(double currentValue) {
        this.currentValue.set(currentValue);
    }

    public DisplayFont getValueFont() {
        return (DisplayFont)((Object)this.valueFont.get());
    }

    public ObjectProperty<DisplayFont> valueFontProperty() {
        return this.valueFont;
    }

    public void setValueFont(DisplayFont valueFont) {
        this.valueFont.set((Object)valueFont);
    }

    public double getMinValue() {
        return this.minValue.get();
    }

    public DoubleProperty minValueProperty() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue.set(minValue);
    }

    public double getMaxValue() {
        return this.maxValue.get();
    }

    public DoubleProperty maxValueProperty() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue.set(maxValue);
    }

    public double getThreshold() {
        return this.threshold.get();
    }

    public DoubleProperty thresholdProperty() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold.set(this.clamp(this.getMinValue(), this.getMaxValue(), threshold));
    }

    public double getMinMeasuredValue() {
        return this.minMeasuredValue.get();
    }

    public DoubleProperty minMeasuredValueProperty() {
        return this.minMeasuredValue;
    }

    public void setMinMeasuredValue(double minMeasuredValue) {
        this.minMeasuredValue.set(minMeasuredValue);
    }

    public double getMaxMeasuredValue() {
        return this.maxMeasuredValue.get();
    }

    public DoubleProperty maxMeasuredValueProperty() {
        return this.maxMeasuredValue;
    }

    public void setMaxMeasuredValue(double maxMeasuredValue) {
        this.maxMeasuredValue.set(maxMeasuredValue);
    }

    public int getDecimals() {
        return this.decimals.get();
    }

    public IntegerProperty decimalsProperty() {
        return this.decimals;
    }

    public void setDecimals(int decimals) {
        this.decimals.set(this.clamp(0, 3, decimals));
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public String getUnit() {
        return (String)this.unit.get();
    }

    public StringProperty unitProperty() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit.set((Object)unit);
    }

    public double getStartAngle() {
        return this.startAngle.get();
    }

    public DoubleProperty startAngleProperty() {
        return this.startAngle;
    }

    public void setStartAngle(double startAngle) {
        this.startAngle.set(this.clamp(0.0, 360.0, startAngle));
    }

    public double getAngleRange() {
        return this.angleRange.get();
    }

    public DoubleProperty angleRangeProperty() {
        return this.angleRange;
    }

    public void setAngleRange(double angleRange) {
        this.angleRange.set(this.clamp(0.0, 360.0, angleRange));
    }

    public boolean getClockwise() {
        return this.clockwise.get();
    }

    public BooleanProperty clockwiseProperty() {
        return this.clockwise;
    }

    public void setClockwise(boolean clockwise) {
        this.clockwise.set(clockwise);
    }

    public TickLabelOrientation getTickLabelOrientation() {
        return (TickLabelOrientation)((Object)this.tickLabelOrientation.get());
    }

    public ObjectProperty<TickLabelOrientation> tickLabelOrientationProperty() {
        return this.tickLabelOrientation;
    }

    public void setTickLabelOrientation(TickLabelOrientation tickLabelOrientation) {
        this.tickLabelOrientation.set((Object)tickLabelOrientation);
    }

    public final ObservableList<Section> getSections() {
        return this.sections;
    }

    public final void setSections(List<Section> SECTIONS) {
        this.sections.setAll(SECTIONS);
    }

    public final void setSections(Section ... SECTIONS) {
        this.setSections(Arrays.asList(SECTIONS));
    }

    public final void addSection(Section SECTION) {
        if (!this.sections.contains((Object)SECTION)) {
            this.sections.add((Object)SECTION);
        }
    }

    public final void removeSection(Section SECTION) {
        if (this.sections.contains((Object)SECTION)) {
            this.sections.remove((Object)SECTION);
        }
    }

    public double getMajorTickSpace() {
        return this.majorTickSpace.get();
    }

    public DoubleProperty majorTickSpaceProperty() {
        return this.majorTickSpace;
    }

    public void setMajorTickSpace(double majorTickSpace) {
        this.majorTickSpace.set(majorTickSpace);
    }

    public double getMinorTickSpace() {
        return this.minorTickSpace.get();
    }

    public DoubleProperty minorTickSpaceProperty() {
        return this.minorTickSpace;
    }

    public void setMinorTickSpace(double minorTickSpace) {
        this.minorTickSpace.set(minorTickSpace);
    }

    public boolean getTicksRoundedToInteger() {
        return this.ticksRoundedToInteger.get();
    }

    public BooleanProperty ticksRoundedToIntegerProperty() {
        return this.ticksRoundedToInteger;
    }

    public void setTicksRoundedToInteger(boolean ticksRoundedToInteger) {
        this.ticksRoundedToInteger.set(ticksRoundedToInteger);
    }

    public boolean getCustomTickLabelsEnabled() {
        return this.customTickLabelsEnabled.getValue();
    }

    public void setCustomTickLabelsEnabled(boolean ENABLED) {
        this.customTickLabelsEnabled.setValue(Boolean.valueOf(ENABLED));
    }

    public BooleanProperty customTickLabelsEnabledProperty() {
        return this.customTickLabelsEnabled;
    }

    public List<String> getCustomTickLabels() {
        return this.customTickLabels;
    }

    public void setCustomTickLabels(List<String> TICK_LABELS) {
        this.customTickLabels.setAll(TICK_LABELS);
    }

    public void setCustomTickLabels(String ... TICK_LABELS) {
        this.setCustomTickLabels(Arrays.asList(TICK_LABELS));
    }

    public boolean getPlainValue() {
        return this.plainValue.get();
    }

    public BooleanProperty plainValueProperty() {
        return this.plainValue;
    }

    public void setPlainValue(boolean plainValue) {
        this.plainValue.set(plainValue);
    }

    public boolean getHistogramEnabled() {
        return this.histogramEnabled.get();
    }

    public BooleanProperty histogramEnabledProperty() {
        return this.histogramEnabled;
    }

    public void setHistogramEnabled(boolean histogramEnabled) {
        this.histogramEnabled.set(histogramEnabled);
    }

    public boolean getDropShadowEnabled() {
        return this.dropShadowEnabled.get();
    }

    public BooleanProperty dropShadowEnabledProperty() {
        return this.dropShadowEnabled;
    }

    public void setDropShadowEnabled(boolean dropShadowEnabled) {
        this.dropShadowEnabled.set(dropShadowEnabled);
    }

    public boolean getSectionsVisible() {
        return this.sectionsVisible.get();
    }

    public BooleanProperty sectionsVisibleProperty() {
        return this.sectionsVisible;
    }

    public void setSectionsVisible(boolean sectionsVisible) {
        this.sectionsVisible.set(sectionsVisible);
    }

    public boolean getThresholdVisible() {
        return this.thresholdVisible.get();
    }

    public BooleanProperty thresholdVisibleProperty() {
        return this.thresholdVisible;
    }

    public void setThresholdVisible(boolean thresholdVisible) {
        this.thresholdVisible.set(thresholdVisible);
    }

    public boolean getMinMeasuredValueVisible() {
        return this.minMeasuredValueVisible.get();
    }

    public BooleanProperty minMeasuredValueVisibleProperty() {
        return this.minMeasuredValueVisible;
    }

    public void setMinMeasuredValueVisible(boolean minMeasuredValueVisible) {
        this.minMeasuredValueVisible.set(minMeasuredValueVisible);
    }

    public boolean getMaxMeasuredValueVisible() {
        return this.maxMeasuredValueVisible.get();
    }

    public BooleanProperty maxMeasuredValueVisibleProperty() {
        return this.maxMeasuredValueVisible;
    }

    public void setMaxMeasuredValueVisible(boolean maxMeasuredValueVisible) {
        this.maxMeasuredValueVisible.set(maxMeasuredValueVisible);
    }

    public boolean getAnimated() {
        return this.animated.get();
    }

    public BooleanProperty animatedProperty() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated.set(animated);
    }

    public double getAnimationDuration() {
        return this.animationDuration.get();
    }

    public DoubleProperty animationDurationProperty() {
        return this.animationDuration;
    }

    public void setAnimationDuration(double animationDuration) {
        this.animationDuration.set(animationDuration);
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private int clamp(int MIN_VALUE, int MAX_VALUE, int VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    protected Skin createDefaultSkin() {
        return new GaugeSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("gauge.css").toExternalForm();
    }

    public static enum TickLabelOrientation {
        ORTHOGONAL,
        HORIZONTAL,
        TANGENT;

    }

    public static enum DisplayFont {
        STANDARD("Open Sans"),
        LCD("Digital-7"),
        DIGITAL("Digital Readout Upright"),
        DIGITAL_BOLD("Digital Readout Thick Upright"),
        ELEKTRA("Elektra");

        private final String name;

        private DisplayFont(String font) {
            this.name = font;
        }

        public String getFontname() {
            return this.name;
        }
    }
}

