/*
 * Decompiled with CFR 0.152.
 */
package com.eru.dynamo.control;

import com.eru.dynamo.control.skin.GeneratorSkin;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class Generator
extends Control {
    public static final int DEFAULT_ANIMATION_DURATION = 2500;
    private BooleanProperty animated;
    private IntegerProperty animationDuration;
    private StringProperty name;
    private ObjectProperty<EngineState> state;
    private DoubleProperty voltagePhaseALL;
    private DoubleProperty voltagePhaseBLL;
    private DoubleProperty voltagePhaseCLL;
    private DoubleProperty currentPhaseALL;
    private DoubleProperty currentPhaseBLL;
    private DoubleProperty currentPhaseCLL;
    private DoubleProperty frequency;
    private IntegerProperty engineRuntime;
    private DoubleProperty temperature;
    private DoubleProperty oilPressure;
    private BooleanProperty alarmed;
    private StringProperty easyGenStatus;

    public Generator() {
        this.getStyleClass().add((Object)"generator");
        this.animated = new SimpleBooleanProperty((Object)this, "animated", true);
        this.animationDuration = new SimpleIntegerProperty((Object)this, "animationDuration", 2500);
        this.voltagePhaseALL = new SimpleDoubleProperty((Object)this, "voltagePhaseALL", 0.0);
        this.voltagePhaseBLL = new SimpleDoubleProperty((Object)this, "voltagePhaseBLL", 0.0);
        this.voltagePhaseCLL = new SimpleDoubleProperty((Object)this, "voltagePhaseCLL", 0.0);
        this.currentPhaseALL = new SimpleDoubleProperty((Object)this, "currentPhaseALL", 0.0);
        this.currentPhaseBLL = new SimpleDoubleProperty((Object)this, "currentPhaseBLL", 0.0);
        this.currentPhaseCLL = new SimpleDoubleProperty((Object)this, "currentPhaseCLL", 0.0);
        this.frequency = new SimpleDoubleProperty((Object)this, "frequency", 0.0);
        this.engineRuntime = new SimpleIntegerProperty((Object)this, "engineRuntime", 0);
        this.temperature = new SimpleDoubleProperty((Object)this, "temperature", 0.0);
        this.oilPressure = new SimpleDoubleProperty((Object)this, "oilPressure", 0.0);
        this.state = new SimpleObjectProperty((Object)this, "state", (Object)EngineState.OFF);
        this.alarmed = new SimpleBooleanProperty((Object)this, "alarmed", false);
        this.name = new SimpleStringProperty((Object)this, "name", "G");
        this.easyGenStatus = new SimpleStringProperty((Object)this, "easyGenStatus", "");
    }

    public boolean getAnimated() {
        return this.animated.get();
    }

    public BooleanProperty animatedProperty() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated.set(animated);
    }

    public int getAnimationDuration() {
        return this.animationDuration.get();
    }

    public IntegerProperty animationDurationProperty() {
        return this.animationDuration;
    }

    public void setAnimationDuration(int animationDuration) {
        this.animationDuration.set(animationDuration);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public EngineState getState() {
        return (EngineState)((Object)this.state.get());
    }

    public ObjectProperty<EngineState> stateProperty() {
        return this.state;
    }

    public void setState(EngineState state) {
        this.state.set((Object)state);
    }

    public double getVoltagePhaseALL() {
        return this.voltagePhaseALL.get();
    }

    public DoubleProperty voltagePhaseALLProperty() {
        return this.voltagePhaseALL;
    }

    public void setVoltagePhaseALL(double voltagePhaseALL) {
        this.voltagePhaseALL.set(voltagePhaseALL);
    }

    public double getVoltagePhaseBLL() {
        return this.voltagePhaseBLL.get();
    }

    public DoubleProperty voltagePhaseBLLProperty() {
        return this.voltagePhaseBLL;
    }

    public void setVoltagePhaseBLL(double voltagePhaseBLL) {
        this.voltagePhaseBLL.set(voltagePhaseBLL);
    }

    public double getVoltagePhaseCLL() {
        return this.voltagePhaseCLL.get();
    }

    public DoubleProperty voltagePhaseCLLProperty() {
        return this.voltagePhaseCLL;
    }

    public void setVoltagePhaseCLL(double voltagePhaseCLL) {
        this.voltagePhaseCLL.set(voltagePhaseCLL);
    }

    public double getCurrentPhaseALL() {
        return this.currentPhaseALL.get();
    }

    public DoubleProperty currentPhaseALLProperty() {
        return this.currentPhaseALL;
    }

    public void setCurrentPhaseALL(double currentPhaseALL) {
        this.currentPhaseALL.set(currentPhaseALL);
    }

    public double getCurrentPhaseBLL() {
        return this.currentPhaseBLL.get();
    }

    public DoubleProperty currentPhaseBLLProperty() {
        return this.currentPhaseBLL;
    }

    public void setCurrentPhaseBLL(double currentPhaseBLL) {
        this.currentPhaseBLL.set(currentPhaseBLL);
    }

    public double getCurrentPhaseCLL() {
        return this.currentPhaseCLL.get();
    }

    public DoubleProperty currentPhaseCLLProperty() {
        return this.currentPhaseCLL;
    }

    public void setCurrentPhaseCLL(double currentPhaseCLL) {
        this.currentPhaseCLL.set(currentPhaseCLL);
    }

    public double getFrequency() {
        return this.frequency.get();
    }

    public DoubleProperty frequencyProperty() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency.set(frequency);
    }

    public int getEngineRuntime() {
        return this.engineRuntime.get();
    }

    public IntegerProperty engineRuntimeProperty() {
        return this.engineRuntime;
    }

    public void setEngineRuntime(int engineRuntime) {
        this.engineRuntime.set(engineRuntime);
    }

    public double getTemperature() {
        return this.temperature.get();
    }

    public DoubleProperty temperatureProperty() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature.set(temperature);
    }

    public double getOilPressure() {
        return this.oilPressure.get();
    }

    public DoubleProperty oilPressureProperty() {
        return this.oilPressure;
    }

    public void setOilPressure(double oilPressure) {
        this.oilPressure.set(oilPressure);
    }

    public boolean getAlarmed() {
        return this.alarmed.get();
    }

    public BooleanProperty alarmedProperty() {
        return this.alarmed;
    }

    public void setAlarmed(boolean alarmed) {
        this.alarmed.set(alarmed);
    }

    public String getEasyGenStatus() {
        return (String)this.easyGenStatus.get();
    }

    public StringProperty easyGenStatusProperty() {
        return this.easyGenStatus;
    }

    public void setEasyGenStatus(String easyGenStatus) {
        this.easyGenStatus.set((Object)easyGenStatus);
        switch (easyGenStatus) {
            case "Start": 
            case "Ramp to rated": 
            case "Loading Generator": 
            case "Gen stable time": 
            case "Unloading Generator": {
                this.setState(EngineState.CRANK);
                break;
            }
            case "In Operation": 
            case "Start w/o Load": {
                this.setState(EngineState.RUN);
                break;
            }
            default: {
                this.setState(EngineState.OFF);
            }
        }
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("generator.css").toExternalForm();
    }

    protected Skin<?> createDefaultSkin() {
        return new GeneratorSkin(this);
    }

    public static enum EngineState {
        OFF,
        PREGLOW,
        CRANK,
        RUN,
        COOLDOWN,
        RESTART,
        FAILED,
        UNKNOWN;

    }
}

