/*
 * Decompiled with CFR 0.152.
 */
package com.eru.dynamo.control;

import com.eru.dynamo.control.skin.LevelBarSkin;
import com.eru.dynamo.util.Section;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class LevelBar
extends Control {
    public static final Color DEFAULT_TEXT_FILL = Color.LIGHTGRAY;
    private static final double DEFAULT_ANIMATION_DURATION = 300.0;
    private static final int DEFAULT_DECIMALS = 2;
    private ObjectProperty<Paint> textFill;
    private DoubleProperty currentValue;
    private DoubleProperty minValue;
    private DoubleProperty maxValue;
    private IntegerProperty decimals;
    private ObservableList<Section> sections;
    private StringProperty title;
    private StringProperty unit;
    private BooleanProperty unitVisible;
    private BooleanProperty animated;
    private DoubleProperty animationDuration;

    public LevelBar() {
        this.getStyleClass().add((Object)"level-bar");
        this.textFill = new SimpleObjectProperty((Object)this, "textFill", (Object)DEFAULT_TEXT_FILL);
        this.currentValue = new SimpleDoubleProperty((Object)this, "currentValue", -1.0);
        this.minValue = new SimpleDoubleProperty((Object)this, "minValue", 0.0);
        this.maxValue = new SimpleDoubleProperty((Object)this, "maxValue", 0.0);
        this.decimals = new SimpleIntegerProperty((Object)this, "decimals", 2);
        this.sections = FXCollections.observableArrayList();
        this.title = new SimpleStringProperty((Object)this, "title", "TITLE");
        this.unit = new SimpleStringProperty((Object)this, "unit", "Unit");
        this.unitVisible = new SimpleBooleanProperty((Object)this, "unitVisible", true);
        this.animated = new SimpleBooleanProperty((Object)this, "animated", true);
        this.animationDuration = new SimpleDoubleProperty((Object)this, "animationDuration", 300.0);
    }

    public Paint getTextFill() {
        return (Paint)this.textFill.get();
    }

    public ObjectProperty<Paint> textFillProperty() {
        return this.textFill;
    }

    public void setTextFill(Paint textFill) {
        this.textFill.set((Object)textFill);
    }

    public double getCurrentValue() {
        return this.currentValue.get();
    }

    public DoubleProperty currentValueProperty() {
        return this.currentValue;
    }

    public void setCurrentValue(double currentValue) {
        this.currentValue.set(currentValue);
    }

    public double getMinValue() {
        return this.minValue.get();
    }

    public DoubleProperty minValueProperty() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue.set(minValue);
    }

    public double getMaxValue() {
        return this.maxValue.get();
    }

    public DoubleProperty maxValueProperty() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue.set(maxValue);
    }

    public int getDecimals() {
        return this.decimals.get();
    }

    public IntegerProperty decimalsProperty() {
        return this.decimals;
    }

    public void setDecimals(int decimals) {
        this.decimals.set(decimals);
    }

    public final ObservableList<Section> getSections() {
        return this.sections;
    }

    public final void setSections(List<Section> SECTIONS) {
        this.sections.setAll(SECTIONS);
    }

    public final void setSections(Section ... SECTIONS) {
        this.setSections(Arrays.asList(SECTIONS));
    }

    public final void addSection(Section SECTION) {
        if (!this.sections.contains((Object)SECTION)) {
            this.sections.add((Object)SECTION);
        }
    }

    public final void removeSection(Section SECTION) {
        if (this.sections.contains((Object)SECTION)) {
            this.sections.remove((Object)SECTION);
        }
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public String getUnit() {
        return (String)this.unit.get();
    }

    public StringProperty unitProperty() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit.set((Object)unit);
    }

    public boolean getUnitVisible() {
        return this.unitVisible.get();
    }

    public BooleanProperty unitVisibleProperty() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean unitVisible) {
        this.unitVisible.set(unitVisible);
    }

    public boolean getAnimated() {
        return this.animated.get();
    }

    public BooleanProperty animatedProperty() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated.set(animated);
    }

    public double getAnimationDuration() {
        return this.animationDuration.get();
    }

    public DoubleProperty animationDurationProperty() {
        return this.animationDuration;
    }

    public void setAnimationDuration(double animationDuration) {
        this.animationDuration.set(animationDuration);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("level-bar.css").toExternalForm();
    }

    protected Skin<?> createDefaultSkin() {
        return new LevelBarSkin(this);
    }
}

