/*
 * Decompiled with CFR 0.152.
 */
package com.eru.dynamo.control.skin;

import com.eru.dynamo.control.Alarm;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class AlarmSkin
extends SkinBase<Alarm> {
    private static final double PREFERRED_HEIGHT = 24.0;
    private static final double PREFERRED_WIDTH = 125.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final String WARNING_COLOR = "#874443";
    private static final String NORMAL_COLOR = "TRANSPARENT";
    private static double aspectRatio = 0.192;
    private double width;
    private double height;
    private Pane pane;
    private Region frame;
    private Region background;
    private Text nameText;

    public AlarmSkin() {
        super((Control)new Alarm());
    }

    public AlarmSkin(Alarm control) {
        super((Control)control);
        this.initDimension();
        this.initGraphics();
        this.registerListeners();
    }

    private void initDimension() {
        if (Double.compare(((Alarm)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Alarm)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Alarm)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Alarm)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Alarm)this.getSkinnable()).getPrefWidth() > 0.0 && ((Alarm)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Alarm)this.getSkinnable()).setPrefSize(((Alarm)this.getSkinnable()).getPrefWidth(), ((Alarm)this.getSkinnable()).getPrefHeight());
            } else {
                ((Alarm)this.getSkinnable()).setPrefSize(125.0, 24.0);
            }
        }
        if (Double.compare(((Alarm)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Alarm)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Alarm)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((Alarm)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Alarm)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Alarm)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.frame = new Region();
        this.frame.getStyleClass().setAll((Object[])new String[]{"frame"});
        this.frame.setVisible(((Alarm)this.getSkinnable()).getCurrentValue());
        this.nameText = new Text(((Alarm)this.getSkinnable()).getName());
        this.nameText.getStyleClass().setAll((Object[])new String[]{"text"});
        this.nameText.setVisible(((Alarm)this.getSkinnable()).getCurrentValue());
        this.pane = new Pane(new Node[]{this.background, this.frame, this.nameText});
        this.getChildren().add((Object)this.pane);
        this.resize();
    }

    private void registerListeners() {
        ((Alarm)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((Alarm)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((Alarm)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Alarm)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Alarm)this.getSkinnable()).currentValueProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE_VALUE"));
        ((Alarm)this.getSkinnable()).nameProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE_NAME"));
    }

    private void handleControlPropertyChanged(String PROPERTY) {
        switch (PROPERTY) {
            case "UPDATE_VALUE": {
                this.update();
                break;
            }
            case "UPDATE_NAME": {
                this.nameText.setText(((Alarm)this.getSkinnable()).getName());
                break;
            }
            case "RESIZE": {
                this.resize();
            }
        }
    }

    protected double computeMinWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinWidth(Math.max(5.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMinHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinHeight(Math.max(5.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxWidth(Math.min(1024.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxHeight(Math.min(1024.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefHeight = 24.0;
        if (HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, HEIGHT - TOP_INSET - BOTTOM_INSET);
        }
        return super.computePrefWidth(prefHeight, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefWidth = 125.0;
        if (WIDTH != -1.0) {
            prefWidth = Math.max(0.0, WIDTH - LEFT_INSET - RIGHT_INSET);
        }
        return super.computePrefHeight(prefWidth, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    private void resize() {
        this.width = ((Alarm)this.getSkinnable()).getWidth();
        this.height = ((Alarm)this.getSkinnable()).getHeight();
        if (this.width > 0.0 && this.height > 0.0) {
            this.background.setPrefSize(this.width, this.height);
            this.frame.setPrefSize(this.width, this.height);
            this.update();
        }
    }

    private void update() {
        this.nameText.setVisible(((Alarm)this.getSkinnable()).getCurrentValue());
        this.nameText.setText(((Alarm)this.getSkinnable()).getName().toUpperCase());
        this.nameText.setFont(Font.font((double)(this.width * 0.07)));
        this.background.setStyle(((Alarm)this.getSkinnable()).getCurrentValue() ? "-background-color:".concat(WARNING_COLOR).concat(";") : "-background-color:".concat(NORMAL_COLOR).concat(";"));
        this.nameText.setTextAlignment(TextAlignment.CENTER);
        this.nameText.setX((this.width - this.nameText.getLayoutBounds().getWidth()) * 0.5);
        this.nameText.setY((this.height - this.nameText.getLayoutBounds().getHeight()) * 0.5);
        this.nameText.setTextOrigin(VPos.TOP);
        this.frame.setVisible(((Alarm)this.getSkinnable()).getCurrentValue());
    }
}

