/*
 * Decompiled with CFR 0.152.
 */
package com.eru.dynamo.control.skin;

import com.eru.dynamo.control.Display;
import com.eru.dynamo.fonts.Fonts;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class DisplaySkin
extends SkinBase<Display> {
    private static final double PREFERRED_WIDTH = 150.0;
    private static final double PREFERRED_HEIGHT = 40.0;
    private static final double MINIMUM_WIDTH = 20.0;
    private static final double MINIMUM_HEIGHT = 10.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double width;
    private double height;
    private double size;
    private Pane pane;
    private Text currentValueText;
    private Text unitText;
    private Text titleText;
    private Font currentValueFont;
    private Font unitFont;
    private Font titleFont;
    private Region frame;
    private Region background;
    private Region warningIcon;

    public DisplaySkin() {
        super((Control)new Display());
    }

    public DisplaySkin(Display control) {
        super((Control)control);
        this.initDimension();
        this.initGraphics();
        this.registerListeners();
    }

    private void initDimension() {
        if (Double.compare(((Display)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Display)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Display)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Display)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Display)this.getSkinnable()).getPrefWidth() > 0.0 && ((Display)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Display)this.getSkinnable()).setPrefSize(((Display)this.getSkinnable()).getPrefWidth(), ((Display)this.getSkinnable()).getPrefHeight());
            } else {
                ((Display)this.getSkinnable()).setPrefSize(150.0, 40.0);
            }
        }
        if (Double.compare(((Display)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Display)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Display)this.getSkinnable()).setMinSize(20.0, 10.0);
        }
        if (Double.compare(((Display)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Display)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Display)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.frame = new Region();
        this.frame.getStyleClass().setAll((Object[])new String[]{"frame"});
        this.frame.setStyle(((Display)this.getSkinnable()).getAlarmed() ? "-fx-background-color: -warning-color" : "-fx-background-color: -frame-color");
        this.warningIcon = new Region();
        this.warningIcon.getStyleClass().setAll((Object[])new String[]{"warning-icon"});
        this.warningIcon.setOpacity(((Display)this.getSkinnable()).getAlarmed() ? 1.0 : 0.0);
        this.currentValueText = new Text(((Display)this.getSkinnable()).getCurrentText());
        this.currentValueText.getStyleClass().setAll((Object[])new String[]{"text"});
        this.currentValueText.setTextOrigin(VPos.BOTTOM);
        this.currentValueText.setFill(((Display)this.getSkinnable()).getTextFill());
        this.unitText = new Text(((Display)this.getSkinnable()).getUnit());
        this.unitText.getStyleClass().setAll((Object[])new String[]{"text"});
        this.unitText.setOpacity(((Display)this.getSkinnable()).getUnitVisible() ? 1.0 : 0.0);
        this.unitText.setFill(((Display)this.getSkinnable()).getTextFill());
        this.unitText.setVisible(((Display)this.getSkinnable()).getAlarmed());
        this.titleText = new Text(((Display)this.getSkinnable()).getTitle());
        this.titleText.getStyleClass().setAll((Object[])new String[]{"text"});
        this.titleText.setFill(((Display)this.getSkinnable()).getTextFill());
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.background, this.frame, this.warningIcon, this.currentValueText, this.unitText, this.titleText});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
        this.updateDisplay();
    }

    private void registerListeners() {
        ((Display)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((Display)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((Display)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Display)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Display)this.getSkinnable()).currentTextProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE_VALUE"));
        ((Display)this.getSkinnable()).titleProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE_TITLE"));
        ((Display)this.getSkinnable()).unitProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE_UNIT"));
        ((Display)this.getSkinnable()).textFillProperty().addListener(observable -> this.handleControlPropertyChanged("TEXT_FILL"));
        ((Display)this.getSkinnable()).unitVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("UNIT_VISIBLE"));
        ((Display)this.getSkinnable()).valueFontProperty().addListener(observable -> this.handleControlPropertyChanged("FONTS"));
        ((Display)this.getSkinnable()).unitFontProperty().addListener(observable -> this.handleControlPropertyChanged("FONTS"));
        ((Display)this.getSkinnable()).titleFontProperty().addListener(observable -> this.handleControlPropertyChanged("FONTS"));
        ((Display)this.getSkinnable()).alarmedProperty().addListener(observable -> this.handleControlPropertyChanged("ALARMED"));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        switch (PROPERTY) {
            case "TEXT_FILL": {
                this.titleText.setFill(((Display)this.getSkinnable()).getTextFill());
                this.currentValueText.setFill(((Display)this.getSkinnable()).getTextFill());
                this.unitText.setFill(((Display)this.getSkinnable()).getTextFill());
                break;
            }
            case "RESIZE": {
                this.resize();
                this.updateDisplay();
                break;
            }
            case "UPDATE_VALUE": {
                this.updateDisplay();
                break;
            }
            case "UPDATE_TITLE": {
                this.titleText.setText(((Display)this.getSkinnable()).getTitle());
                this.titleText.setX((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case "UPDATE_UNIT": {
                this.unitText.setTextOrigin(VPos.BOTTOM);
                this.unitText.setTextAlignment(TextAlignment.RIGHT);
                this.unitText.setText(((Display)this.getSkinnable()).getUnit());
                this.unitText.setX(this.width - this.unitText.getLayoutBounds().getWidth() - this.height * 0.08);
                this.unitText.setY(this.height * 0.9);
                break;
            }
            case "UNIT_VISIBLE": {
                this.unitText.setOpacity(((Display)this.getSkinnable()).getUnitVisible() ? 1.0 : 0.0);
                break;
            }
            case "FONTS": {
                this.updateFonts();
                break;
            }
            case "ALARMED": {
                this.warningIcon.setOpacity(((Display)this.getSkinnable()).getAlarmed() ? 1.0 : 0.0);
                this.frame.setStyle(((Display)this.getSkinnable()).getAlarmed() ? "-fx-background-color: -warning-color" : "-fx-background-color: -frame-color");
            }
        }
    }

    protected double computeMinWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinWidth(Math.max(10.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMinHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinHeight(Math.max(20.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxWidth(Math.min(1024.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxHeight(Math.min(1024.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefHeight = 40.0;
        if (HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, HEIGHT - TOP_INSET - BOTTOM_INSET);
        }
        return super.computePrefWidth(prefHeight, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefWidth = 150.0;
        if (WIDTH != -1.0) {
            prefWidth = Math.max(0.0, WIDTH - LEFT_INSET - RIGHT_INSET);
        }
        return super.computePrefHeight(prefWidth, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    private void resize() {
        this.width = ((Display)this.getSkinnable()).getWidth();
        this.height = ((Display)this.getSkinnable()).getHeight();
        double d = this.size = ((Display)this.getSkinnable()).getWidth() < ((Display)this.getSkinnable()).getHeight() ? ((Display)this.getSkinnable()).getWidth() : ((Display)this.getSkinnable()).getHeight();
        if (this.width > 0.0 && this.height > 0.0) {
            this.updateFonts();
            this.warningIcon.setPrefSize(this.width * 0.12, this.height * 0.3);
            this.titleText.setTextOrigin(VPos.TOP);
            this.titleText.setTextAlignment(TextAlignment.CENTER);
            this.titleText.setText(((Display)this.getSkinnable()).getTitle());
            this.titleText.setX((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5);
            this.background.setPrefSize(this.width, this.height - this.titleText.getLayoutBounds().getHeight());
            this.background.setTranslateY(this.height - (this.height - this.titleText.getLayoutBounds().getHeight()));
            this.frame.setPrefSize(this.width, this.titleText.getLayoutBounds().getHeight());
            this.frame.setTranslateY(this.height - (this.height - this.titleText.getLayoutBounds().getHeight()));
            this.updateDisplay();
        }
    }

    private void updateFonts() {
        switch (((Display)this.getSkinnable()).getValueFont()) {
            case LCD: {
                this.currentValueFont = Fonts.digital(0.45 * this.size);
                break;
            }
            case DIGITAL: {
                this.currentValueFont = Fonts.digitalReadout(0.55 * this.size);
                break;
            }
            case DIGITAL_BOLD: {
                this.currentValueFont = Fonts.digitalReadoutBold(0.55 * this.size);
                break;
            }
            case ELEKTRA: {
                this.currentValueFont = Fonts.elektra(0.45 * this.size);
                break;
            }
            case XOLONIUM: {
                this.currentValueFont = Fonts.xoloniumBold(0.3 * this.size);
                break;
            }
            default: {
                this.currentValueFont = Fonts.xoloniumRegular(0.45 * this.size);
            }
        }
        switch (((Display)this.getSkinnable()).getUnitFont()) {
            case LCD: {
                this.unitFont = Fonts.digital(0.35 * this.size);
                break;
            }
            case DIGITAL: {
                this.unitFont = Fonts.digitalReadout(0.45 * this.size);
                break;
            }
            case DIGITAL_BOLD: {
                this.unitFont = Fonts.digitalReadoutBold(0.45 * this.size);
                break;
            }
            case ELEKTRA: {
                this.unitFont = Fonts.elektra(0.35 * this.size);
                break;
            }
            case XOLONIUM: {
                this.unitFont = Fonts.xoloniumBold(0.25 * this.size);
                break;
            }
            default: {
                this.unitFont = Fonts.xoloniumRegular(0.35 * this.size);
            }
        }
        switch (((Display)this.getSkinnable()).getTitleFont()) {
            case LCD: {
                this.titleFont = Fonts.digital(0.4 * this.size);
                break;
            }
            case DIGITAL: {
                this.titleFont = Fonts.digitalReadout(0.5 * this.size);
                break;
            }
            case DIGITAL_BOLD: {
                this.titleFont = Fonts.digitalReadoutBold(0.5 * this.size);
                break;
            }
            case ELEKTRA: {
                this.titleFont = Fonts.elektra(0.4 * this.size);
                break;
            }
            case XOLONIUM: {
                this.titleFont = Fonts.xoloniumBold(0.29 * this.size);
                break;
            }
            default: {
                this.titleFont = Fonts.xoloniumRegular(0.35 * this.size);
            }
        }
        this.currentValueText.setFont(this.currentValueFont);
        this.titleText.setFont(this.titleFont);
        this.unitText.setFont(this.unitFont);
    }

    private void updateDisplay() {
        this.currentValueText.setText(((Display)this.getSkinnable()).getCurrentText());
        this.currentValueText.setX((this.width - this.currentValueText.getLayoutBounds().getWidth()) * 0.5);
        this.currentValueText.setY(this.height * 0.8);
        this.unitText.setX(this.width - (this.width - this.currentValueText.getLayoutBounds().getWidth()) * 0.5);
        this.unitText.setY(this.height * 0.8);
    }
}

