/*
 * Decompiled with CFR 0.152.
 */
package com.eru.dynamo.control.skin;

import com.eru.dynamo.control.Gauge;
import com.eru.dynamo.util.Section;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class GaugeSkin
extends SkinBase<Gauge> {
    private static final double PREFERRED_WIDTH = 210.0;
    private static final double PREFERRED_HEIGHT = 210.0;
    private static final double MINIMUM_WIDTH = 20.0;
    private static final double MINIMUM_HEIGHT = 20.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private final Color TICK_AND_MARK_COLOR = Color.WHITE;
    private static final double CURRENT_VALUE_FONT_SIZE_FACTOR = 0.15;
    private final Timeline timeline = new Timeline();
    private double size;
    private Pane pane;
    private Region background;
    private Canvas ticksAndSectionsCanvas;
    private GraphicsContext ticksAndSections;
    private Region threshold;
    private Rotate thresholdRotate;
    private boolean thresholdExceeded;
    private Region minMeasuredValue;
    private Rotate minMeasuredValueRotate;
    private Region maxMeasuredValue;
    private Rotate maxMeasuredValueRotate;
    private Region needle;
    private Region needleHighlight;
    private Rotate needleRotate;
    private Region knob;
    private Group needleGroup;
    private DropShadow dropShadow;
    private Text title;
    private Text unit;
    private Text value;
    private Font currentValueFont;
    private DropShadow valueBlendBottomShadow;
    private InnerShadow valueBlendTopShadow;
    private Blend valueBlend;
    private Path histogram;
    private double angleStep;

    public GaugeSkin() {
        super((Control)new Gauge());
    }

    public GaugeSkin(Gauge gauge) {
        super((Control)gauge);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Gauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Gauge)this.getSkinnable()).setPrefSize(((Gauge)this.getSkinnable()).getPrefWidth(), ((Gauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((Gauge)this.getSkinnable()).setPrefSize(210.0, 210.0);
            }
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(20.0, 20.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.valueBlendBottomShadow = new DropShadow();
        this.valueBlendBottomShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.valueBlendBottomShadow.setColor(Color.rgb((int)255, (int)255, (int)255, (double)0.5));
        this.valueBlendBottomShadow.setOffsetX(0.0);
        this.valueBlendBottomShadow.setOffsetY(1.05);
        this.valueBlendBottomShadow.setRadius(0.0);
        this.valueBlendTopShadow = new InnerShadow();
        this.valueBlendTopShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.valueBlendTopShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.7));
        this.valueBlendTopShadow.setOffsetX(0.0);
        this.valueBlendTopShadow.setOffsetY(1.05);
        this.valueBlendTopShadow.setRadius(1.05);
        this.valueBlend = new Blend();
        this.valueBlend.setMode(BlendMode.MULTIPLY);
        this.valueBlend.setBottomInput((Effect)this.valueBlendBottomShadow);
        this.valueBlend.setTopInput((Effect)this.valueBlendTopShadow);
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.ticksAndSectionsCanvas = new Canvas(210.0, 210.0);
        this.ticksAndSections = this.ticksAndSectionsCanvas.getGraphicsContext2D();
        this.histogram = new Path();
        this.histogram.setFillRule(FillRule.NON_ZERO);
        this.histogram.getStyleClass().add((Object)"histogram-fill");
        this.angleStep = ((Gauge)this.getSkinnable()).getAngleRange() / (((Gauge)this.getSkinnable()).getMaxValue() - ((Gauge)this.getSkinnable()).getMinValue());
        this.minMeasuredValue = new Region();
        this.minMeasuredValue.getStyleClass().setAll((Object[])new String[]{"min-measured-value"});
        this.minMeasuredValueRotate = new Rotate(180.0 - ((Gauge)this.getSkinnable()).getStartAngle());
        this.minMeasuredValue.getTransforms().setAll((Object[])new Transform[]{this.minMeasuredValueRotate});
        this.minMeasuredValue.setOpacity(((Gauge)this.getSkinnable()).getMinMeasuredValueVisible() ? 1.0 : 0.0);
        this.minMeasuredValue.setManaged(((Gauge)this.getSkinnable()).getMinMeasuredValueVisible());
        this.maxMeasuredValue = new Region();
        this.maxMeasuredValue.getStyleClass().setAll((Object[])new String[]{"max-measured-value"});
        this.maxMeasuredValueRotate = new Rotate(180.0 - ((Gauge)this.getSkinnable()).getStartAngle());
        this.maxMeasuredValue.getTransforms().setAll((Object[])new Transform[]{this.maxMeasuredValueRotate});
        this.maxMeasuredValue.setOpacity(((Gauge)this.getSkinnable()).getMaxMeasuredValueVisible() ? 1.0 : 0.0);
        this.maxMeasuredValue.setManaged(((Gauge)this.getSkinnable()).getMaxMeasuredValueVisible());
        this.threshold = new Region();
        this.threshold.getStyleClass().setAll((Object[])new String[]{"threshold"});
        this.thresholdRotate = new Rotate(180.0 - ((Gauge)this.getSkinnable()).getStartAngle());
        this.threshold.getTransforms().setAll((Object[])new Transform[]{this.thresholdRotate});
        this.threshold.setOpacity(((Gauge)this.getSkinnable()).getThresholdVisible() ? 1.0 : 0.0);
        this.threshold.setManaged(((Gauge)this.getSkinnable()).getThresholdVisible());
        this.thresholdExceeded = false;
        this.needleRotate = new Rotate(180.0 - ((Gauge)this.getSkinnable()).getStartAngle() + ((Gauge)this.getSkinnable()).getCurrentValue() * this.angleStep);
        this.needle = new Region();
        this.needle.getStyleClass().setAll((Object[])new String[]{"needle-standard"});
        this.needle.getTransforms().add((Object)this.needleRotate);
        this.needle.setCache(true);
        this.needle.setCacheHint(CacheHint.SPEED);
        this.needleHighlight = new Region();
        this.needleHighlight.getStyleClass().setAll((Object[])new String[]{"needle-highlight"});
        this.needleHighlight.getTransforms().addAll((Object[])new Transform[]{this.needleRotate});
        this.needleHighlight.setCache(true);
        this.needleHighlight.setCacheHint(CacheHint.SPEED);
        this.knob = new Region();
        this.knob.setPickOnBounds(false);
        this.knob.getStyleClass().setAll((Object[])new String[]{"knob"});
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(3.15);
        this.dropShadow.setOffsetY(3.15);
        this.needleGroup = new Group(new Node[]{this.needle, this.needleHighlight});
        this.needleGroup.setEffect((Effect)(((Gauge)this.getSkinnable()).getDropShadowEnabled() ? this.dropShadow : null));
        this.needleGroup.setCache(true);
        this.needleGroup.setCacheHint(CacheHint.SPEED);
        this.title = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.title.setTextOrigin(VPos.CENTER);
        this.title.getStyleClass().setAll((Object[])new String[]{"title"});
        this.unit = new Text(((Gauge)this.getSkinnable()).getUnit());
        this.unit.setMouseTransparent(true);
        this.unit.setTextOrigin(VPos.CENTER);
        this.unit.getStyleClass().setAll((Object[])new String[]{"unit"});
        this.value = new Text(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", ((Gauge)this.getSkinnable()).getCurrentValue()));
        this.value.setMouseTransparent(true);
        this.value.setTextOrigin(VPos.CENTER);
        this.value.getStyleClass().setAll((Object[])new String[]{"value"});
        this.value.setEffect((Effect)(((Gauge)this.getSkinnable()).getPlainValue() ? null : this.valueBlend));
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.background, this.histogram, this.ticksAndSectionsCanvas, this.minMeasuredValue, this.maxMeasuredValue, this.threshold, this.title, this.needleGroup, this.knob, this.unit, this.value});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Gauge)this.getSkinnable()).currentValueProperty().addListener(observable -> this.handleControlPropertyChanged("VALUE"));
        ((Gauge)this.getSkinnable()).minValueProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((Gauge)this.getSkinnable()).maxValueProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((Gauge)this.getSkinnable()).minMeasuredValueProperty().addListener(observable -> this.handleControlPropertyChanged("MIN_MEASURED_VALUE"));
        ((Gauge)this.getSkinnable()).minMeasuredValueVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("MIN_MEASURED_VALUE_VISIBLE"));
        ((Gauge)this.getSkinnable()).maxMeasuredValueProperty().addListener(observable -> this.handleControlPropertyChanged("MAX_MEASURED_VALUE"));
        ((Gauge)this.getSkinnable()).maxMeasuredValueVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("MAX_MEASURED_VALUE_VISIBLE"));
        ((Gauge)this.getSkinnable()).tickLabelOrientationProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Gauge)this.getSkinnable()).thresholdProperty().addListener(observable -> this.handleControlPropertyChanged("THRESHOLD"));
        ((Gauge)this.getSkinnable()).thresholdVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("THRESHOLD_VISIBLE"));
        ((Gauge)this.getSkinnable()).angleRangeProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE_RANGE"));
        ((Gauge)this.getSkinnable()).plainValueProperty().addListener(observable -> this.handleControlPropertyChanged("PLAIN_VALUE"));
        ((Gauge)this.getSkinnable()).histogramEnabledProperty().addListener(observable -> this.handleControlPropertyChanged("HISTOGRAM"));
        ((Gauge)this.getSkinnable()).dropShadowEnabledProperty().addListener(observable -> this.handleControlPropertyChanged("DROP_SHADOW"));
        ((Gauge)this.getSkinnable()).getSections().addListener(change -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((Gauge)this.getSkinnable()).customTickLabelsEnabledProperty().addListener(observable1 -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((Gauge)this.getSkinnable()).valueFontProperty().addListener(observble -> this.handleControlPropertyChanged("VALUE_FONT"));
        this.needleRotate.angleProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE"));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("VALUE".equals(PROPERTY)) {
            this.rotateNeedle();
        } else if ("RECALC".equals(PROPERTY)) {
            if (((Gauge)this.getSkinnable()).getMinValue() < 0.0) {
                this.angleStep = ((Gauge)this.getSkinnable()).getAngleRange() / (((Gauge)this.getSkinnable()).getMaxValue() - ((Gauge)this.getSkinnable()).getMinValue());
                this.needleRotate.setAngle(180.0 - ((Gauge)this.getSkinnable()).getStartAngle() - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep);
            } else {
                this.angleStep = ((Gauge)this.getSkinnable()).getAngleRange() / (((Gauge)this.getSkinnable()).getMaxValue() + ((Gauge)this.getSkinnable()).getMinValue());
                this.needleRotate.setAngle(180.0 - ((Gauge)this.getSkinnable()).getStartAngle() * this.angleStep);
            }
            this.resize();
        } else if ("ANGLE".equals(PROPERTY)) {
            double currentValue = (this.needleRotate.getAngle() + ((Gauge)this.getSkinnable()).getStartAngle() - 180.0) / this.angleStep + ((Gauge)this.getSkinnable()).getMinValue();
            this.value.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", currentValue));
            this.value.setTranslateX((this.size - this.value.getLayoutBounds().getWidth()) * 0.5);
            if (this.thresholdExceeded) {
                if (currentValue < ((Gauge)this.getSkinnable()).getThreshold()) {
                    this.thresholdExceeded = false;
                }
            } else if (currentValue > ((Gauge)this.getSkinnable()).getThreshold()) {
                this.thresholdExceeded = true;
            }
            if (currentValue < ((Gauge)this.getSkinnable()).getMinMeasuredValue()) {
                ((Gauge)this.getSkinnable()).setMinMeasuredValue(currentValue);
                this.minMeasuredValueRotate.setAngle(currentValue * this.angleStep - 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep);
            }
            if (currentValue > ((Gauge)this.getSkinnable()).getMaxMeasuredValue()) {
                ((Gauge)this.getSkinnable()).setMaxMeasuredValue(currentValue);
                this.maxMeasuredValueRotate.setAngle(currentValue * this.angleStep - 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep);
            }
        } else if ("PLAIN_VALUE".equals(PROPERTY)) {
            this.value.setEffect((Effect)(((Gauge)this.getSkinnable()).getPlainValue() ? null : this.valueBlend));
        } else if ("HISTOGRAM".equals(PROPERTY)) {
            this.histogram.setVisible(((Gauge)this.getSkinnable()).getHistogramEnabled());
            this.histogram.setManaged(((Gauge)this.getSkinnable()).getHistogramEnabled());
        } else if ("DROP_SHADOW".equals(PROPERTY)) {
            this.needleGroup.setEffect((Effect)(((Gauge)this.getSkinnable()).getDropShadowEnabled() ? this.dropShadow : null));
        } else if ("CANVAS_REFRESH".equals(PROPERTY)) {
            this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
            this.drawSections(this.ticksAndSections);
            this.drawTickMarks(this.ticksAndSections);
        } else if ("THRESHOLD".equals(PROPERTY)) {
            this.thresholdRotate.setAngle(((Gauge)this.getSkinnable()).getThreshold() * this.angleStep - 180.0 - ((Gauge)this.getSkinnable()).getStartAngle());
        } else if ("THRESHOLD_VISIBLE".equals(PROPERTY)) {
            this.threshold.setOpacity(((Gauge)this.getSkinnable()).getThresholdVisible() ? 1.0 : 0.0);
            this.threshold.setManaged(((Gauge)this.getSkinnable()).getThresholdVisible());
        } else if ("MIN_MEASURED_VALUE_VISIBLE".equals(PROPERTY)) {
            this.minMeasuredValue.setOpacity(((Gauge)this.getSkinnable()).getMinMeasuredValueVisible() ? 1.0 : 0.0);
            this.minMeasuredValue.setManaged(((Gauge)this.getSkinnable()).getMinMeasuredValueVisible());
        } else if ("MAX_MEASURED_VALUE_VISIBLE".equals(PROPERTY)) {
            this.maxMeasuredValue.setOpacity(((Gauge)this.getSkinnable()).getMaxMeasuredValueVisible() ? 1.0 : 0.0);
            this.maxMeasuredValue.setManaged(((Gauge)this.getSkinnable()).getMaxMeasuredValueVisible());
        } else if ("VALUE_FONT".equals(PROPERTY)) {
            this.updateFonts();
        }
    }

    protected double computeMinWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinWidth(Math.max(20.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMinHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinHeight(Math.max(20.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxWidth(Math.min(1024.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxHeight(Math.min(1024.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefHeight = 210.0;
        if (HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, HEIGHT - TOP_INSET - BOTTOM_INSET);
        }
        return super.computePrefWidth(prefHeight, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefWidth = 210.0;
        if (WIDTH != -1.0) {
            prefWidth = Math.max(0.0, WIDTH - LEFT_INSET - RIGHT_INSET);
        }
        return super.computePrefHeight(prefWidth, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    private void rotateNeedle() {
        this.angleStep = ((Gauge)this.getSkinnable()).getAngleRange() / (((Gauge)this.getSkinnable()).getMaxValue() - ((Gauge)this.getSkinnable()).getMinValue());
        double TARGET_ANGLE = 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() + ((Gauge)this.getSkinnable()).getCurrentValue() * this.angleStep - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep;
        if (((Gauge)this.getSkinnable()).getAnimated()) {
            this.timeline.stop();
            KeyValue KEY_VALUE = new KeyValue((WritableValue)this.needleRotate.angleProperty(), (Object)TARGET_ANGLE, Interpolator.EASE_BOTH);
            KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)((Gauge)this.getSkinnable()).getAnimationDuration()), new KeyValue[]{KEY_VALUE});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
            this.timeline.play();
        } else {
            this.needleRotate.setAngle(TARGET_ANGLE);
        }
    }

    private void drawTickMarks(GraphicsContext CTX) {
        if (((Gauge)this.getSkinnable()).getHistogramEnabled()) {
            double step = 0.0;
            double OFFSET = 90.0 - ((Gauge)this.getSkinnable()).getStartAngle();
            double ANGLE_EXTEND = ((Gauge)this.getSkinnable()).getMaxValue() * this.angleStep;
            CTX.setStroke((Paint)Color.rgb((int)200, (int)200, (int)200));
            CTX.setLineWidth(this.size * 0.001);
            CTX.setLineCap(StrokeLineCap.BUTT);
            for (int i = 0; i < 5; ++i) {
                double xy = (this.size - (0.435 + step) * this.size) / 2.0;
                double wh = this.size * (0.435 + step);
                CTX.strokeArc(xy, xy, wh, wh, -OFFSET, -ANGLE_EXTEND, ArcType.OPEN);
                step += 0.075;
            }
        }
        double startAngle = ((Gauge)this.getSkinnable()).getStartAngle();
        double orthText = Gauge.TickLabelOrientation.ORTHOGONAL == ((Gauge)this.getSkinnable()).getTickLabelOrientation() ? 0.33 : 0.31;
        Point2D center = new Point2D(this.size * 0.5, this.size * 0.5);
        double angle = 0.0;
        double counter = ((Gauge)this.getSkinnable()).getMinValue();
        while ((double)Double.compare(counter, ((Gauge)this.getSkinnable()).getMaxValue()) <= 0.0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerMainPoint = new Point2D(center.getX() + this.size * 0.368 * sinValue, center.getY() + this.size * 0.368 * cosValue);
            Point2D innerMediumPoint = new Point2D(center.getX() + this.size * 0.388 * sinValue, center.getY() + this.size * 0.388 * cosValue);
            Point2D innerMinorPoint = new Point2D(center.getX() + this.size * 0.3975 * sinValue, center.getY() + this.size * 0.3975 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.size * 0.432 * sinValue, center.getY() + this.size * 0.432 * cosValue);
            Point2D textPoint = new Point2D(center.getX() + this.size * orthText * sinValue, center.getY() + this.size * orthText * cosValue);
            CTX.setStroke((Paint)this.TICK_AND_MARK_COLOR);
            if (BigDecimal.valueOf(counter).remainder(BigDecimal.valueOf(((Gauge)this.getSkinnable()).getMajorTickSpace())).equals(BigDecimal.valueOf(0.0))) {
                CTX.setLineWidth(this.size * 0.0055);
                CTX.strokeLine(innerMainPoint.getX(), innerMainPoint.getY(), outerPoint.getX(), outerPoint.getY());
                CTX.save();
                CTX.translate(textPoint.getX(), textPoint.getY());
                switch (((Gauge)this.getSkinnable()).getTickLabelOrientation()) {
                    case ORTHOGONAL: {
                        if ((360.0 - startAngle - angle) % 360.0 > 90.0 && (360.0 - startAngle - angle) % 360.0 < 270.0) {
                            CTX.rotate((180.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((360.0 - startAngle - angle) % 360.0);
                        break;
                    }
                    case TANGENT: {
                        if ((360.0 - startAngle - angle - 90.0) % 360.0 > 90.0 && (360.0 - startAngle - angle - 90.0) % 360.0 < 270.0) {
                            CTX.rotate((90.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((270.0 - startAngle - angle) % 360.0);
                        break;
                    }
                }
                CTX.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.045 * this.size)));
                CTX.setTextAlign(TextAlignment.CENTER);
                CTX.setTextBaseline(VPos.CENTER);
                CTX.setFill((Paint)this.TICK_AND_MARK_COLOR);
                if (((Gauge)this.getSkinnable()).getTicksRoundedToInteger()) {
                    CTX.fillText(Integer.toString((int)counter), 0.0, 0.0);
                } else {
                    CTX.fillText(Double.toString(counter), 0.0, 0.0);
                }
                CTX.restore();
            } else if (!BigDecimal.valueOf(((Gauge)this.getSkinnable()).getMinorTickSpace()).remainder(BigDecimal.valueOf(2.0)).equals(BigDecimal.valueOf(0.0)) && BigDecimal.valueOf(counter).remainder(BigDecimal.valueOf(5.0)).equals(BigDecimal.valueOf(0.0))) {
                CTX.setLineWidth(this.size * 0.0035);
                CTX.strokeLine(innerMediumPoint.getX(), innerMediumPoint.getY(), outerPoint.getX(), outerPoint.getY());
            } else if (BigDecimal.valueOf(counter).remainder(BigDecimal.valueOf(((Gauge)this.getSkinnable()).getMinorTickSpace())).equals(BigDecimal.valueOf(0.0))) {
                CTX.setLineWidth(this.size * 0.00225);
                CTX.strokeLine(innerMinorPoint.getX(), innerMinorPoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= this.angleStep * ((Gauge)this.getSkinnable()).getMinorTickSpace();
            counter = this.round(((Gauge)this.getSkinnable()).getMinorTickSpace() + counter, 1);
        }
    }

    private void drawSections(GraphicsContext CTX) {
        double xy = (this.size - 0.83 * this.size) / 2.0;
        double wh = this.size * 0.83;
        double MIN_VALUE = ((Gauge)this.getSkinnable()).getMinValue();
        double MAX_VALUE = ((Gauge)this.getSkinnable()).getMaxValue();
        double OFFSET = 90.0 - ((Gauge)this.getSkinnable()).getStartAngle();
        for (int i = 0; i < ((Gauge)this.getSkinnable()).getSections().size(); ++i) {
            Section SECTION = (Section)((Gauge)this.getSkinnable()).getSections().get(i);
            if (SECTION.getStart() > MAX_VALUE || SECTION.getStop() < MIN_VALUE) continue;
            double SECTION_START_ANGLE = SECTION.getStart() < MIN_VALUE && SECTION.getStop() < MAX_VALUE ? MIN_VALUE * this.angleStep : (SECTION.getStart() - MIN_VALUE) * this.angleStep;
            double SECTION_ANGLE_EXTEND = SECTION.getStop() > MAX_VALUE ? MAX_VALUE * this.angleStep : (SECTION.getStop() - SECTION.getStart()) * this.angleStep;
            CTX.save();
            CTX.setStroke((Paint)SECTION.getColor());
            CTX.setLineWidth(this.size * 0.037);
            CTX.setLineCap(StrokeLineCap.BUTT);
            CTX.strokeArc(xy, xy, wh, wh, -(OFFSET + SECTION_START_ANGLE), -SECTION_ANGLE_EXTEND, ArcType.OPEN);
            CTX.restore();
        }
    }

    private void resize() {
        this.size = ((Gauge)this.getSkinnable()).getWidth() < ((Gauge)this.getSkinnable()).getHeight() ? ((Gauge)this.getSkinnable()).getWidth() : ((Gauge)this.getSkinnable()).getHeight();
        this.valueBlendBottomShadow.setOffsetY(0.005 * this.size);
        this.valueBlendTopShadow.setOffsetY(0.005 * this.size);
        this.valueBlendTopShadow.setRadius(0.005 * this.size);
        this.dropShadow.setRadius(0.015 * this.size);
        this.dropShadow.setOffsetY(0.015 * this.size);
        this.background.setPrefSize(this.size, this.size);
        this.ticksAndSectionsCanvas.setWidth(this.size);
        this.ticksAndSectionsCanvas.setHeight(this.size);
        this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
        this.drawSections(this.ticksAndSections);
        this.drawTickMarks(this.ticksAndSections);
        this.ticksAndSectionsCanvas.setCache(true);
        this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
        this.minMeasuredValue.setPrefSize(0.03 * this.size, 0.03 * this.size);
        this.minMeasuredValue.relocate((this.size - this.minMeasuredValue.getPrefWidth()) * 0.5, this.size * 0.11);
        this.minMeasuredValueRotate.setPivotX(this.minMeasuredValue.getPrefWidth() * 0.5);
        this.minMeasuredValueRotate.setPivotY(this.size * 0.39);
        this.minMeasuredValueRotate.setAngle(((Gauge)this.getSkinnable()).getMinMeasuredValue() * this.angleStep - 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep);
        this.maxMeasuredValue.setPrefSize(0.03 * this.size, 0.03 * this.size);
        this.maxMeasuredValue.relocate((this.size - this.maxMeasuredValue.getPrefWidth()) * 0.5, this.size * 0.11);
        this.maxMeasuredValueRotate.setPivotX(this.maxMeasuredValue.getPrefWidth() * 0.5);
        this.maxMeasuredValueRotate.setPivotY(this.size * 0.39);
        this.maxMeasuredValueRotate.setAngle(((Gauge)this.getSkinnable()).getMaxMeasuredValue() * this.angleStep - 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep);
        this.threshold.setPrefSize(0.03 * this.size, 0.0275 * this.size);
        this.threshold.relocate((this.size - this.threshold.getPrefWidth()) * 0.5, this.size * 0.11);
        this.thresholdRotate.setPivotX(this.threshold.getPrefWidth() * 0.5);
        this.thresholdRotate.setPivotY(this.size * 0.39);
        this.thresholdRotate.setAngle(((Gauge)this.getSkinnable()).getThreshold() * this.angleStep - 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep);
        this.value.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", (this.needleRotate.getAngle() + ((Gauge)this.getSkinnable()).getStartAngle() - 180.0) / this.angleStep));
        this.needle.getStyleClass().clear();
        this.needle.getStyleClass().setAll((Object[])new String[]{"needle-standard"});
        this.needle.setPrefSize(this.size * 0.04, this.size * 0.425);
        this.needle.relocate((this.size - this.needle.getPrefWidth()) * 0.5, this.size * 0.5 - this.needle.getPrefHeight());
        this.needleRotate.setPivotX(this.needle.getPrefWidth() * 0.5);
        this.needleRotate.setPivotY(this.needle.getPrefHeight());
        this.needleHighlight.getStyleClass().clear();
        this.needleHighlight.getStyleClass().setAll((Object[])new String[]{"needle-highlight"});
        this.needleHighlight.setPrefSize(this.size * 0.04, this.size * 0.425);
        this.needleHighlight.setTranslateX((this.size - this.needle.getPrefWidth()) * 0.5);
        this.needleHighlight.setTranslateY(this.size * 0.5 - this.needle.getPrefHeight());
        this.knob.getStyleClass().clear();
        this.knob.getStyleClass().setAll((Object[])new String[]{"knob"});
        this.knob.setPrefSize(this.size * 0.4, this.size * 0.4);
        this.knob.setTranslateX((this.size - this.knob.getPrefWidth()) * 0.5);
        this.knob.setTranslateY((this.size - this.knob.getPrefHeight()) * 0.5);
        this.updateFonts();
    }

    private void updateFonts() {
        switch (((Gauge)this.getSkinnable()).getValueFont()) {
            case LCD: {
                this.currentValueFont = Font.font((String)Gauge.DisplayFont.LCD.getFontname(), (double)(this.size * 0.15));
                break;
            }
            case DIGITAL: {
                this.currentValueFont = Font.font((String)Gauge.DisplayFont.DIGITAL.getFontname(), (double)(this.size * 0.15));
                break;
            }
            case DIGITAL_BOLD: {
                this.currentValueFont = Font.font((String)Gauge.DisplayFont.DIGITAL_BOLD.getFontname(), (double)(this.size * 0.15));
                break;
            }
            case ELEKTRA: {
                this.currentValueFont = Font.font((String)Gauge.DisplayFont.ELEKTRA.getFontname(), (double)(this.size * 0.15));
                break;
            }
            default: {
                this.currentValueFont = Font.font((String)Gauge.DisplayFont.STANDARD.getFontname(), (FontWeight)FontWeight.NORMAL, (double)(this.size * 0.15));
            }
        }
        this.value.setFont(this.currentValueFont);
        this.value.setTranslateX((this.size - this.value.getLayoutBounds().getWidth()) * 0.5);
        this.value.setTranslateY(this.size * 0.5);
        this.title.setFont(Font.font((String)"Xolonium", (FontWeight)FontWeight.NORMAL, (double)(this.size * 0.05)));
        this.title.setTranslateX((this.size - this.title.getLayoutBounds().getWidth()) * 0.5);
        this.title.setTranslateY(this.size * 0.85);
        this.unit.setFont(Font.font((String)"Open Sans", (FontWeight)FontWeight.NORMAL, (double)(this.size * 0.05)));
        this.unit.setTranslateX((this.size - this.unit.getLayoutBounds().getWidth()) * 0.5);
        this.unit.setTranslateY(this.size * 0.6);
    }

    private double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

