/*
 * Decompiled with CFR 0.152.
 */
package com.eru.dynamo.control.skin;

import com.eru.dynamo.control.Generator;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.RotateTransition;
import javafx.animation.Timeline;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class GeneratorSkin
extends SkinBase<Generator> {
    private static final double PREFERRED_HEIGHT = 40.0;
    private static final double PREFERRED_WIDTH = 40.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double width;
    private double height;
    private double size;
    private double centerX;
    private double centerY;
    private static final float CIRCLE_FRAME_SIZE_FACTOR = 0.92f;
    private static final float SIN_CURVE_SIZE_FACTOR = 0.2f;
    private static final float NAME_TEXT_SIZE_FACTOR = 0.4f;
    private Region background;
    private Region circleFrame;
    private Region circleGears;
    private Region sinCurve;
    private Text nameText;
    private Pane pane;
    private RotateTransition rotateTransition;
    private Timeline blinkTimeline;
    private boolean isFrameVisible;

    public GeneratorSkin() {
        super((Control)new Generator());
    }

    public GeneratorSkin(Generator control) {
        super((Control)control);
        this.initDimension();
        this.initGraphics();
        this.registerListeners();
    }

    private void initDimension() {
        if (Double.compare(((Generator)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Generator)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Generator)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Generator)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Generator)this.getSkinnable()).getPrefWidth() > 0.0 && ((Generator)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Generator)this.getSkinnable()).setPrefSize(((Generator)this.getSkinnable()).getPrefWidth(), ((Generator)this.getSkinnable()).getPrefHeight());
            } else {
                ((Generator)this.getSkinnable()).setPrefSize(40.0, 40.0);
            }
        }
        if (Double.compare(((Generator)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Generator)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Generator)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((Generator)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Generator)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Generator)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.circleFrame = new Region();
        this.circleFrame.getStyleClass().setAll((Object[])new String[]{"circle-frame"});
        this.circleGears = new Region();
        this.circleGears.getStyleClass().setAll((Object[])new String[]{"circle-gears"});
        this.circleGears.setCache(true);
        this.circleGears.setCacheHint(CacheHint.SPEED);
        this.rotateTransition = new RotateTransition(Duration.millis((double)((Generator)this.getSkinnable()).getAnimationDuration()), (Node)this.circleGears);
        this.blinkTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.35), event -> this.circleFrame.setOpacity(this.circleFrame.getOpacity() == 0.0 ? 1.0 : 0.0), new KeyValue[0])});
        this.sinCurve = new Region();
        this.sinCurve.getStyleClass().setAll((Object[])new String[]{"sin-curve"});
        this.nameText = new Text(((Generator)this.getSkinnable()).getName());
        this.nameText.getStyleClass().setAll((Object[])new String[]{"name-text"});
        this.pane = new Pane(new Node[]{this.background, this.circleFrame, this.circleGears, this.sinCurve, this.nameText});
        this.getChildren().add((Object)this.pane);
        this.resize();
        this.updateStateAspect();
        this.updateAlarmStatus();
    }

    private void registerListeners() {
        ((Generator)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((Generator)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((Generator)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Generator)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Generator)this.getSkinnable()).stateProperty().addListener(observable -> this.handleControlPropertyChanged("STATE"));
        ((Generator)this.getSkinnable()).alarmedProperty().addListener(observable -> this.handleControlPropertyChanged("ALARMED"));
    }

    private void handleControlPropertyChanged(String PROPERTY) {
        switch (PROPERTY) {
            case "RESIZE": {
                this.resize();
                break;
            }
            case "STATE": {
                this.updateStateAspect();
                break;
            }
            case "COLOR": {
                break;
            }
            case "ALARMED": {
                this.updateAlarmStatus();
            }
        }
    }

    protected double computeMinWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinWidth(Math.max(5.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMinHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinHeight(Math.max(5.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxWidth(Math.min(1024.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxHeight(Math.min(1024.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefHeight = 40.0;
        if (HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, HEIGHT - TOP_INSET - BOTTOM_INSET);
        }
        return super.computePrefWidth(prefHeight, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefWidth = 40.0;
        if (WIDTH != -1.0) {
            prefWidth = Math.max(0.0, WIDTH - LEFT_INSET - RIGHT_INSET);
        }
        return super.computePrefHeight(prefWidth, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    private void resize() {
        this.width = ((Generator)this.getSkinnable()).getWidth();
        this.height = ((Generator)this.getSkinnable()).getHeight();
        if (this.width > 0.0 && this.height > 0.0) {
            this.size = ((Generator)this.getSkinnable()).getWidth() < ((Generator)this.getSkinnable()).getHeight() ? ((Generator)this.getSkinnable()).getWidth() : ((Generator)this.getSkinnable()).getHeight();
            this.centerX = this.size * 0.5;
            this.centerY = this.size * 0.5;
            this.background.setPrefSize(this.size, this.size);
            this.circleFrame.setPrefSize(this.size * (double)0.92f, this.size * (double)0.92f);
            this.circleFrame.setLayoutX(this.centerX - this.circleFrame.getPrefWidth() * 0.5);
            this.circleFrame.setLayoutY(this.centerY - this.circleFrame.getPrefHeight() * 0.5);
            this.circleGears.getStyleClass().clear();
            this.circleGears.getStyleClass().setAll((Object[])new String[]{"circle-gears"});
            this.circleGears.setPrefSize(this.size, this.size);
            this.sinCurve.setPrefSize(this.size * (double)0.2f, this.size * (double)0.2f * 0.8);
            this.sinCurve.setLayoutX(this.centerX - this.sinCurve.getPrefWidth() * 0.5);
            this.sinCurve.setLayoutY(this.size * 0.7);
            this.nameText.setText(((Generator)this.getSkinnable()).getName());
            this.nameText.setFont(Font.font((double)(this.size * (double)0.4f)));
            this.nameText.setX((this.size - this.nameText.getLayoutBounds().getWidth()) * 0.5);
            this.nameText.setY((this.size - this.nameText.getLayoutBounds().getHeight()) * 0.5);
            this.nameText.setTextOrigin(VPos.TOP);
        }
    }

    private void updateStateAspect() {
        switch (((Generator)this.getSkinnable()).getState()) {
            case OFF: {
                this.circleFrame.setStyle("-fx-background-color:-de-energized-color");
                this.circleGears.setStyle("-fx-background-color:TRANSPARENT");
                this.rotateTransition.stop();
                this.blinkTimeline.stop();
                break;
            }
            case PREGLOW: {
                this.circleFrame.setStyle("-fx-background-color:-starting-color");
                this.circleGears.setStyle("-fx-background-color:-starting-color");
                this.rotateTransition.stop();
                this.blinkTimeline.stop();
                break;
            }
            case CRANK: {
                this.circleFrame.setStyle("-fx-background-color:-starting-color");
                this.circleGears.setStyle("-fx-background-color:-starting-color");
                if (((Generator)this.getSkinnable()).getAnimated()) {
                    this.rotateTransition.stop();
                    this.rotateTransition.setDuration(Duration.millis((double)((Generator)this.getSkinnable()).getAnimationDuration()));
                    this.rotateTransition.setByAngle(360.0);
                    this.rotateTransition.setInterpolator(Interpolator.LINEAR);
                    this.rotateTransition.setCycleCount(-1);
                    this.rotateTransition.play();
                }
                this.blinkTimeline.stop();
                break;
            }
            case RUN: {
                this.circleFrame.setStyle("-fx-background-color:-energized-color");
                this.circleGears.setStyle("-fx-background-color:TRANSPARENT");
                this.rotateTransition.stop();
                this.blinkTimeline.stop();
                break;
            }
            case COOLDOWN: {
                this.circleFrame.setStyle("-fx-background-color:-starting-color");
                this.circleGears.setStyle("-fx-background-color:-starting-color");
                this.rotateTransition.stop();
                this.blinkTimeline.stop();
                break;
            }
            case RESTART: {
                break;
            }
            case FAILED: {
                this.circleFrame.setStyle("-fx-background-color:-failed-color");
                this.circleGears.setStyle("-fx-background-color:TRANSPARENT");
                this.rotateTransition.stop();
                this.blinkTimeline.setCycleCount(-1);
                this.blinkTimeline.play();
                break;
            }
            case UNKNOWN: {
                this.rotateTransition.stop();
                this.blinkTimeline.stop();
                this.circleFrame.setStyle("-fx-background-color:-unknown-color");
                this.circleGears.setStyle("-fx-background-color:TRANSPARENT");
                this.circleFrame.setOpacity(1.0);
            }
        }
    }

    private void updateAlarmStatus() {
        if (((Generator)this.getSkinnable()).getAlarmed()) {
            this.sinCurve.setStyle("-fx-background-color: -failed-color");
            this.nameText.setStyle("-fx-fill: -failed-color");
        } else {
            this.sinCurve.setStyle("-fx-background-color: -unknown-color");
            this.nameText.setStyle("-fx-fill: -name-text-fill");
        }
    }
}

