/*
 * Decompiled with CFR 0.152.
 */
package com.eru.dynamo.control.skin;

import com.eru.dynamo.control.LevelBar;
import com.eru.dynamo.fonts.Fonts;
import com.eru.dynamo.util.Section;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public class LevelBarSkin
extends SkinBase<LevelBar> {
    private static final double PREFERRED_WIDTH = 120.0;
    private static final double PREFERRED_HEIGHT = 200.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 10.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final DecimalFormat DEC_FORMAT = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private static final StringBuilder decBuffer = new StringBuilder(16);
    private static final double CURRENT_VALUE_FONT_SIZE_FACTOR = 0.16;
    private static final double TITLE_FONT_SIZE_FACTOR = 0.1;
    private static final double UNIT_FONT_SIZE_FACTOR = 0.07;
    private static final double LIMITS_FONT_SIZE_FACTOR = 0.078;
    private static final double BAR_WIDTH_FACTOR = 0.1;
    private final Timeline timeline = new Timeline();
    private double width;
    private double height;
    private double barWidth;
    private double barHeight;
    private Canvas sectionsCanvas;
    private GraphicsContext sections;
    private double barPosX;
    private double barPosY;
    private double offset;
    private double limitTextPosX;
    private Pane pane;
    private Region main;
    private Region frame;
    private Group currentValuePointerGroup;
    private Region currentValuePointer;
    private Text currentValueText;
    private Text titleText;
    private Text unitText;
    private double size;

    public LevelBarSkin() {
        super((Control)new LevelBar());
    }

    public LevelBarSkin(LevelBar control) {
        super((Control)control);
        this.initDimension();
        this.initGraphics();
        this.registerListeners();
    }

    private void initDimension() {
        if (Double.compare(((LevelBar)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((LevelBar)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((LevelBar)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((LevelBar)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((LevelBar)this.getSkinnable()).getPrefWidth() > 0.0 && ((LevelBar)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((LevelBar)this.getSkinnable()).setPrefSize(((LevelBar)this.getSkinnable()).getPrefWidth(), ((LevelBar)this.getSkinnable()).getPrefHeight());
            } else {
                ((LevelBar)this.getSkinnable()).setPrefSize(120.0, 200.0);
            }
        }
        if (Double.compare(((LevelBar)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((LevelBar)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((LevelBar)this.getSkinnable()).setMinSize(5.0, 10.0);
        }
        if (Double.compare(((LevelBar)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((LevelBar)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((LevelBar)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.main = new Region();
        this.main.getStyleClass().setAll((Object[])new String[]{"main"});
        this.frame = new Region();
        this.frame.getStyleClass().setAll((Object[])new String[]{"frame"});
        this.sectionsCanvas = new Canvas(this.width, this.barHeight);
        this.sections = this.sectionsCanvas.getGraphicsContext2D();
        this.currentValuePointer = new Region();
        this.currentValuePointer.getStyleClass().setAll((Object[])new String[]{"normal-current-value-pointer"});
        this.currentValuePointer.setPrefSize(50.0, 20.0);
        this.currentValuePointer.setCache(true);
        this.currentValuePointer.setCacheHint(CacheHint.SPEED);
        this.currentValueText = new Text(Double.toString(((LevelBar)this.getSkinnable()).getCurrentValue()));
        this.currentValueText.getStyleClass().setAll((Object[])new String[]{"current-value-text"});
        this.currentValueText.setCache(true);
        this.currentValueText.setCacheHint(CacheHint.SPEED);
        this.currentValuePointerGroup = new Group(new Node[]{this.currentValuePointer, this.currentValueText});
        this.currentValuePointerGroup.setCache(true);
        this.currentValuePointerGroup.setCacheHint(CacheHint.SPEED);
        this.titleText = new Text(((LevelBar)this.getSkinnable()).getTitle());
        this.titleText.getStyleClass().setAll((Object[])new String[]{"title"});
        this.unitText = new Text(((LevelBar)this.getSkinnable()).getUnit());
        this.unitText.getStyleClass().setAll((Object[])new String[]{"unit"});
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.main, this.frame, this.sectionsCanvas, this.unitText, this.titleText, this.currentValuePointerGroup});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
    }

    private void registerListeners() {
        ((LevelBar)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((LevelBar)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((LevelBar)this.getSkinnable()).currentValueProperty().addListener(observable -> this.handleControlPropertyChanged("CURRENT_VALUE"));
        ((LevelBar)this.getSkinnable()).textFillProperty().addListener(observable -> this.handleControlPropertyChanged("TEXT_FILL"));
        ((LevelBar)this.getSkinnable()).titleProperty().addListener(observable -> this.handleControlPropertyChanged("LABELS"));
        ((LevelBar)this.getSkinnable()).unitProperty().addListener(observable -> this.handleControlPropertyChanged("LABELS"));
        ((LevelBar)this.getSkinnable()).unitVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("VISIBILITY"));
    }

    private void handleControlPropertyChanged(String property) {
        switch (property) {
            case "RESIZE": {
                this.resize();
                break;
            }
            case "TEXT_FILL": {
                this.titleText.setFill(((LevelBar)this.getSkinnable()).getTextFill());
                this.currentValueText.setFill(((LevelBar)this.getSkinnable()).getTextFill());
                this.unitText.setFill(((LevelBar)this.getSkinnable()).getTextFill());
                break;
            }
            case "CURRENT_VALUE": {
                this.updatePointer();
                break;
            }
            case "VISIBILITY": {
                this.updateVisibleGraphics();
                break;
            }
        }
    }

    protected double computeMinWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinWidth(Math.max(10.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMinHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinHeight(Math.max(5.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxWidth(Math.min(1024.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxHeight(Math.min(1024.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefHeight = 200.0;
        if (HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, HEIGHT - TOP_INSET - BOTTOM_INSET);
        }
        return super.computePrefWidth(prefHeight, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefWidth = 120.0;
        if (WIDTH != -1.0) {
            prefWidth = Math.max(0.0, WIDTH - LEFT_INSET - RIGHT_INSET);
        }
        return super.computePrefHeight(prefWidth, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    private void resize() {
        this.width = ((LevelBar)this.getSkinnable()).getWidth();
        this.height = ((LevelBar)this.getSkinnable()).getHeight();
        double d = this.size = ((LevelBar)this.getSkinnable()).getWidth() < ((LevelBar)this.getSkinnable()).getHeight() ? ((LevelBar)this.getSkinnable()).getWidth() : ((LevelBar)this.getSkinnable()).getHeight();
        if (this.width > 0.0 && this.height > 0.0) {
            this.main.setPrefSize(this.width, this.height);
            this.titleText.setFont(Font.font((String)"Xolonium", (double)(this.width * 0.1)));
            this.titleText.setTextOrigin(VPos.TOP);
            this.titleText.setTextAlignment(TextAlignment.CENTER);
            this.titleText.setText(((LevelBar)this.getSkinnable()).getTitle());
            this.titleText.setX((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5);
            this.frame.setPrefSize(this.width, this.titleText.getLayoutBounds().getHeight());
            this.frame.setTranslateY(this.height - (this.height - this.titleText.getLayoutBounds().getHeight()));
            this.barWidth = this.width * 0.1;
            this.barHeight = (this.height - this.titleText.getLayoutBounds().getHeight()) * 0.95;
            this.unitText.setText(((LevelBar)this.getSkinnable()).getUnitVisible() ? ((LevelBar)this.getSkinnable()).getUnit() : "");
            this.unitText.setFont(Fonts.xoloniumBold(this.size * 0.07));
            this.unitText.setTextOrigin(VPos.BOTTOM);
            this.unitText.setTextAlignment(TextAlignment.RIGHT);
            this.unitText.setX(this.width - this.unitText.getLayoutBounds().getWidth());
            this.unitText.setY(this.titleText.getLayoutBounds().getHeight());
            this.sectionsCanvas.setWidth(this.width);
            this.sectionsCanvas.setHeight(this.barHeight);
            this.sectionsCanvas.setTranslateY(this.height - this.barHeight);
            this.sections.clearRect(0.0, 0.0, this.sectionsCanvas.getWidth(), this.sectionsCanvas.getHeight());
            this.drawSections();
            this.updatePointer();
        }
    }

    private void drawSections() {
        double MIN_VALUE = ((LevelBar)this.getSkinnable()).getMinValue();
        double MAX_VALUE = ((LevelBar)this.getSkinnable()).getMaxValue();
        double CANVAS_HEIGHT = this.sectionsCanvas.getHeight();
        double CANVAS_WIDTH = this.sectionsCanvas.getWidth();
        this.barPosX = CANVAS_WIDTH / 2.0 - this.barWidth / 2.0;
        this.barPosY = 0.0;
        this.offset = 0.0;
        this.limitTextPosX = (this.barPosX + this.barWidth) * 1.1;
        for (int i = 0; i < ((LevelBar)this.getSkinnable()).getSections().size(); ++i) {
            Section SECTION = (Section)((LevelBar)this.getSkinnable()).getSections().get(i);
            double rangeValue = SECTION.getStop() - SECTION.getStart();
            if (SECTION.getStart() > MAX_VALUE || SECTION.getStop() < MIN_VALUE) continue;
            double percentOfScaleRangeInScale = rangeValue / (MAX_VALUE - MIN_VALUE) * 100.0;
            double SECTION_HEIGHT = percentOfScaleRangeInScale * CANVAS_HEIGHT / 100.0;
            this.barPosY = this.offset;
            this.offset += SECTION_HEIGHT;
            this.sections.setStroke((Paint)SECTION.getColor());
            this.sections.setLineWidth(this.barWidth * 0.09);
            this.sections.strokeRect(this.barPosX, this.barPosY, this.barWidth, SECTION_HEIGHT);
            this.sections.beginPath();
            this.sections.moveTo(this.barPosX + this.barWidth, this.barPosY);
            this.sections.lineTo((this.barPosX + this.barWidth) * 1.1, this.barPosY);
            this.sections.stroke();
            if (SECTION.getStopVisible()) {
                this.sections.setFill((Paint)SECTION.getColor());
                this.sections.setFont(Fonts.xoloniumBold(this.size * 0.078));
                this.sections.setTextBaseline(i == 0 ? VPos.TOP : VPos.CENTER);
                this.sections.fillText(String.valueOf(SECTION.getStop()), this.limitTextPosX, this.barPosY, CANVAS_WIDTH / 2.0);
            }
            if (i != ((LevelBar)this.getSkinnable()).getSections().size() - 1) continue;
            double lastTextPosY = this.barPosY + SECTION_HEIGHT;
            this.sections.beginPath();
            this.sections.moveTo(this.barPosX + this.barWidth, lastTextPosY);
            this.sections.lineTo((this.barPosX + this.barWidth) * 1.1, lastTextPosY);
            this.sections.stroke();
            if (!SECTION.getStartVisible()) continue;
            this.sections.setTextBaseline(VPos.BOTTOM);
            this.sections.fillText(String.valueOf(SECTION.getStart()), this.limitTextPosX, lastTextPosY, CANVAS_WIDTH / 2.0);
        }
    }

    private void updatePointer() {
        double newPosition;
        this.currentValueText.setText(this.formatCurrentValue(((LevelBar)this.getSkinnable()).getCurrentValue(), ((LevelBar)this.getSkinnable()).getDecimals()));
        this.currentValueText.setFont(Font.font((String)"Digital-7", (double)(this.width * 0.16)));
        this.currentValueText.setTextOrigin(VPos.TOP);
        this.currentValueText.setTextAlignment(TextAlignment.RIGHT);
        this.currentValuePointer.getStyleClass().clear();
        this.currentValuePointer.getStyleClass().setAll((Object[])new String[]{"normal-current-value-pointer"});
        this.currentValuePointer.setPrefSize(this.currentValueText.getLayoutBounds().getWidth() * 1.1, this.currentValueText.getLayoutBounds().getHeight() * 1.1);
        this.currentValuePointerGroup.setTranslateX(this.width / 2.0 + this.barWidth / 2.0 - this.currentValuePointerGroup.getLayoutBounds().getWidth());
        double d = ((LevelBar)this.getSkinnable()).getCurrentValue() < ((LevelBar)this.getSkinnable()).getMinValue() ? this.height - this.currentValuePointerGroup.getLayoutBounds().getHeight() * 0.5 : (newPosition = ((LevelBar)this.getSkinnable()).getCurrentValue() > ((LevelBar)this.getSkinnable()).getMaxValue() ? this.height - this.barHeight - this.currentValuePointerGroup.getLayoutBounds().getHeight() * 0.5 : this.height - this.currentValuePointerGroup.getLayoutBounds().getHeight() * 0.5 - this.barHeight * (((LevelBar)this.getSkinnable()).getCurrentValue() - ((LevelBar)this.getSkinnable()).getMinValue()) / (((LevelBar)this.getSkinnable()).getMaxValue() - ((LevelBar)this.getSkinnable()).getMinValue()));
        if (((LevelBar)this.getSkinnable()).getAnimated()) {
            this.timeline.stop();
            KeyValue KEY_VALUE = new KeyValue((WritableValue)this.currentValuePointerGroup.translateYProperty(), (Object)newPosition, Interpolator.EASE_BOTH);
            KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)((LevelBar)this.getSkinnable()).getAnimationDuration()), new KeyValue[]{KEY_VALUE});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
            this.timeline.play();
        } else {
            this.currentValuePointerGroup.setTranslateY(newPosition);
        }
    }

    private void updateVisibleGraphics() {
        this.unitText.setText(((LevelBar)this.getSkinnable()).getUnitVisible() ? ((LevelBar)this.getSkinnable()).getUnit() : "");
    }

    private String formatCurrentValue(double VALUE, int DECIMALS) {
        decBuffer.setLength(0);
        decBuffer.append("0");
        if (DECIMALS > 0) {
            decBuffer.append(".");
        }
        for (int i = 0; i < DECIMALS; ++i) {
            decBuffer.append("0");
        }
        decBuffer.trimToSize();
        DEC_FORMAT.applyPattern(decBuffer.toString());
        return DEC_FORMAT.format(VALUE);
    }
}

