/*
 * Decompiled with CFR 0.152.
 */
package com.eru.dynamo.control.skin;

import com.eru.dynamo.control.Radial;
import com.eru.dynamo.fonts.Fonts;
import com.eru.dynamo.util.Section;
import java.time.Instant;
import java.util.Locale;
import java.util.stream.IntStream;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class RadialSkin
extends SkinBase<Radial>
implements Skin<Radial> {
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double PREFERRED_WIDTH = 200.0;
    private static final double PREFERRED_HEIGHT = 200.0;
    private double size;
    private double width;
    private double height;
    private Pane pane;
    private Region background;
    private Canvas ticksAndSectionsCanvas;
    private GraphicsContext ticksAndSections;
    private Text unitText;
    private Text titleText;
    private Region ledFrame;
    private Region ledMain;
    private Region ledHl;
    private Label lcdText;
    private Region needle;
    private Region needleColorBlock;
    private Region minPost;
    private Region maxPost;
    private Region knob;
    private Group shadowGroup;
    private Region foreground;
    private DropShadow dropShadow;
    private InnerShadow innerShadow;
    private DropShadow glow;
    private double oldValue;
    private double angleStep;
    private Timeline timeline;
    private String limitString;
    private Instant lastCall;
    private boolean withinSpeedLimit;
    private Rotate needleRotate;
    private Rotate needleColorBlockRotate;

    public RadialSkin() {
        super((Control)new Radial());
    }

    public RadialSkin(Radial CONTROL) {
        super((Control)CONTROL);
        this.angleStep = CONTROL.getAngleRange() / (CONTROL.getMaxValue() - CONTROL.getMinValue());
        this.timeline = new Timeline();
        this.oldValue = ((Radial)this.getSkinnable()).getValue();
        this.limitString = "";
        this.lastCall = Instant.now();
        this.withinSpeedLimit = true;
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((Radial)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Radial)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Radial)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Radial)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Radial)this.getSkinnable()).getPrefWidth() > 0.0 && ((Radial)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Radial)this.getSkinnable()).setPrefSize(((Radial)this.getSkinnable()).getPrefWidth(), ((Radial)this.getSkinnable()).getPrefHeight());
            } else {
                ((Radial)this.getSkinnable()).setPrefSize(200.0, 200.0);
            }
        }
        if (Double.compare(((Radial)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Radial)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Radial)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((Radial)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Radial)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Radial)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.ticksAndSectionsCanvas = new Canvas(200.0, 200.0);
        this.ticksAndSections = this.ticksAndSectionsCanvas.getGraphicsContext2D();
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 8.0, 0.0, 0.0, 0.0);
        this.glow = new DropShadow(BlurType.TWO_PASS_BOX, ((Radial)this.getSkinnable()).getLedColor(), 20.0, 0.0, 0.0, 0.0);
        this.glow.setInput((Effect)this.innerShadow);
        this.ledFrame = new Region();
        this.ledFrame.getStyleClass().setAll((Object[])new String[]{"led-frame"});
        this.ledMain = new Region();
        this.ledMain.getStyleClass().setAll((Object[])new String[]{"led-main"});
        this.ledMain.setStyle("-led-color: " + this.colorToCss(((Radial)this.getSkinnable()).getLedColor()) + ";");
        this.ledHl = new Region();
        this.ledHl.getStyleClass().setAll((Object[])new String[]{"led-hl"});
        this.titleText = new Text(((Radial)this.getSkinnable()).getTitle());
        this.titleText.getStyleClass().setAll((Object[])new String[]{"title"});
        this.unitText = new Text(((Radial)this.getSkinnable()).getUnit());
        this.unitText.getStyleClass().setAll((Object[])new String[]{"unit"});
        this.lcdText = new Label(((Radial)this.getSkinnable()).getNumberFormat().format(((Radial)this.getSkinnable()).getValue()));
        this.lcdText.getStyleClass().setAll((Object[])new String[]{"lcd-text"});
        this.needle = new Region();
        this.needle.getStyleClass().setAll((Object[])new String[]{"needle"});
        this.needleRotate = new Rotate(180.0 - ((Radial)this.getSkinnable()).getStartAngle());
        this.needleRotate.setAngle(this.needleRotate.getAngle() + (((Radial)this.getSkinnable()).getValue() - this.oldValue - ((Radial)this.getSkinnable()).getMinValue()) * this.angleStep);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needleColorBlock = new Region();
        this.needleColorBlock.getStyleClass().setAll((Object[])new String[]{"needle-color-block"});
        this.needleColorBlock.setStyle("-needle-color: " + this.colorToCss(((Radial)this.getSkinnable()).getNeedleColor()) + ";");
        this.needleColorBlockRotate = new Rotate(180.0 - ((Radial)this.getSkinnable()).getStartAngle());
        this.needleColorBlock.getTransforms().setAll((Object[])new Transform[]{this.needleColorBlockRotate});
        this.minPost = new Region();
        this.minPost.getStyleClass().setAll((Object[])new String[]{"post"});
        this.maxPost = new Region();
        this.maxPost.getStyleClass().setAll((Object[])new String[]{"post"});
        this.knob = new Region();
        this.knob.getStyleClass().setAll((Object[])new String[]{"knob"});
        this.shadowGroup = new Group(new Node[]{this.needle, this.minPost, this.maxPost, this.knob});
        this.dropShadow = new DropShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 2.5, 0.0, 0.0, 2.5);
        this.shadowGroup.setEffect((Effect)this.dropShadow);
        this.foreground = new Region();
        this.foreground.getStyleClass().setAll((Object[])new String[]{"foreground"});
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.background, this.ticksAndSectionsCanvas, this.unitText, this.titleText, this.ledFrame, this.ledMain, this.ledHl, this.lcdText, this.shadowGroup, this.needleColorBlock, this.foreground});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
    }

    private void registerListeners() {
        ((Radial)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Radial)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Radial)this.getSkinnable()).ledOnProperty().addListener(observable -> this.ledMain.setEffect((Effect)(((Radial)this.getSkinnable()).isLedOn() ? this.glow : this.innerShadow)));
        ((Radial)this.getSkinnable()).ledColorProperty().addListener(observable -> this.handleControlPropertyChanged("LED_COLOR"));
        ((Radial)this.getSkinnable()).ledVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Radial)this.getSkinnable()).lcdVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Radial)this.getSkinnable()).tickLabelOrientationProperty().addListener(observable -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((Radial)this.getSkinnable()).tickLabelFillProperty().addListener(observable -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((Radial)this.getSkinnable()).tickMarkFillProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Radial)this.getSkinnable()).needleColorProperty().addListener(observable -> this.handleControlPropertyChanged("NEEDLE_COLOR"));
        ((Radial)this.getSkinnable()).animatedProperty().addListener(observable -> this.handleControlPropertyChanged("ANIMATED"));
        ((Radial)this.getSkinnable()).numberFormatProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((Radial)this.getSkinnable()).unitProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Radial)this.getSkinnable()).titleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Radial)this.getSkinnable()).getSections().addListener(change -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((Radial)this.getSkinnable()).getAreas().addListener(change -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((Radial)this.getSkinnable()).valueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.withinSpeedLimit = !Instant.now().minusMillis((long)((Radial)this.getSkinnable()).getAnimationDuration()).isBefore(this.lastCall);
            this.lastCall = Instant.now();
            this.oldValue = OLD_VALUE.doubleValue();
            this.rotateNeedle();
        });
        ((Radial)this.getSkinnable()).minValueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStep = ((Radial)this.getSkinnable()).getAngleRange() / (((Radial)this.getSkinnable()).getMaxValue() - NEW_VALUE.doubleValue());
            this.needleRotate.setAngle(180.0 - ((Radial)this.getSkinnable()).getStartAngle() + (((Radial)this.getSkinnable()).getValue() - NEW_VALUE.doubleValue()) * this.angleStep);
            if (((Radial)this.getSkinnable()).getValue() < NEW_VALUE.doubleValue()) {
                ((Radial)this.getSkinnable()).setValue(NEW_VALUE.doubleValue());
                this.oldValue = NEW_VALUE.doubleValue();
            }
        });
        ((Radial)this.getSkinnable()).maxValueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStep = ((Radial)this.getSkinnable()).getAngleRange() / (NEW_VALUE.doubleValue() - ((Radial)this.getSkinnable()).getMinValue());
            this.needleRotate.setAngle(180.0 - ((Radial)this.getSkinnable()).getStartAngle() + (((Radial)this.getSkinnable()).getValue() - ((Radial)this.getSkinnable()).getMinValue()) * this.angleStep);
            if (((Radial)this.getSkinnable()).getValue() > NEW_VALUE.doubleValue()) {
                ((Radial)this.getSkinnable()).setValue(NEW_VALUE.doubleValue());
                this.oldValue = NEW_VALUE.doubleValue();
            }
        });
        this.needleRotate.angleProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE"));
        this.needleColorBlockRotate.angleProperty().bind((ObservableValue)this.needleRotate.angleProperty());
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("ANGLE".equals(PROPERTY)) {
            double currentValue = (this.needleRotate.getAngle() + ((Radial)this.getSkinnable()).getStartAngle() - 180.0) / this.angleStep + ((Radial)this.getSkinnable()).getMinValue();
            this.lcdText.setText(this.limitString + String.format(Locale.US, "%." + ((Radial)this.getSkinnable()).getDecimals() + "f", currentValue));
        } else if ("CANVAS_REFRESH".equals(PROPERTY)) {
            this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
            this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
            this.drawSections(this.ticksAndSections);
            this.drawAreas(this.ticksAndSections);
            this.drawTickMarks(this.ticksAndSections);
        } else if ("NEEDLE_COLOR".equals(PROPERTY)) {
            this.needle.setStyle("-needle-color: " + this.colorToCss(((Radial)this.getSkinnable()).getNeedleColor()) + ";");
        } else if ("LED_COLOR".equals(PROPERTY)) {
            this.ledMain.setStyle("-led-color: " + this.colorToCss(((Radial)this.getSkinnable()).getLedColor()));
            this.resize();
        }
    }

    private void drawTickMarks(GraphicsContext CTX) {
        CTX.setFont(Fonts.robotoLight(0.045 * this.size));
        CTX.setStroke(((Radial)this.getSkinnable()).getTickMarkFill());
        CTX.setFill(((Radial)this.getSkinnable()).getTickLabelFill());
        double startAngle = ((Radial)this.getSkinnable()).getStartAngle();
        double orthText = Radial.TickLabelOrientation.ORTHOGONAL == ((Radial)this.getSkinnable()).getTickLabelOrientation() ? 0.33 : 0.31;
        Point2D center = new Point2D(this.size * 0.5, this.size * 0.5);
        double angle = 0.0;
        double counter = ((Radial)this.getSkinnable()).getMinValue();
        while (Double.compare(counter, ((Radial)this.getSkinnable()).getMaxValue()) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerMainPoint = new Point2D(center.getX() + this.size * 0.36 * sinValue, center.getY() + this.size * 0.36 * cosValue);
            Point2D innerMediumPoint = new Point2D(center.getX() + this.size * 0.37 * sinValue, center.getY() + this.size * 0.37 * cosValue);
            Point2D innerMinorPoint = new Point2D(center.getX() + this.size * 0.38 * sinValue, center.getY() + this.size * 0.38 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.size * 0.39 * sinValue, center.getY() + this.size * 0.39 * cosValue);
            Point2D textPoint = new Point2D(center.getX() + this.size * orthText * sinValue, center.getY() + this.size * orthText * cosValue);
            if (counter % ((Radial)this.getSkinnable()).getMajorTickSpace() == 0.0) {
                CTX.setLineWidth(this.size * 0.0055);
                CTX.strokeLine(innerMainPoint.getX(), innerMainPoint.getY(), outerPoint.getX(), outerPoint.getY());
                CTX.save();
                CTX.translate(textPoint.getX(), textPoint.getY());
                switch (((Radial)this.getSkinnable()).getTickLabelOrientation()) {
                    case ORTHOGONAL: {
                        if ((360.0 - startAngle - angle) % 360.0 > 90.0 && (360.0 - startAngle - angle) % 360.0 < 270.0) {
                            CTX.rotate((180.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((360.0 - startAngle - angle) % 360.0);
                        break;
                    }
                    case TANGENT: {
                        if ((360.0 - startAngle - angle - 90.0) % 360.0 > 90.0 && (360.0 - startAngle - angle - 90.0) % 360.0 < 270.0) {
                            CTX.rotate((90.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((270.0 - startAngle - angle) % 360.0);
                        break;
                    }
                }
                CTX.setTextAlign(TextAlignment.CENTER);
                CTX.setTextBaseline(VPos.CENTER);
                CTX.fillText(Integer.toString((int)counter), 0.0, 0.0);
                CTX.restore();
            } else if (((Radial)this.getSkinnable()).getMinorTickSpace() % 2.0 != 0.0 && counter % 5.0 == 0.0) {
                CTX.setLineWidth(this.size * 0.0035);
                CTX.strokeLine(innerMediumPoint.getX(), innerMediumPoint.getY(), outerPoint.getX(), outerPoint.getY());
            } else if (counter % ((Radial)this.getSkinnable()).getMinorTickSpace() == 0.0) {
                CTX.setLineWidth(this.size * 0.00225);
                CTX.strokeLine(innerMinorPoint.getX(), innerMinorPoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= this.angleStep;
            counter += 1.0;
        }
    }

    private final void drawSections(GraphicsContext CTX) {
        double xy = (this.size - 0.75 * this.size) / 2.0;
        double wh = this.size * 0.75;
        double MIN_VALUE = ((Radial)this.getSkinnable()).getMinValue();
        double MAX_VALUE = ((Radial)this.getSkinnable()).getMaxValue();
        double OFFSET = 90.0 - ((Radial)this.getSkinnable()).getStartAngle();
        IntStream.range(0, ((Radial)this.getSkinnable()).getSections().size()).parallel().forEachOrdered(i -> {
            Section SECTION = (Section)((Radial)this.getSkinnable()).getSections().get(i);
            if (Double.compare(SECTION.getStart(), MAX_VALUE) <= 0 && Double.compare(SECTION.getStop(), MIN_VALUE) >= 0) {
                double SECTION_START_ANGLE = SECTION.getStart() < MIN_VALUE && SECTION.getStop() < MAX_VALUE ? MIN_VALUE * this.angleStep : (SECTION.getStart() - MIN_VALUE) * this.angleStep;
                double SECTION_ANGLE_EXTEND = SECTION.getStop() > MAX_VALUE ? MAX_VALUE * this.angleStep : (SECTION.getStop() - SECTION.getStart()) * this.angleStep;
                CTX.save();
                switch (i) {
                    case 0: {
                        CTX.setStroke((Paint)((Radial)this.getSkinnable()).getSectionFill0());
                        break;
                    }
                    case 1: {
                        CTX.setStroke((Paint)((Radial)this.getSkinnable()).getSectionFill1());
                        break;
                    }
                    case 2: {
                        CTX.setStroke((Paint)((Radial)this.getSkinnable()).getSectionFill2());
                        break;
                    }
                    case 3: {
                        CTX.setStroke((Paint)((Radial)this.getSkinnable()).getSectionFill3());
                        break;
                    }
                    case 4: {
                        CTX.setStroke((Paint)((Radial)this.getSkinnable()).getSectionFill4());
                        break;
                    }
                    case 5: {
                        CTX.setStroke((Paint)((Radial)this.getSkinnable()).getSectionFill5());
                        break;
                    }
                    case 6: {
                        CTX.setStroke((Paint)((Radial)this.getSkinnable()).getSectionFill6());
                        break;
                    }
                    case 7: {
                        CTX.setStroke((Paint)((Radial)this.getSkinnable()).getSectionFill7());
                        break;
                    }
                    case 8: {
                        CTX.setStroke((Paint)((Radial)this.getSkinnable()).getSectionFill8());
                        break;
                    }
                    case 9: {
                        CTX.setStroke((Paint)((Radial)this.getSkinnable()).getSectionFill9());
                    }
                }
                CTX.setLineWidth(this.size * 0.037);
                CTX.setLineCap(StrokeLineCap.BUTT);
                CTX.strokeArc(xy, xy, wh, wh, -(OFFSET + SECTION_START_ANGLE), -SECTION_ANGLE_EXTEND, ArcType.OPEN);
                CTX.restore();
            }
        });
    }

    private final void drawAreas(GraphicsContext CTX) {
        double xy = (this.size - 0.7925 * this.size) / 2.0;
        double wh = this.size * 0.7925;
        double MIN_VALUE = ((Radial)this.getSkinnable()).getMinValue();
        double MAX_VALUE = ((Radial)this.getSkinnable()).getMaxValue();
        double OFFSET = 90.0 - ((Radial)this.getSkinnable()).getStartAngle();
        IntStream.range(0, ((Radial)this.getSkinnable()).getAreas().size()).parallel().forEachOrdered(i -> {
            Section AREA = (Section)((Radial)this.getSkinnable()).getAreas().get(i);
            if (Double.compare(AREA.getStart(), MAX_VALUE) <= 0 && Double.compare(AREA.getStop(), MIN_VALUE) >= 0) {
                double AREA_START_ANGLE = AREA.getStart() < MIN_VALUE && AREA.getStop() < MAX_VALUE ? MIN_VALUE * this.angleStep : (AREA.getStart() - MIN_VALUE) * this.angleStep;
                double AREA_ANGLE_EXTEND = AREA.getStop() > MAX_VALUE ? MAX_VALUE * this.angleStep : (AREA.getStop() - AREA.getStart()) * this.angleStep;
                CTX.save();
                switch (i) {
                    case 0: {
                        CTX.setFill((Paint)((Radial)this.getSkinnable()).getAreaFill0());
                        break;
                    }
                    case 1: {
                        CTX.setFill((Paint)((Radial)this.getSkinnable()).getAreaFill1());
                        break;
                    }
                    case 2: {
                        CTX.setFill((Paint)((Radial)this.getSkinnable()).getAreaFill2());
                        break;
                    }
                    case 3: {
                        CTX.setFill((Paint)((Radial)this.getSkinnable()).getAreaFill3());
                        break;
                    }
                    case 4: {
                        CTX.setFill((Paint)((Radial)this.getSkinnable()).getAreaFill4());
                        break;
                    }
                    case 5: {
                        CTX.setFill((Paint)((Radial)this.getSkinnable()).getAreaFill5());
                        break;
                    }
                    case 6: {
                        CTX.setFill((Paint)((Radial)this.getSkinnable()).getAreaFill6());
                        break;
                    }
                    case 7: {
                        CTX.setFill((Paint)((Radial)this.getSkinnable()).getAreaFill7());
                        break;
                    }
                    case 8: {
                        CTX.setFill((Paint)((Radial)this.getSkinnable()).getAreaFill8());
                        break;
                    }
                    case 9: {
                        CTX.setFill((Paint)((Radial)this.getSkinnable()).getAreaFill9());
                    }
                }
                CTX.fillArc(xy, xy, wh, wh, -(OFFSET + AREA_START_ANGLE), -AREA_ANGLE_EXTEND, ArcType.ROUND);
                CTX.restore();
            }
        });
    }

    private void rotateNeedle() {
        this.timeline.stop();
        this.angleStep = ((Radial)this.getSkinnable()).getAngleRange() / (((Radial)this.getSkinnable()).getMaxValue() - ((Radial)this.getSkinnable()).getMinValue());
        double targetAngle = 180.0 - ((Radial)this.getSkinnable()).getStartAngle() + ((Radial)this.getSkinnable()).getValue() * this.angleStep;
        targetAngle = ((Radial)this.getSkinnable()).clamp(180.0 - ((Radial)this.getSkinnable()).getStartAngle(), 180.0 - ((Radial)this.getSkinnable()).getStartAngle() + ((Radial)this.getSkinnable()).getAngleRange(), targetAngle);
        if (this.withinSpeedLimit && ((Radial)this.getSkinnable()).isAnimated()) {
            KeyValue KEY_VALUE = new KeyValue((WritableValue)this.needleRotate.angleProperty(), (Object)targetAngle, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
            KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)((Radial)this.getSkinnable()).getAnimationDuration()), new KeyValue[]{KEY_VALUE});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
            this.timeline.play();
        } else {
            this.needleRotate.setAngle(targetAngle);
        }
    }

    private String colorToCss(Color COLOR) {
        return COLOR.toString().replace("0x", "#");
    }

    private void resize() {
        this.width = this.size = ((Radial)this.getSkinnable()).getWidth() < ((Radial)this.getSkinnable()).getHeight() ? ((Radial)this.getSkinnable()).getWidth() : ((Radial)this.getSkinnable()).getHeight();
        this.height = this.size;
        if (this.size > 0.0) {
            this.dropShadow.setRadius(0.0125 * this.size);
            this.dropShadow.setOffsetY(0.0125 * this.size);
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((Radial)this.getSkinnable()).getWidth() - this.size) * 0.5, (((Radial)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.background.setStyle("-fx-background-insets: 0, " + 0.005 * this.size + ", " + ((Radial)this.getSkinnable()).getFrameSizeFactor() * this.size + ";");
            this.background.setPrefSize(this.width, this.height);
            this.ticksAndSectionsCanvas.setWidth(this.size);
            this.ticksAndSectionsCanvas.setHeight(this.size);
            this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
            if (((Radial)this.getSkinnable()).isSectionsVisible()) {
                this.drawSections(this.ticksAndSections);
            }
            if (((Radial)this.getSkinnable()).isAreasVisible()) {
                this.drawAreas(this.ticksAndSections);
            }
            this.drawTickMarks(this.ticksAndSections);
            this.ticksAndSectionsCanvas.setCache(true);
            this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
            this.innerShadow.setRadius(0.01 * this.size);
            this.glow.setRadius(0.05 * this.size);
            this.glow.setColor(((Radial)this.getSkinnable()).getLedColor());
            this.ledFrame.setPrefSize(0.06 * this.width, 0.06 * this.height);
            this.ledFrame.relocate(0.61 * this.width, 0.415 * this.height);
            this.ledMain.setPrefSize(0.045 * this.width, 0.045 * this.height);
            this.ledMain.relocate(0.62 * this.width, 0.425 * this.height);
            this.ledHl.setPrefSize(0.035 * this.width, 0.035 * this.height);
            this.ledHl.relocate(0.625 * this.width, 0.43 * this.height);
            boolean ledVisible = ((Radial)this.getSkinnable()).isLedVisible();
            this.ledFrame.setManaged(ledVisible);
            this.ledFrame.setVisible(ledVisible);
            this.ledMain.setManaged(ledVisible);
            this.ledMain.setVisible(ledVisible);
            this.ledHl.setManaged(ledVisible);
            this.ledHl.setVisible(ledVisible);
            this.needle.setPrefSize(0.055 * this.width, 0.48 * this.height);
            this.needle.relocate((this.size - this.needle.getPrefWidth()) * 0.5, 0.125 * this.size);
            this.needleRotate.setPivotX(0.5 * this.needle.getPrefWidth());
            this.needleRotate.setPivotY(0.77083 * this.needle.getPrefHeight());
            this.needleColorBlock.setPrefSize(0.012 * this.size, 0.095 * this.size);
            this.needleColorBlock.relocate((this.size - this.needleColorBlock.getPrefWidth()) * 0.5, 0.13 * this.size);
            this.needleColorBlockRotate.setPivotX(0.5 * this.needleColorBlock.getPrefWidth());
            this.needleColorBlockRotate.setPivotY(0.765 * this.needle.getPrefHeight());
            this.minPost.setStyle("-fx-background-insets: 0, " + 0.0025 * this.size + ", " + 0.0025 * this.size + ", " + 0.0025 * this.size + ";-fx-padding: 0, 0, -" + 8.0E-4 * this.size + "0 0 0, 0 0 " + 8.0E-4 * this.size + "0;");
            this.minPost.setPrefSize(0.04 * this.width, 0.04 * this.height);
            this.minPost.relocate(0.335 * this.width, 0.805 * this.height);
            this.maxPost.setStyle("-fx-background-insets: 0, " + 0.0025 * this.size + ", " + 0.0025 * this.size + ", " + 0.0025 * this.size + ";-fx-padding: 0, 0, -" + 8.0E-4 * this.size + "0 0 0, 0 0 " + 8.0E-4 * this.size + "0;");
            this.maxPost.setPrefSize(0.04 * this.width, 0.04 * this.height);
            this.maxPost.relocate(0.625 * this.width, 0.805 * this.height);
            this.knob.setStyle("-fx-background-insets: 0, " + 0.0075 * this.size + ", " + 0.0075 * this.size + ", " + 0.0075 * this.size + ";-fx-padding: 0, 0, -" + 0.0016 * this.size + "0 0 0, 0 0 " + 0.0016 * this.size + "0;");
            this.knob.setPrefSize(0.08 * this.width, 0.08 * this.height);
            this.knob.relocate(0.455 * this.width, 0.46 * this.height);
            this.foreground.setPrefSize(0.595 * this.width, 0.28 * this.height);
            this.foreground.setTranslateX(0.2025 * this.width);
            this.foreground.setTranslateY(0.11 * this.height);
            this.resizeText();
        }
    }

    private void resizeText() {
        this.titleText.setFont(Fonts.robotoRegular(0.06 * this.size));
        this.titleText.relocate((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.33);
        this.unitText.setFont(Fonts.robotoRegular(0.05 * this.size));
        this.unitText.relocate((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.405);
        this.lcdText.setStyle("-fx-background-radius: " + 0.0125 * this.size + ";");
        this.lcdText.setFont(Fonts.robotoRegular(this.size * 0.08));
        this.lcdText.setPrefSize(0.375 * this.size, 0.015 * this.size);
        this.lcdText.relocate((this.size - this.lcdText.getPrefWidth()) * 0.5, 0.58 * this.size);
        boolean lcdVisible = ((Radial)this.getSkinnable()).isLcdVisible();
        this.lcdText.setManaged(lcdVisible);
        this.lcdText.setVisible(lcdVisible);
    }
}

