/*
 * Decompiled with CFR 0.152.
 */
package com.eru.dynamo.control.skin;

import com.eru.dynamo.control.Switch;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;

public class SwitchSkin
extends SkinBase<Switch> {
    private static final double PREFERRED_HEIGHT = 40.0;
    private static final double PREFERRED_WIDTH = 40.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double BAR_WIDTH_SIZE_FACTOR = 0.1;
    private static final double BAR_HEIGHT_SIZE_FACTOR = 0.25;
    private static final double NAME_TEXT_SIZE_FACTOR = 0.5;
    private static double angleInOpenPosition;
    private static final double ANGLE_IN_CLOSED_POSITION = 180.0;
    private final Timeline timeline = new Timeline();
    private double width;
    private double height;
    private double size;
    private double centerX;
    private double centerY;
    private double barWidth;
    private double barHeight;
    private double mobileBarHeight;
    private double xDistanceToCenterBar;
    private Region background;
    private Region upBar;
    private Region downBar;
    private Region mobileBar;
    private Text name;
    private Pane pane;
    private Rotate barRotate;

    public SwitchSkin() {
        super((Control)new Switch());
    }

    public SwitchSkin(Switch control) {
        super((Control)control);
        this.initDimension();
        this.initGraphics();
        this.registerListeners();
    }

    private void initDimension() {
        if (Double.compare(((Switch)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Switch)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Switch)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Switch)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Switch)this.getSkinnable()).getPrefWidth() > 0.0 && ((Switch)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Switch)this.getSkinnable()).setPrefSize(((Switch)this.getSkinnable()).getPrefWidth(), ((Switch)this.getSkinnable()).getPrefHeight());
            } else {
                ((Switch)this.getSkinnable()).setPrefSize(40.0, 40.0);
            }
        }
        if (Double.compare(((Switch)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Switch)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Switch)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((Switch)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Switch)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Switch)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.upBar = new Region();
        this.upBar.getStyleClass().setAll((Object[])new String[]{"up-bar"});
        this.downBar = new Region();
        this.downBar.getStyleClass().setAll((Object[])new String[]{"down-bar"});
        this.barRotate = new Rotate(180.0);
        this.mobileBar = new Region();
        this.mobileBar.getStyleClass().setAll((Object[])new String[]{"mobile-bar"});
        this.mobileBar.getTransforms().add((Object)this.barRotate);
        this.name = new Text(((Switch)this.getSkinnable()).getName());
        this.name.getStyleClass().setAll((Object[])new String[]{"name-text"});
        this.pane = new Pane(new Node[]{this.background, this.upBar, this.downBar, this.mobileBar, this.name});
        this.getChildren().add((Object)this.pane);
        this.resize();
    }

    private void registerListeners() {
        ((Switch)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Switch)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Switch)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Switch)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Switch)this.getSkinnable()).energizedProperty().addListener(observable -> this.handleControlPropertyChanged("ENERGIZED"));
        ((Switch)this.getSkinnable()).closedProperty().addListener(observable -> this.handleControlPropertyChanged("CLOSED"));
    }

    private void handleControlPropertyChanged(String PROPERTY) {
        switch (PROPERTY) {
            case "RESIZE": {
                this.resize();
                break;
            }
            case "ENERGIZED": {
                this.updateState();
                break;
            }
            case "CLOSED": {
                this.updateState();
            }
        }
    }

    protected double computeMinWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinWidth(Math.max(5.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMinHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinHeight(Math.max(5.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxWidth(Math.min(1024.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxHeight(Math.min(1024.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefHeight = 40.0;
        if (HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, HEIGHT - TOP_INSET - BOTTOM_INSET);
        }
        return super.computePrefWidth(prefHeight, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefWidth = 40.0;
        if (WIDTH != -1.0) {
            prefWidth = Math.max(0.0, WIDTH - LEFT_INSET - RIGHT_INSET);
        }
        return super.computePrefHeight(prefWidth, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    private void resize() {
        this.width = ((Switch)this.getSkinnable()).getWidth();
        this.height = ((Switch)this.getSkinnable()).getHeight();
        if (this.width > 0.0 && this.height > 0.0) {
            this.centerX = this.width * 0.5;
            this.centerY = this.height * 0.5;
            this.barWidth = this.width * 0.1;
            this.barHeight = this.height * 0.25;
            this.barWidth = this.barWidth > this.barHeight ? this.barHeight : this.barWidth;
            this.mobileBarHeight = this.height - this.barHeight * 2.0;
            this.xDistanceToCenterBar = this.centerX - this.barWidth / 2.0;
            this.background.setPrefSize(this.width, this.height);
            this.upBar.setPrefSize(this.barWidth, this.barHeight);
            this.upBar.setTranslateX(this.xDistanceToCenterBar);
            this.upBar.setTranslateY(0.0);
            this.mobileBar.setPrefSize(this.barWidth, this.mobileBarHeight);
            this.mobileBar.setTranslateX(this.xDistanceToCenterBar + this.barWidth);
            this.mobileBar.setTranslateY(this.height - this.barHeight);
            angleInOpenPosition = 180.0 + Math.toDegrees(Math.atan(this.barWidth / this.mobileBarHeight)) * 3.0;
            this.downBar.setPrefSize(this.barWidth, this.barHeight);
            this.downBar.setTranslateX(this.xDistanceToCenterBar);
            this.downBar.setTranslateY(this.height - this.barHeight);
            this.name.setText(((Switch)this.getSkinnable()).getName());
            this.name.setFont(Font.font((double)(this.size * 0.5)));
            this.name.setX((this.size - this.name.getLayoutBounds().getWidth()) * 0.5);
            this.name.setY((this.size - this.name.getLayoutBounds().getHeight()) * 0.5);
            this.name.setTextOrigin(VPos.TOP);
            this.updateState();
        }
    }

    private void updateState() {
        this.upBar.setStyle(((Switch)this.getSkinnable()).getEnergized() ? "-fx-background-color:-energized-color" : "-fx-background-color:-de-energized-color");
        this.downBar.setStyle(((Switch)this.getSkinnable()).getEnergized() ? "-fx-background-color:-energized-color" : "-fx-background-color:-de-energized-color");
        this.mobileBar.setStyle(((Switch)this.getSkinnable()).getEnergized() ? "-fx-background-color:-energized-color" : "-fx-background-color:-de-energized-color");
        if (((Switch)this.getSkinnable()).getAnimated()) {
            this.timeline.stop();
            KeyValue KEY_VALUE = new KeyValue((WritableValue)this.barRotate.angleProperty(), (Object)(((Switch)this.getSkinnable()).getClosed() ? 180.0 : angleInOpenPosition), Interpolator.EASE_BOTH);
            KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)((Switch)this.getSkinnable()).getAnimationDuration()), new KeyValue[]{KEY_VALUE});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
            this.timeline.play();
        } else {
            this.barRotate.setAngle(((Switch)this.getSkinnable()).getClosed() ? 180.0 : angleInOpenPosition);
        }
    }
}

