/*
 * Decompiled with CFR 0.152.
 */
package com.eru.dynamo.control.skin;

import com.eru.dynamo.control.Transformer;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class TransformerSkin
extends SkinBase<Transformer> {
    private static final double PREFERRED_HEIGHT = 40.0;
    private static final double PREFERRED_WIDTH = 40.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double NAME_TEXT_SIZE_FACTOR = 0.5;
    private double width;
    private double height;
    private double size;
    private Region background;
    private Region transformer;
    private Text name;
    private Pane pane;

    public TransformerSkin() {
        super((Control)new Transformer());
    }

    public TransformerSkin(Transformer control) {
        super((Control)control);
        this.initDimension();
        this.initGraphics();
        this.registerListeners();
    }

    private void initDimension() {
        if (Double.compare(((Transformer)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Transformer)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Transformer)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Transformer)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Transformer)this.getSkinnable()).getPrefWidth() > 0.0 && ((Transformer)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Transformer)this.getSkinnable()).setPrefSize(((Transformer)this.getSkinnable()).getPrefWidth(), ((Transformer)this.getSkinnable()).getPrefHeight());
            } else {
                ((Transformer)this.getSkinnable()).setPrefSize(40.0, 40.0);
            }
        }
        if (Double.compare(((Transformer)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Transformer)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Transformer)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((Transformer)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Transformer)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Transformer)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.transformer = new Region();
        this.transformer.getStyleClass().addAll((Object[])new String[]{"transformer-shape"});
        this.name = new Text(((Transformer)this.getSkinnable()).getName());
        this.name.getStyleClass().setAll((Object[])new String[]{"name-text"});
        this.pane = new Pane(new Node[]{this.background, this.transformer, this.name});
        this.getChildren().add((Object)this.pane);
        this.resize();
    }

    private void registerListeners() {
        ((Transformer)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Transformer)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Transformer)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Transformer)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Transformer)this.getSkinnable()).energizedProperty().addListener(observable -> this.handleControlPropertyChanged("ENERGIZED"));
    }

    private void handleControlPropertyChanged(String PROPERTY) {
        switch (PROPERTY) {
            case "RESIZE": {
                this.resize();
                break;
            }
            case "ENERGIZED": {
                this.updateState();
            }
        }
    }

    protected double computeMinWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinWidth(Math.max(5.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMinHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinHeight(Math.max(5.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxWidth(Math.min(1024.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxHeight(Math.min(1024.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefHeight = 40.0;
        if (HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, HEIGHT - TOP_INSET - BOTTOM_INSET);
        }
        return super.computePrefWidth(prefHeight, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefWidth = 40.0;
        if (WIDTH != -1.0) {
            prefWidth = Math.max(0.0, WIDTH - LEFT_INSET - RIGHT_INSET);
        }
        return super.computePrefHeight(prefWidth, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    private void resize() {
        this.width = ((Transformer)this.getSkinnable()).getWidth();
        this.height = ((Transformer)this.getSkinnable()).getHeight();
        if (this.width > 0.0 && this.height > 0.0) {
            this.size = ((Transformer)this.getSkinnable()).getWidth() < ((Transformer)this.getSkinnable()).getHeight() ? ((Transformer)this.getSkinnable()).getWidth() : ((Transformer)this.getSkinnable()).getHeight();
            this.background.setPrefSize(this.width, this.height);
            this.transformer.setPrefSize(this.width, this.height);
            this.name.setText(((Transformer)this.getSkinnable()).getName());
            this.name.setFont(Font.font((double)(this.size * 0.5)));
            this.name.setX((this.size - this.name.getLayoutBounds().getWidth()) * 0.5);
            this.name.setY((this.size - this.name.getLayoutBounds().getHeight()) * 0.5);
            this.name.setTextOrigin(VPos.TOP);
            this.updateState();
        }
    }

    private void updateState() {
        this.transformer.setStyle(((Transformer)this.getSkinnable()).getEnergized() ? "-fx-background-color:-energized-color" : "-fx-background-color:-de-energized-color");
    }
}

