/*
 * Decompiled with CFR 0.152.
 */
package com.eru.dynamo.util;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class Section {
    private final DoubleProperty start;
    private final BooleanProperty startVisible;
    private final DoubleProperty stop;
    private final BooleanProperty stopVisible;
    private final StringProperty text;
    private final ObjectProperty<Color> color;
    private final ObjectProperty<Image> icon;
    private final StringProperty styleClass;

    public Section() {
        this(-1.0, -1.0);
    }

    public Section(double START, double STOP) {
        this(START, STOP, "");
    }

    public Section(double START, double STOP, String TEXT) {
        this(START, STOP, TEXT, Color.DARKRED);
    }

    public Section(double START, double STOP, String TEXT, Color color) {
        this(START, STOP, TEXT, color, null);
    }

    public Section(double START, double STOP, String TEXT, Color color, Image ICON) {
        this(START, STOP, TEXT, color, ICON, "");
    }

    public Section(double START, double STOP, String TEXT, Color COLOR, Image ICON, String STYLE_CLASS) {
        this.start = new SimpleDoubleProperty((Object)this, "start", START);
        this.startVisible = new SimpleBooleanProperty((Object)this, "startVisible", true);
        this.stop = new SimpleDoubleProperty((Object)this, "stop", STOP);
        this.stopVisible = new SimpleBooleanProperty((Object)this, " stopVisible", true);
        this.text = new SimpleStringProperty((Object)this, "text", TEXT);
        this.color = new SimpleObjectProperty((Object)this, "color", (Object)COLOR);
        this.icon = new SimpleObjectProperty((Object)this, "icon", (Object)ICON);
        this.styleClass = new SimpleStringProperty((Object)this, "styleClass", STYLE_CLASS);
    }

    public double getStart() {
        return this.start.get();
    }

    public DoubleProperty startProperty() {
        return this.start;
    }

    public void setStart(double start) {
        this.start.set(start);
    }

    public boolean getStartVisible() {
        return this.startVisible.get();
    }

    public BooleanProperty startVisibleProperty() {
        return this.startVisible;
    }

    public void setStartVisible(boolean startVisible) {
        this.startVisible.set(startVisible);
    }

    public double getStop() {
        return this.stop.get();
    }

    public DoubleProperty stopProperty() {
        return this.stop;
    }

    public void setStop(double stop) {
        this.stop.set(stop);
    }

    public boolean getStopVisible() {
        return this.stopVisible.get();
    }

    public BooleanProperty stopVisibleProperty() {
        return this.stopVisible;
    }

    public void setStopVisible(boolean stopVisible) {
        this.stopVisible.set(stopVisible);
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public Color getColor() {
        return (Color)this.color.get();
    }

    public ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color.set((Object)color);
    }

    public Image getIcon() {
        return (Image)this.icon.get();
    }

    public ObjectProperty<Image> iconProperty() {
        return this.icon;
    }

    public void setIcon(Image icon) {
        this.icon.set((Object)icon);
    }

    public String getStyleClass() {
        return (String)this.styleClass.get();
    }

    public StringProperty styleClassProperty() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass.set((Object)styleClass);
    }

    public boolean contains(double VALUE) {
        return Double.compare(VALUE, this.getStart()) >= 0 && Double.compare(VALUE, this.getStop()) <= 0;
    }

    public boolean equals(Section SECTION) {
        return Double.compare(SECTION.getStart(), this.getStart()) == 0 && Double.compare(SECTION.getStop(), this.getStop()) == 0 && SECTION.getText().equals(this.getText());
    }

    public String toString() {
        StringBuilder NAME = new StringBuilder();
        NAME.append("Section: ").append("\n");
        NAME.append("text      : ").append(this.getText()).append("\n");
        NAME.append("color     : ").append(this.getColor().toString()).append("\n");
        NAME.append("startValue: ").append(this.getStart()).append("\n");
        NAME.append("stopValue : ").append(this.getStop()).append("\n");
        return NAME.toString();
    }
}

