/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.sourceforge.javaflacencoder.AudioStreamEncoder;
import net.sourceforge.javaflacencoder.EncodingConfiguration;
import net.sourceforge.javaflacencoder.FLACEncoder;
import net.sourceforge.javaflacencoder.FLACFileOutputStream;
import net.sourceforge.javaflacencoder.StreamConfiguration;

public class FLAC_FileEncoder {
    private static final int MAX_READ = 16384;
    FLACEncoder flac = new FLACEncoder();
    StreamConfiguration sc = new StreamConfiguration();
    EncodingConfiguration ec = new EncodingConfiguration();
    File outFile = null;
    int lastTotalSamples = 0;
    boolean useThreads = true;

    public void useThreads(boolean val) {
        this.useThreads = val;
    }

    private void adjustConfigurations(AudioFormat format) {
        int sampleRate = (int)format.getSampleRate();
        int sampleSize = format.getSampleSizeInBits();
        int channels = format.getChannels();
        this.sc.setSampleRate(sampleRate);
        this.sc.setBitsPerSample(sampleSize);
        this.sc.setChannelCount(channels);
    }

    public void setStreamConfig(StreamConfiguration config) {
        this.sc = config;
    }

    public void setEncodingConfig(EncodingConfiguration config) {
        this.ec = config;
    }

    private Status openStream() {
        Status status = Status.OK;
        boolean result = this.flac.setStreamConfiguration(this.sc);
        if (!(result &= this.flac.setEncodingConfiguration(this.ec))) {
            status = Status.INTERNAL_ERROR;
        } else {
            FLACFileOutputStream fout = null;
            try {
                fout = new FLACFileOutputStream(this.outFile.getPath());
            }
            catch (IOException e) {
                status = Status.OUTPUT_FILE_ERROR;
            }
            if (status == Status.OK) {
                this.flac.setOutputStream(fout);
                try {
                    this.flac.openFLACStream();
                }
                catch (IOException e) {
                    status = Status.INTERNAL_ERROR;
                }
            } else {
                status = Status.OUTPUT_FILE_ERROR;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status encode(File inputFile, File outputFile) {
        AudioFormat format;
        AudioInputStream sin;
        Status status;
        block11: {
            status = Status.FULL_ENCODE;
            this.outFile = outputFile;
            sin = null;
            format = null;
            try {
                sin = AudioSystem.getAudioInputStream(inputFile);
            }
            catch (IOException e) {
                status = Status.FILE_IO_ERROR;
                return status;
            }
            catch (UnsupportedAudioFileException e) {
                status = Status.UNSUPPORTED_FILE;
                return status;
            }
            finally {
                if (status == Status.FULL_ENCODE) break block11;
                return status;
            }
        }
        try {
            format = sin.getFormat();
            this.adjustConfigurations(format);
            this.openStream();
            AudioStreamEncoder.encodeAudioInputStream(sin, 16384, this.flac, this.useThreads);
        }
        catch (IOException e) {
            status = Status.FILE_IO_ERROR;
        }
        catch (IllegalArgumentException e) {
            status = Status.GENERAL_ERROR;
            String message = e.getMessage();
            if (message.equals(Status.UNSUPPORTED_SAMPLE_SIZE.name())) {
                status = Status.UNSUPPORTED_SAMPLE_SIZE;
            }
            throw e;
        }
        return status;
    }

    public int getLastTotalSamplesEncoded() {
        return this.lastTotalSamples;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNKNOWN,
        FULL_ENCODE,
        GENERAL_ERROR,
        INTERNAL_ERROR,
        UNSUPPORTED_FILE,
        FILE_IO_ERROR,
        UNSUPPORTED_SAMPLE_SIZE,
        OUTPUT_FILE_ERROR,
        OK;

    }
}

