package com.github.azbh111.utils.java.exception;

/**
 * 被拦截时抛异常
 * web层应该处理此异常
 *
 * @author: zyp
 * @date: 2020/1/13 4:43 PM
 */
public class InterceptedException extends RuntimeException {
    private int status = 200;
    private String errorMsg;
    private Object data;

    public InterceptedException() {
    }

    public InterceptedException(String message) {
        super(message);
    }

    public InterceptedException(String message, Throwable cause) {
        super(message, cause);
    }

    public InterceptedException(Throwable cause) {
        super(cause);
    }

    public InterceptedException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public int getStatus() {
        return status;
    }

    public InterceptedException setStatus(int status) {
        this.status = status;
        return this;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public InterceptedException setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public Object getData() {
        return data;
    }

    public InterceptedException setData(Object data) {
        this.data = data;
        return this;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        return String.format("status=%s, errorMsg=%s, data=%s, message=%s", status, errorMsg, data, message);
    }
}
