package com.github.azbh111.utils.java.lang;

import java.util.function.Supplier;

/**
 * @author pyz
 * @date 2019/5/4 4:03 PM
 */
public class LazyField<T> {
    private volatile T value;
    private final Supplier<T> supplier;
    private final Object lock = new Object();

    private LazyField(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static <T> LazyField<T> from(Supplier<T> supplier) {
        return new LazyField<>(supplier);
    }

    public T get() {
        if (value == null) {
            synchronized (lock) {
                if (value == null) {
                    value = supplier.get();
                }
            }
        }
        return value;
    }

    public LazyField<T> set(T value) {
        synchronized (lock) {
            this.value = value;
        }
        return this;
    }
}
