package com.github.azbh111.utils.java.person;

import com.github.azbh111.utils.java.model.Res;
import com.github.azbh111.utils.java.date.DateUtils;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

/**
 * @author: zyp
 * @date: 2020/3/30 11:53 AM
 */
public class IdCardUtils {
    /**
     * 地区编码
     */
    private static final Map<String, String> regionMap = new HashMap<>();
    private static final char[] ValCodeArr = {'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
    private static final int[] Wi = {7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};

    static {
        regionMap.put("11", "北京");
        regionMap.put("12", "天津");
        regionMap.put("13", "河北");
        regionMap.put("14", "山西");
        regionMap.put("15", "内蒙古");
        regionMap.put("21", "辽宁");
        regionMap.put("22", "吉林");
        regionMap.put("23", "黑龙江");
        regionMap.put("31", "上海");
        regionMap.put("32", "江苏");
        regionMap.put("33", "浙江");
        regionMap.put("34", "安徽");
        regionMap.put("35", "福建");
        regionMap.put("36", "江西");
        regionMap.put("37", "山东");
        regionMap.put("41", "河南");
        regionMap.put("42", "湖北");
        regionMap.put("43", "湖南");
        regionMap.put("44", "广东");
        regionMap.put("45", "广西");
        regionMap.put("46", "海南");
        regionMap.put("50", "重庆");
        regionMap.put("51", "四川");
        regionMap.put("52", "贵州");
        regionMap.put("53", "云南");
        regionMap.put("54", "西藏");
        regionMap.put("61", "陕西");
        regionMap.put("62", "甘肃");
        regionMap.put("63", "青海");
        regionMap.put("64", "宁夏");
        regionMap.put("65", "新疆");
        regionMap.put("71", "台湾");
        regionMap.put("81", "香港");
        regionMap.put("82", "澳门");
        regionMap.put("91", "国外");
    }

    /**
     * 身份证的有效验证
     *
     * @param idChard
     * @return
     */
    public static Res idCardValidate(String idChard) {
        // 号码的长度 15位或18位
        if (idChard.length() != 15 && idChard.length() != 18) {
            return Res.fail("身份证号码长度应该为18位。");
        }
        // 数字 除最后以为都为数字
        int length = idChard.length();
        for (int i = 0; i < length; i++) {
            if (Character.isDigit(idChard.charAt(i))) {
                continue;
            }
            if (i == length - 1 && idChard.charAt(i) == 'X') {
                continue;
            }
            return Res.fail("身份证除最后一位可以是X，其余都应是数字。");
        }
        // 出生年月是否有效
        String birthStr = idChard.substring(6, 14);
        LocalDate birth = null;
        try {
            birth = DateUtils.parse(birthStr, "yyyyMMdd");
        } catch (Throwable x) {
            return Res.fail("身份证生日无效。");
        }
        if (birth.isAfter(LocalDate.now()) || birth.getYear() < 1900) {
            return Res.fail("身份证生日不在有效范围。");
        }
        // 地区码时候有效
        if (regionMap.containsKey(idChard.substring(0, 2))) {
            return Res.fail("身份证地区编码错误。");
        }

        // 判断最后一位的值
        int verifyCodeInt = 0;
        for (int i = 0; i < 17; i++) {
            verifyCodeInt = verifyCodeInt + Integer.parseInt(String.valueOf(idChard.charAt(i))) * Wi[i];
        }
        int mod11 = verifyCodeInt % 11;
        char verifyCode = ValCodeArr[mod11];
        char lastCode = idChard.charAt(length - 1);
        if (verifyCode == 'X' && (lastCode == 'X' || lastCode == 'x')) {
//            x不区分大小写
            return Res.empty();
        }
        if (verifyCode != lastCode) {
            return Res.fail("身份证校验码错误。");
        }
        return Res.empty();
    }


}
