package com.github.azbh111.utils.java.reflect.model;

import com.github.azbh111.utils.java.unsafe.UnsafeUtils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author pyz
 * @date 2019/3/2 11:54 AM
 */
public class ClassCopyDesc<T> {
    private Class<T> clazz;
    private List<UnsafeField> fields = new ArrayList<>();
    private Constructor constructor;

    private ClassCopyDesc() {
    }

    public static <T> ClassCopyDesc<T> of(Class<T> clazz) {
        ClassCopyDesc<T> copyer = new ClassCopyDesc<T>();
        copyer.clazz = clazz;
        try {
            copyer.constructor = clazz.getConstructor(new Class[0]);
            copyer.constructor.setAccessible(true);
        } catch (NoSuchMethodException e) {
            // no none parameter constructor
        }
        Class currentClass = clazz;
        while (currentClass != null) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) {
                    continue;
                }
                UnsafeField uf = UnsafeField.builder()
                        .field(field)
                        .offset(UnsafeUtils.objectFieldOffset(field))
                        .type(field.getType())
                        .build();
                copyer.getFields().add(uf);
            }
            currentClass = currentClass.getSuperclass();
        }
        return copyer;
    }

    public T newInstance() throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (constructor != null) {
            return (T) constructor.newInstance();
        }
        return (T) UnsafeUtils.allocateInstance(clazz);
    }

    public Class<T> getClazz() {
        return clazz;
    }

    public List<UnsafeField> getFields() {
        return fields;
    }

    public Constructor getConstructor() {
        return constructor;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("ClassCopyDesc{");
        sb.append("clazz=").append(clazz);
        sb.append(", fields=").append(fields);
        sb.append(", constructor=").append(constructor);
        sb.append('}');
        return sb.toString();
    }
}
