package com.github.azbh111.utils.java.reflect.model;

import com.github.azbh111.utils.java.reflect.ReflectUtils;
import lombok.ToString;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;

/**
 * @author pyz
 * @date 2018/10/7 上午8:46
 */
@ToString(callSuper = true)
public class FieldFilter extends CommonFilter<FieldFilter> implements Predicate<Field> {

    private Class type;
    private Boolean static_;
    private Boolean final_;
    private Integer index;

    private FieldFilter() {
    }

    public static FieldFilter create() {
        return new FieldFilter();
    }

    public Class getType() {
        return type;
    }

    public FieldFilter setType(Class type) {
        this.type = type;
        return this;
    }

    public Boolean getStatic() {
        return static_;
    }

    public FieldFilter setStatic(Boolean static_) {
        this.static_ = static_;
        return this;
    }

    public Boolean getFinal() {
        return final_;
    }

    public FieldFilter setFinal(Boolean final_) {
        this.final_ = final_;
        return this;
    }

    public Integer getIndex() {
        return index;
    }

    public FieldFilter setIndex(Integer index) {
        this.index = index;
        return this;
    }

    @Override
    public boolean test(Field wf) {
        if (static_ != null) {
            if (static_ != Modifier.isStatic(wf.getModifiers())) {
                return false;
            }
        }
        if (final_ != null) {
            if (final_ != Modifier.isFinal(wf.getModifiers())) {
                return false;
            }
        }
        if (!super.filter(wf.getName())) {
            return false;
        }
        if (type != null && wf.getType() != type) {
            return false;
        }
        if (getAnnotationType() != null) {
            if (ReflectUtils.findAnnotation(wf, getAnnotationType()) == null) {
                return false;
            }
        }
        return true;
    }
}
