package com.github.azbh111.utils.java.sys;

/**
 *
 * @author pyz
 * @date 2019/11/26 11:12 上午
 */
public class EnvironmentUtils {

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getSimpleJavaVersion() {
        String[] var0 = getJavaVersion().split("\\.");
        return var0[0] + "." + var0[1];
    }

    public static boolean isJRE6() {
        return getJavaVersion().startsWith("1.6");
    }

    public static boolean isJRE9() {
        return getJavaVersion().startsWith("9");
    }

    public static boolean is64Bit() {
        String var0 = System.getProperty("os.arch");
        return "amd64".equals(var0) || "x86_64".equals(var0);
    }

    public static boolean is32Bit() {
        String var0 = System.getProperty("os.arch");
        return "x86".equals(var0) || "i386".equals(var0);
    }

    public static String getWin32UserAppDataLocalDir() {
        if (!OSUtils.isWindows()) {
            throw new IllegalStateException("Unsupported operating system.");
        } else {
            return System.getenv("LOCALAPPDATA");
        }
    }

    public static boolean isJavaFX() {
        return !System.getProperty("javafx.version", "0").equals("0");
    }

    public static String getUserTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

}
