/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.digest;

import com.github.azbh111.utils.java.code.HexUtils;
import com.github.azbh111.utils.java.digest.DigestAlgorithm;
import com.github.azbh111.utils.java.exception.ExceptionUtils;
import com.github.azbh111.utils.java.lang.io.CharSequenceInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    public static byte[] digest(InputStream in, DigestAlgorithm algorithm) throws IOException {
        try {
            int n;
            MessageDigest md = MessageDigest.getInstance(algorithm.getName());
            byte[] buf = new byte[1024];
            while ((n = in.read(buf)) != -1) {
                md.update(buf, 0, n);
            }
            buf = md.digest();
            md.reset();
            return buf;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String digestHexLowerCase(InputStream in, DigestAlgorithm algorithm) throws IOException {
        return HexUtils.hexLowerCaseEncode(DigestUtils.digest(in, algorithm));
    }

    public static String digestHexUpperCase(InputStream in, DigestAlgorithm algorithm) throws IOException {
        return HexUtils.hexUpperCaseEncode(DigestUtils.digest(in, algorithm));
    }

    public static byte[] digest(File file, DigestAlgorithm algorithm) throws IOException {
        return DigestUtils.digest(DigestUtils.wrap(file), algorithm);
    }

    public static String digestHexLowerCase(File in, DigestAlgorithm algorithm) throws IOException {
        return HexUtils.hexLowerCaseEncode(DigestUtils.digest(in, algorithm));
    }

    public static String digestHexUpperCase(File in, DigestAlgorithm algorithm) throws IOException {
        return HexUtils.hexUpperCaseEncode(DigestUtils.digest(in, algorithm));
    }

    public static byte[] digest(byte[] input, DigestAlgorithm algorithm) {
        try {
            return DigestUtils.digest(DigestUtils.wrap(input), algorithm);
        }
        catch (IOException e) {
            ExceptionUtils.throwException(e);
            return null;
        }
    }

    public static String digestHexLowerCase(byte[] in, DigestAlgorithm algorithm) {
        return HexUtils.hexLowerCaseEncode(DigestUtils.digest(in, algorithm));
    }

    public static String digestHexUpperCase(byte[] in, DigestAlgorithm algorithm) {
        return HexUtils.hexUpperCaseEncode(DigestUtils.digest(in, algorithm));
    }

    public static byte[] digest(CharSequence input, DigestAlgorithm algorithm) {
        try {
            return DigestUtils.digest(DigestUtils.wrap(input), algorithm);
        }
        catch (IOException e) {
            ExceptionUtils.throwException(e);
            return null;
        }
    }

    public static String digestHexLowerCase(CharSequence in, DigestAlgorithm algorithm) {
        return HexUtils.hexLowerCaseEncode(DigestUtils.digest(in, algorithm));
    }

    public static String digestHexUpperCase(CharSequence in, DigestAlgorithm algorithm) {
        return HexUtils.hexUpperCaseEncode(DigestUtils.digest(in, algorithm));
    }

    private static InputStream wrap(byte[] input) {
        return new ByteArrayInputStream(input);
    }

    private static InputStream wrap(CharSequence input) {
        return new CharSequenceInputStream(input, StandardCharsets.UTF_8, Math.min(Math.max(input.length() / 10, 128), 1024));
    }

    private static InputStream wrap(File input) throws FileNotFoundException {
        return new FileInputStream(input);
    }
}

