/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.jvm;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JVM {
    private static JVM instance = new JVM();
    private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private final List<MemoryPoolMXBean> memoryPoolMXBeans = Collections.unmodifiableList(ManagementFactory.getMemoryPoolMXBeans());
    private final List<GarbageCollectorMXBean> garbageCollectorMXBeans = Collections.unmodifiableList(ManagementFactory.getGarbageCollectorMXBeans());

    private JVM() {
    }

    public static JVM getInstance() {
        return instance;
    }

    public List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return this.garbageCollectorMXBeans;
    }

    public List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return this.memoryPoolMXBeans;
    }

    public int getObjectPendingFinalizationCount() {
        return this.memoryMXBean.getObjectPendingFinalizationCount();
    }

    public MemoryUsage getHeapMemoryUsage() {
        return this.memoryMXBean.getHeapMemoryUsage();
    }

    public MemoryUsage getNonHeapMemoryUsage() {
        return this.memoryMXBean.getNonHeapMemoryUsage();
    }

    public void gc() {
        this.memoryMXBean.gc();
    }

    public String getArch() {
        return this.operatingSystemMXBean.getArch();
    }

    public String getVersion() {
        return this.operatingSystemMXBean.getVersion();
    }

    public int getAvailableProcessors() {
        return this.operatingSystemMXBean.getAvailableProcessors();
    }

    public double getSystemLoadAverage() {
        return this.operatingSystemMXBean.getSystemLoadAverage();
    }

    public long getTotalLoadedClassCount() {
        return this.classLoadingMXBean.getTotalLoadedClassCount();
    }

    public int getLoadedClassCount() {
        return this.classLoadingMXBean.getLoadedClassCount();
    }

    public long getUnloadedClassCount() {
        return this.classLoadingMXBean.getUnloadedClassCount();
    }

    public int getThreadCount() {
        return this.threadMXBean.getThreadCount();
    }

    public int getPeakThreadCount() {
        return this.threadMXBean.getPeakThreadCount();
    }

    public long getTotalStartedThreadCount() {
        return this.threadMXBean.getTotalStartedThreadCount();
    }

    public int getDaemonThreadCount() {
        return this.threadMXBean.getDaemonThreadCount();
    }

    public long[] getAllThreadIds() {
        return this.threadMXBean.getAllThreadIds();
    }

    public ThreadInfo getThreadInfo(long id) {
        return this.threadMXBean.getThreadInfo(id);
    }

    public ThreadInfo[] getThreadInfo(long[] ids) {
        return this.threadMXBean.getThreadInfo(ids);
    }

    public ThreadInfo getThreadInfo(long id, int maxDepth) {
        return this.threadMXBean.getThreadInfo(id, maxDepth);
    }

    public ThreadInfo[] getThreadInfo(long[] ids, int maxDepth) {
        return this.threadMXBean.getThreadInfo(ids, maxDepth);
    }

    public boolean isThreadContentionMonitoringSupported() {
        return this.threadMXBean.isThreadContentionMonitoringSupported();
    }

    public boolean isThreadContentionMonitoringEnabled() {
        return this.threadMXBean.isThreadContentionMonitoringEnabled();
    }

    public void setThreadContentionMonitoringEnabled(boolean enable) {
        this.threadMXBean.setThreadContentionMonitoringEnabled(enable);
    }

    public long getCurrentThreadCpuTime() {
        return this.threadMXBean.getCurrentThreadCpuTime();
    }

    public long getCurrentThreadUserTime() {
        return this.threadMXBean.getCurrentThreadUserTime();
    }

    public long getThreadCpuTime(long id) {
        return this.threadMXBean.getThreadCpuTime(id);
    }

    public long getThreadUserTime(long id) {
        return this.threadMXBean.getThreadUserTime(id);
    }

    public boolean isThreadCpuTimeSupported() {
        return this.threadMXBean.isThreadCpuTimeSupported();
    }

    public boolean isCurrentThreadCpuTimeSupported() {
        return this.threadMXBean.isCurrentThreadCpuTimeSupported();
    }

    public boolean isThreadCpuTimeEnabled() {
        return this.threadMXBean.isThreadCpuTimeEnabled();
    }

    public void setThreadCpuTimeEnabled(boolean enable) {
        this.threadMXBean.setThreadCpuTimeEnabled(enable);
    }

    public long[] findMonitorDeadlockedThreads() {
        return this.threadMXBean.findMonitorDeadlockedThreads();
    }

    public void resetPeakThreadCount() {
        this.threadMXBean.resetPeakThreadCount();
    }

    public long[] findDeadlockedThreads() {
        return this.threadMXBean.findDeadlockedThreads();
    }

    public boolean isObjectMonitorUsageSupported() {
        return this.threadMXBean.isObjectMonitorUsageSupported();
    }

    public boolean isSynchronizerUsageSupported() {
        return this.threadMXBean.isSynchronizerUsageSupported();
    }

    public ThreadInfo[] getThreadInfo(long[] ids, boolean lockedMonitors, boolean lockedSynchronizers) {
        return this.threadMXBean.getThreadInfo(ids, lockedMonitors, lockedSynchronizers);
    }

    public ThreadInfo[] dumpAllThreads(boolean lockedMonitors, boolean lockedSynchronizers) {
        return this.threadMXBean.dumpAllThreads(lockedMonitors, lockedSynchronizers);
    }

    public String getName() {
        return this.runtimeMXBean.getName();
    }

    public String getVmName() {
        return this.runtimeMXBean.getVmName();
    }

    public String getVmVendor() {
        return this.runtimeMXBean.getVmVendor();
    }

    public String getVmVersion() {
        return this.runtimeMXBean.getVmVersion();
    }

    public String getSpecName() {
        return this.runtimeMXBean.getSpecName();
    }

    public String getSpecVendor() {
        return this.runtimeMXBean.getSpecVendor();
    }

    public String getSpecVersion() {
        return this.runtimeMXBean.getSpecVersion();
    }

    public String getManagementSpecVersion() {
        return this.runtimeMXBean.getManagementSpecVersion();
    }

    public String getClassPath() {
        return this.runtimeMXBean.getClassPath();
    }

    public String getLibraryPath() {
        return this.runtimeMXBean.getLibraryPath();
    }

    public boolean isBootClassPathSupported() {
        return this.runtimeMXBean.isBootClassPathSupported();
    }

    public String getBootClassPath() {
        return this.runtimeMXBean.getBootClassPath();
    }

    public List<String> getInputArguments() {
        return this.runtimeMXBean.getInputArguments();
    }

    public long getUptime() {
        return this.runtimeMXBean.getUptime();
    }

    public long getStartTime() {
        return this.runtimeMXBean.getStartTime();
    }

    public Map<String, String> getSystemProperties() {
        return this.runtimeMXBean.getSystemProperties();
    }
}

