/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.lang;

import java.util.function.Supplier;

public class ThreadLocalLazyField<T> {
    private final ThreadLocal<T> threadLocal = new ThreadLocal();
    private final Supplier<T> supplier;

    private ThreadLocalLazyField(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static <T> ThreadLocalLazyField<T> from(Supplier<T> supplier) {
        return new ThreadLocalLazyField<T>(supplier);
    }

    public T get() {
        T value = this.threadLocal.get();
        if (value == null) {
            value = this.supplier.get();
            this.threadLocal.set(value);
        }
        return value;
    }

    public ThreadLocalLazyField<T> set(T value) {
        this.threadLocal.set(value);
        return this;
    }
}

