/*
 * Decompiled with CFR 0.152.
 */
package com.github.azbh111.utils.java.model;

import java.io.Serializable;
import java.util.function.Function;

public class Res<T>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1067562144473066103L;
    public static int defaultFailStatus = 400;
    public static int defaultSuccessStatus = 200;
    private T data;
    private int status = defaultSuccessStatus;
    private String errorMsg;

    public static <T> Res<T> empty() {
        return new Res<T>();
    }

    public static <T> Res<T> success(T data) {
        return new Res<T>().setData(data);
    }

    public static <T> Res<T> fail(int status) {
        return Res.fail(null, status, null, new Object[0]);
    }

    public static <T> Res<T> fail(String errorMsg, Object ... os) {
        return Res.fail(null, defaultFailStatus, errorMsg, os);
    }

    public static <T> Res<T> fail(int status, String errorMsg, Object ... os) {
        return Res.fail(null, status, errorMsg, os);
    }

    public static <T> Res<T> fail(T data, int status, String errorMsg, Object ... os) {
        return new Res<T>().setData(data).setStatus(status).errorMsg(errorMsg, os);
    }

    public Res eraseGeneric() {
        return this;
    }

    public Res<T> apply(Res<T> res) {
        this.status = res.status;
        this.data = res.data;
        this.errorMsg = res.errorMsg;
        return this;
    }

    public Res<T> mapIfNecessary(Function<Res<T>, Res<T>> mapper) {
        if (this.isFail()) {
            return this;
        }
        Res<T> res = mapper.apply(this);
        if (res == null) {
            return this;
        }
        this.apply(res);
        return this;
    }

    public Res<T> success() {
        this.status = 200;
        return this;
    }

    public Res<T> fail() {
        this.status = defaultFailStatus;
        return this;
    }

    public boolean isSuccess() {
        return this.status == defaultSuccessStatus;
    }

    public boolean isFail() {
        return this.status != defaultSuccessStatus;
    }

    public T getData() {
        return this.data;
    }

    public Res<T> setData(T data) {
        this.data = data;
        return this;
    }

    public Res<T> data(T data) {
        this.data = data;
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public Res<T> setStatus(int status) {
        this.status = status;
        return this;
    }

    public Res<T> status(int status) {
        this.status = status;
        return this;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Res<T> setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public Res<T> errorMsg(String errorMsg, Object ... os) {
        this.errorMsg = String.format(errorMsg, os);
        return this;
    }

    public Res<T> clone() {
        Res<T> res = Res.empty();
        res.status = this.status;
        res.data = this.data;
        res.errorMsg = this.errorMsg;
        return res;
    }

    public String toString() {
        return "Res{data=" + this.data + ", status=" + this.status + ", errorMsg='" + this.errorMsg + '\'' + '}';
    }
}

