package com.github.azbh111.utils.java.image;

import com.github.azbh111.utils.java.image.val.ImageMetadata;

import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import java.io.*;
import java.net.URL;
import java.util.Iterator;

/**
 * @author: zyp
 * @date: 2020/6/28 9:44 下午
 */
public class ImageUtils {



    /**
     * 判断是否是文件
     *
     * @param input
     * @return
     */
    public boolean isImage(ImageInputStream input) {
        if (input == null) {
            return false;
        }
        return ImageIO.getImageReaders(input).hasNext();
    }

    /**
     * 判断是否是文件
     *
     * @param input
     * @return
     */
    public boolean isImage(InputStream input) throws IOException {
        if (input == null) {
            return false;
        }
        return isImage(ImageIO.createImageInputStream(input));
    }

    /**
     * 判断是否是文件
     *
     * @param input
     * @return
     */
    public boolean isImage(File input) throws IOException {
        if (input == null) {
            return false;
        }
        try (InputStream stream = new FileInputStream(input)) {
            return isImage(stream);
        }
    }

    /**
     * 判断是否是文件
     *
     * @param input
     * @return
     */
    public boolean isImage(URL input) throws IOException {
        if (input == null) {
            return false;
        }
        try (InputStream stream = input.openStream()) {
            return isImage(stream);
        }
    }

    /**
     * 读取图片格式和尺寸
     *
     * @param inputStream
     * @return
     * @throws IOException
     */
    public static ImageMetadata readImageMetadata(ImageInputStream iis) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
        if (!readers.hasNext()) {
            return null;
        }
        ImageReader reader = readers.next();
        reader.setInput(iis, true);
        ImageMetadata meta = new ImageMetadata();
        meta.setWidth(reader.getWidth(0));
        meta.setHeight(reader.getHeight(0));
        meta.setFormat(reader.getFormatName());
        reader.getHeight(0);
        int channel = reader.getImageTypes(0)
                .next()
                .getSampleModel()
                .getNumDataElements();
        meta.setChannel(channel);
        return meta;
    }

    /**
     * 读取图片格式和尺寸
     *
     * @param file
     * @return
     * @throws IOException
     */
    public static ImageMetadata readImageMetadata(File file) throws IOException {
        try (InputStream stream = new FileInputStream(file)) {
            return readImageMetadata(stream);
        }
    }

    /**
     * 读取图片格式和尺寸
     *
     * @param url
     * @return
     * @throws IOException
     */
    public static ImageMetadata readImageMetadata(URL url) throws IOException {
        try (InputStream stream = url.openStream()) {
            return readImageMetadata(stream);
        }
    }

    /**
     * 读取图片格式和尺寸
     *
     * @param stream
     * @return
     * @throws IOException
     */
    public static ImageMetadata readImageMetadata(InputStream stream) throws IOException {
        return readImageMetadata(ImageIO.createImageInputStream(stream));
    }
}
