package com.github.azbh111.utils.java.money;

import java.math.BigDecimal;

/**
 *
 * @author pyz
 * @date 2019/4/29 7:42 PM
 */
public class MoneyUtils {

    private static final BigDecimal one_hundred = BigDecimal.valueOf(100);
    // Predefine the radix characters and currency symbols for output:
    private static final String CN_ZERO = "零";
    private static final String CN_ONE = "壹";
    private static final String CN_TWO = "贰";
    private static final String CN_THREE = "叁";
    private static final String CN_FOUR = "肆";
    private static final String CN_FIVE = "伍";
    private static final String CN_SIX = "陆";
    private static final String CN_SEVEN = "柒";
    private static final String CN_EIGHT = "捌";
    private static final String CN_NINE = "玖";
    private static final String CN_TEN = "拾";
    private static final String CN_HUNDRED = "佰";
    private static final String CN_THOUSAND = "仟";
    private static final String CN_TEN_THOUSAND = "万";
    private static final String CN_HUNDRED_MILLION = "亿";
    private static final String CN_SYMBOL = "";
    private static final String CN_DOLLAR = "元";
    private static final String CN_TEN_CENT = "角";
    private static final String CN_CENT = "分";
    private static final String CN_INTEGER = "整";
    // Prepare the characters corresponding to the digits:
    private static final String[] digits = new String[]{CN_ZERO, CN_ONE, CN_TWO, CN_THREE, CN_FOUR, CN_FIVE, CN_SIX, CN_SEVEN, CN_EIGHT, CN_NINE};
    private static final String[] radices = new String[]{"", CN_TEN, CN_HUNDRED, CN_THOUSAND};
    private static final String[] bigRadices = new String[]{"", CN_TEN_THOUSAND, CN_HUNDRED_MILLION};
    private static final String[] decimals = new String[]{CN_TEN_CENT, CN_CENT};
    // Constants:
    private static final BigDecimal MAXIMUM_NUMBER = BigDecimal.valueOf(99999999999.99);

    /**
     * 人民币大写
     *
     * 有效范围 [-99999999999.99, 99999999999.99]
     *
     * @param money
     * @return
     */
    public static String toChineseUpperCase(BigDecimal money) {
        // The output result.
        StringBuilder outputCharacters = new StringBuilder();
        if (money.signum() < 0) {
            outputCharacters.append("负");
            money = money.abs();
        }
        // Assert the number is not greater than the maximum number.
        if (money.compareTo(MAXIMUM_NUMBER) > 0) {
            throw new IllegalArgumentException("Too large a number to convert!");
        }

        // Represent integral part of digit number.
        long integral = money.longValue();
        // Represent integral part of digit number.
        int decimal = money.subtract(BigDecimal.valueOf(integral)).multiply(one_hundred).intValue();


        int zeroCount;
        int i, p, d, ds;
        int quotient, modulus;

        // Process integral part if it is larger than 0:
        if (integral > 0) {
            zeroCount = 0;
            String str = Long.toString(integral);
            for (i = 0; i < str.length(); i++) {
                p = str.length() - i - 1;
                d = str.charAt(i) - '0';
                quotient = p / 4;
                modulus = p % 4;
                if (d == 0) {
                    zeroCount++;
                } else {
                    if (zeroCount > 0) {
                        outputCharacters.append(digits[0]);
                    }
                    zeroCount = 0;
                    outputCharacters.append(digits[d]).append(radices[modulus]);
                }
                if (modulus == 0 && zeroCount < 4) {
                    outputCharacters.append(bigRadices[quotient]);
                }
            }
            outputCharacters.append(CN_DOLLAR);
        }
        // Process decimal part if there is:
        if (decimal > 0) {
            String str = decimal < 10 ? "0" + Long.toString(decimal) : Long.toString(decimal);
            for (i = 0; i < str.length(); i++) {
                d = str.charAt(i) - '0';
                ds = str.charAt(str.length() - 1) - '0';
                if (d == 0) {
                    if (ds == 0) {
                    } else {
                        outputCharacters.append(digits[d]);
                    }
                } else {
                    outputCharacters.append(digits[d]).append(decimals[i]);
                }
            }
        }
        // Confirm and return the final output string:
        if (outputCharacters.length() == 0) {
            outputCharacters.append(CN_ZERO).append(CN_DOLLAR);
        }
        if (decimal == 0) {
            outputCharacters.append(CN_INTEGER);
        }
        return outputCharacters.toString();
    }


    /**
     * 将total尽量平均分成num份,保证分配后各个值加起来等于total
     *
     * @param total
     * @param num
     * @return
     */
    public static long[] average(long total, int num) {
        boolean negative = total < 0;
        if (negative) {
            total = -total;
        }
        long[] averages = new long[num];
        if (num == 1) {
            averages[0] = total;
        } else {
            long average = total / num;
            long left = total - average * num;
            for (int i = 0; i < num; i++) {
                if (i < left) {
                    averages[i] = average + 1;
                } else {
                    averages[i] = average;
                }
            }
        }
        if (negative) {
            for (int i = 0; i < averages.length; i++) {
                averages[i] = -averages[i];
            }
        }
        return averages;
    }

}
